/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.craftgui.minecraft.control;

import binnie.core.craftgui.CraftGUI;
import binnie.core.craftgui.IWidget;
import binnie.core.craftgui.WidgetAttribute;
import binnie.core.craftgui.controls.core.Control;
import binnie.core.craftgui.geometry.IArea;
import binnie.core.craftgui.geometry.IBorder;
import binnie.core.craftgui.geometry.IPoint;
import binnie.core.craftgui.geometry.Position;
import binnie.core.craftgui.geometry.TextJustification;
import binnie.core.craftgui.resource.Texture;
import binnie.core.craftgui.resource.minecraft.CraftGUITexture;
import org.lwjgl.opengl.GL11;

public class ControlSlide
extends Control {
    private final IArea expanded;
    private final IArea shrunk;
    private boolean slideActive = true;
    private final Position anchor;
    private String label = null;

    public ControlSlide(IWidget parent, float x, float y, float w, float h, Position anchor2) {
        super(parent, x, y, w, h);
        this.addAttribute(WidgetAttribute.MOUSE_OVER);
        this.addAttribute(WidgetAttribute.BLOCK_TOOLTIP);
        this.expanded = new IArea(this.getPosition(), this.getSize());
        this.anchor = anchor2.opposite();
        float border = this.anchor.x() != 0 ? this.expanded.w() - 6.0f : this.expanded.h() - 6.0f;
        this.shrunk = this.expanded.inset(new IBorder(this.anchor, border));
        this.slideActive = false;
    }

    @Override
    public void onRenderBackground() {
        super.onRenderBackground();
        if (this.label != null) {
            float lw = CraftGUI.render.textWidth(this.label) + 16;
            float lh = CraftGUI.render.textHeight() + 16;
            boolean hor = this.anchor.x() != 0;
            IArea ar = this.isSlideActive() ? this.expanded : this.shrunk;
            IArea tabArea = new IArea(hor ? -lh / 2.0f : -lw / 2.0f, hor ? -lw / 2.0f : -lh / 2.0f, hor ? lh : lw, hor ? lw : lh);
            IPoint shift = new IPoint(ar.w() * (float)(1 - this.anchor.x()) / 2.0f, ar.h() * (float)(1 - this.anchor.y()) / 2.0f);
            tabArea = tabArea.shift(shift.x() - (-3.0f + lh / 2.0f) * (float)this.anchor.x(), shift.y() - (-3.0f + lh / 2.0f) * (float)this.anchor.y());
            Texture texture = CraftGUI.render.getTexture((Object)(this.isSlideActive() ? CraftGUITexture.Tab : CraftGUITexture.TabDisabled)).crop(this.anchor.opposite(), 8.0f);
            CraftGUI.render.texture(texture, tabArea);
            texture = CraftGUI.render.getTexture((Object)CraftGUITexture.TabOutline).crop(this.anchor.opposite(), 8.0f);
            CraftGUI.render.texture(texture, tabArea.inset(2));
            IArea labelArea = new IArea(-lw / 2.0f, 0.0f, lw, lh);
            GL11.glPushMatrix();
            GL11.glTranslatef((float)(shift.x() + (float)this.anchor.x() * 2.0f), (float)(shift.y() + (float)this.anchor.y() * 2.0f), (float)0.0f);
            if (this.anchor.x() != 0) {
                GL11.glRotatef((float)90.0f, (float)0.0f, (float)0.0f, (float)this.anchor.x());
            }
            if (this.anchor.y() > 0) {
                GL11.glTranslatef((float)0.0f, (float)(-lh), (float)0.0f);
            }
            CraftGUI.render.text(labelArea, TextJustification.MIDDLE_CENTER, this.label, 0xFFFFFF);
            GL11.glPopMatrix();
        }
        CraftGUI.render.texture((Object)CraftGUITexture.Window, this.getArea());
        CraftGUITexture slideTexture = this.anchor == Position.BOTTOM ? CraftGUITexture.SlideDown : (this.anchor == Position.TOP ? CraftGUITexture.SlideUp : (this.anchor == Position.LEFT ? CraftGUITexture.SlideLeft : CraftGUITexture.SlideRight));
        CraftGUI.render.texture((Object)slideTexture, new IPoint(((float)this.anchor.x() + 1.0f) * this.w() / 2.0f - 8.0f, ((float)this.anchor.y() + 1.0f) * this.h() / 2.0f - 8.0f));
    }

    public boolean isSlideActive() {
        return this.slideActive;
    }

    @Override
    public void onUpdateClient() {
        boolean mouseOver = this.isMouseOverWidget(this.getRelativeMousePosition());
        if (mouseOver != this.slideActive) {
            this.setSlide(mouseOver);
        }
    }

    @Override
    public boolean isMouseOverWidget(IPoint relativeMouse) {
        return this.getArea().outset(this.isSlideActive() ? 16 : 8).outset(new IBorder(this.anchor.opposite(), 16.0f)).contains(relativeMouse);
    }

    @Override
    public boolean isChildVisible(IWidget child) {
        return this.slideActive;
    }

    public void setSlide(boolean b) {
        this.slideActive = b;
        IArea area = this.isSlideActive() ? this.expanded : this.shrunk;
        this.setSize(area.size());
        this.setPosition(area.pos());
    }

    public void setLabel(String l) {
        this.label = l;
    }
}

