/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.modularui.api.math;

import com.gtnewhorizons.modularui.common.widget.textfield.TextFieldWidget;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class MathExpression {
    private static final List<Object> DEFAULT = Collections.singletonList(0);

    public static double parseMathExpression(String expr) {
        return MathExpression.parseMathExpression(expr, 0.0);
    }

    public static double parseMathExpression(String expr, double onFailReturn) {
        Double result;
        Double right;
        Double left;
        Object obj;
        int i;
        List<Object> parsed = MathExpression.buildParsedList(expr, onFailReturn);
        if (parsed == DEFAULT || parsed.size() == 0) {
            return onFailReturn;
        }
        if (parsed.size() == 1) {
            Object value = parsed.get(0);
            return value instanceof Double ? (Double)value : onFailReturn;
        }
        if (Operator.MINUS == parsed.get(0)) {
            parsed.remove(0);
            parsed.set(0, -((Double)parsed.get(0)).doubleValue());
        }
        for (i = 1; i < parsed.size(); ++i) {
            obj = parsed.get(i);
            if (!(obj instanceof Suffix)) continue;
            left = (Double)parsed.get(i - 1);
            Double result2 = left * ((Suffix)((Object)obj)).multiplier;
            parsed.remove(i - 1);
            parsed.remove(i - 1);
            parsed.add(i - 1, result2);
            --i;
        }
        for (i = 1; i < parsed.size() - 1; ++i) {
            obj = parsed.get(i);
            if (obj != Operator.SCIENTIFIC) continue;
            left = (Double)parsed.get(i - 1);
            right = (Double)parsed.get(i + 1);
            result = left * Math.pow(10.0, right);
            parsed.remove(i - 1);
            parsed.remove(i - 1);
            parsed.remove(i - 1);
            parsed.add(i - 1, result);
            --i;
        }
        for (i = parsed.size() - 2; i > 0; --i) {
            obj = parsed.get(i);
            if (obj != Operator.POWER) continue;
            left = (Double)parsed.get(i - 1);
            right = (Double)parsed.get(i + 1);
            result = Math.pow(left, right);
            parsed.remove(i - 1);
            parsed.remove(i - 1);
            parsed.remove(i - 1);
            parsed.add(i - 1, result);
            --i;
        }
        for (i = 1; i < parsed.size() - 1; ++i) {
            obj = parsed.get(i);
            if (obj == Operator.MULTIPLY) {
                left = (Double)parsed.get(i - 1);
                right = (Double)parsed.get(i + 1);
                result = left * right;
                parsed.remove(i - 1);
                parsed.remove(i - 1);
                parsed.remove(i - 1);
                parsed.add(i - 1, result);
                --i;
                continue;
            }
            if (obj == Operator.DIVIDE) {
                left = (Double)parsed.get(i - 1);
                right = (Double)parsed.get(i + 1);
                result = left / right;
                parsed.remove(i - 1);
                parsed.remove(i - 1);
                parsed.remove(i - 1);
                parsed.add(i - 1, result);
                --i;
                continue;
            }
            if (obj != Operator.MOD) continue;
            left = (Double)parsed.get(i - 1);
            right = (Double)parsed.get(i + 1);
            result = left % right;
            parsed.remove(i - 1);
            parsed.remove(i - 1);
            parsed.remove(i - 1);
            parsed.add(i - 1, result);
            --i;
        }
        for (i = 1; i < parsed.size() - 1; ++i) {
            obj = parsed.get(i);
            if (obj == Operator.PLUS) {
                left = (Double)parsed.get(i - 1);
                right = (Double)parsed.get(i + 1);
                result = left + right;
                parsed.remove(i - 1);
                parsed.remove(i - 1);
                parsed.remove(i - 1);
                parsed.add(i - 1, result);
                --i;
                continue;
            }
            if (obj != Operator.MINUS) continue;
            left = (Double)parsed.get(i - 1);
            right = (Double)parsed.get(i + 1);
            result = left - right;
            parsed.remove(i - 1);
            parsed.remove(i - 1);
            parsed.remove(i - 1);
            parsed.add(i - 1, result);
            --i;
        }
        if (parsed.size() != 1) {
            throw new IllegalStateException("Calculated expr has more than 1 result. " + parsed);
        }
        return (Double)parsed.get(0);
    }

    public static List<Object> buildParsedList(String expr, double onFailReturn) {
        ArrayList<Object> parsed = new ArrayList<Object>();
        StringBuilder builder = new StringBuilder();
        if (expr == null || expr.isEmpty()) {
            return parsed;
        }
        block14: for (int i = 0; i < expr.length(); ++i) {
            char c = expr.charAt(i);
            switch (c) {
                case ' ': 
                case ',': 
                case '_': {
                    continue block14;
                }
                case '+': {
                    if (builder.length() > 0) {
                        parsed.add(MathExpression.parse(builder.toString(), onFailReturn));
                        builder.delete(0, builder.length());
                    }
                    parsed.add((Object)Operator.PLUS);
                    continue block14;
                }
                case '-': {
                    if (builder.length() > 0) {
                        parsed.add(MathExpression.parse(builder.toString(), onFailReturn));
                        builder.delete(0, builder.length());
                    }
                    parsed.add((Object)Operator.MINUS);
                    continue block14;
                }
                case '*': {
                    if (builder.length() > 0) {
                        parsed.add(MathExpression.parse(builder.toString(), onFailReturn));
                        builder.delete(0, builder.length());
                    }
                    parsed.add((Object)Operator.MULTIPLY);
                    continue block14;
                }
                case '/': {
                    if (builder.length() > 0) {
                        parsed.add(MathExpression.parse(builder.toString(), onFailReturn));
                        builder.delete(0, builder.length());
                    }
                    parsed.add((Object)Operator.DIVIDE);
                    continue block14;
                }
                case '%': {
                    if (builder.length() > 0) {
                        parsed.add(MathExpression.parse(builder.toString(), onFailReturn));
                        builder.delete(0, builder.length());
                    }
                    parsed.add((Object)Operator.MOD);
                    continue block14;
                }
                case '^': {
                    if (builder.length() > 0) {
                        parsed.add(MathExpression.parse(builder.toString(), onFailReturn));
                        builder.delete(0, builder.length());
                    }
                    parsed.add((Object)Operator.POWER);
                    continue block14;
                }
                case 'E': 
                case 'e': {
                    if (builder.length() > 0) {
                        parsed.add(MathExpression.parse(builder.toString(), onFailReturn));
                        builder.delete(0, builder.length());
                    }
                    parsed.add((Object)Operator.SCIENTIFIC);
                    continue block14;
                }
                case 'K': 
                case 'k': {
                    if (builder.length() > 0) {
                        parsed.add(MathExpression.parse(builder.toString(), onFailReturn));
                        builder.delete(0, builder.length());
                    }
                    parsed.add((Object)Suffix.THOUSAND);
                    continue block14;
                }
                case 'M': 
                case 'm': {
                    if (builder.length() > 0) {
                        parsed.add(MathExpression.parse(builder.toString(), onFailReturn));
                        builder.delete(0, builder.length());
                    }
                    parsed.add((Object)Suffix.MILLION);
                    continue block14;
                }
                case 'B': 
                case 'G': 
                case 'b': 
                case 'g': {
                    if (builder.length() > 0) {
                        parsed.add(MathExpression.parse(builder.toString(), onFailReturn));
                        builder.delete(0, builder.length());
                    }
                    parsed.add((Object)Suffix.BILLION);
                    continue block14;
                }
                case 'T': 
                case 't': {
                    if (builder.length() > 0) {
                        parsed.add(MathExpression.parse(builder.toString(), onFailReturn));
                        builder.delete(0, builder.length());
                    }
                    parsed.add((Object)Suffix.TRILLION);
                    continue block14;
                }
                default: {
                    builder.append(c);
                }
            }
        }
        if (builder.length() > 0) {
            parsed.add(MathExpression.parse(builder.toString(), onFailReturn));
        }
        if (parsed.isEmpty()) {
            return DEFAULT;
        }
        Object prevToken = null;
        Object thisToken = null;
        for (int i = 0; i < parsed.size(); ++i) {
            prevToken = thisToken;
            thisToken = parsed.get(i);
            if (prevToken == null && (thisToken instanceof Double || Operator.MINUS == thisToken) || prevToken instanceof Double && (thisToken instanceof Operator || thisToken instanceof Suffix) || prevToken instanceof Operator && thisToken instanceof Double || prevToken instanceof Suffix && (thisToken instanceof Operator || thisToken instanceof Suffix)) continue;
            return DEFAULT;
        }
        if (thisToken instanceof Operator) {
            return DEFAULT;
        }
        return parsed;
    }

    public static double parse(String num, double onFailReturn) {
        try {
            return TextFieldWidget.format.parse(num).doubleValue();
        }
        catch (ParseException e) {
            e.printStackTrace();
            return onFailReturn;
        }
    }

    public static enum Suffix {
        THOUSAND(1000.0),
        MILLION(1000000.0),
        BILLION(1.0E9),
        TRILLION(1.0E12);

        public final double multiplier;

        private Suffix(double multiplier) {
            this.multiplier = multiplier;
        }
    }

    public static enum Operator {
        PLUS("+"),
        MINUS("-"),
        MULTIPLY("*"),
        DIVIDE("/"),
        MOD("%"),
        POWER("^"),
        SCIENTIFIC("e");

        public final String sign;

        private Operator(String sign) {
            this.sign = sign;
        }

        public String toString() {
            return this.sign;
        }
    }
}

