/*
 * Decompiled with CFR 0.152.
 */
package com.dreammaster.modfixes;

import com.dreammaster.main.MainRegistry;
import com.dreammaster.modfixes.IModFix;
import java.util.HashMap;

public final class ModFixesMaster {
    private static boolean mEnabled = false;
    private static HashMap<String, IModFix> mModFixes = new HashMap();

    private ModFixesMaster() {
    }

    public static void registerModFix(IModFix pConstructedModFix) {
        if (mEnabled) {
            MainRegistry.Logger.error((Object)String.format("ModFix %s tried to register after enable phase. This mod-fix will be ignored", pConstructedModFix.getModFixName()));
            return;
        }
        if (!mModFixes.containsKey(pConstructedModFix.getModFixName())) {
            mModFixes.put(pConstructedModFix.getModFixName(), pConstructedModFix);
        } else {
            MainRegistry.Logger.error((Object)String.format("ModFix [%s] is already registered! Did you forget to change the name?", pConstructedModFix.getModFixName()));
        }
    }

    public static void enableModFixes() {
        if (mEnabled) {
            MainRegistry.Logger.error((Object)"ModFixesMaster::enableModFixes() was called more than once");
            return;
        }
        for (IModFix tModFix : mModFixes.values()) {
            if (!tModFix.init()) {
                MainRegistry.Logger.error((Object)String.format("ModFix [%s] could not be initialized", tModFix.getModFixName()));
                continue;
            }
            MainRegistry.Logger.info((Object)String.format("ModFix [%s] initialized and enabled", tModFix.getModFixName()));
        }
        mEnabled = true;
    }

    public static IModFix getModFixInstance(String modFixName) {
        return mModFixes.get(modFixName);
    }
}

