/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.mechanics.compendium.content.fragments;

import chylex.hee.gui.GuiEnderCompendium;
import chylex.hee.gui.helpers.GuiItemRenderHelper;
import chylex.hee.item.ItemSpawnEggs;
import chylex.hee.mechanics.compendium.content.KnowledgeFragment;
import chylex.hee.mechanics.compendium.content.KnowledgeObject;
import chylex.hee.mechanics.compendium.objects.ObjectBlock;
import chylex.hee.mechanics.misc.Baconizer;
import chylex.hee.system.logging.Log;
import chylex.hee.system.util.DragonUtil;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityList;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.lwjgl.opengl.GL11;

public class KnowledgeFragmentText
extends KnowledgeFragment {
    public static byte smoothRenderingMode = 0;
    private static final String linkColor = EnumChatFormatting.DARK_PURPLE.toString();
    private String parsed;
    private List<KnowledgeObject<?>> parsedObjects = new ArrayList();

    public KnowledgeFragmentText(int globalID) {
        super(globalID);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int getHeight(GuiEnderCompendium gui, boolean isUnlocked) {
        boolean origFont = gui.field_146297_k.field_71466_p.func_82883_a();
        gui.field_146297_k.field_71466_p.func_78264_a(true);
        int h = gui.field_146297_k.field_71466_p.func_78271_c(this.getString(true), 116).size() * gui.field_146297_k.field_71466_p.field_78288_b;
        gui.field_146297_k.field_71466_p.func_78264_a(origFont);
        return h;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean onClick(GuiEnderCompendium gui, int x, int y, int mouseX, int mouseY, int buttonId, boolean isUnlocked) {
        KnowledgeObject<?> obj;
        if (isUnlocked && (obj = this.getHoveredObject(gui.field_146297_k.field_71466_p, mouseX, mouseY, x, y)) != null) {
            gui.showObject(obj);
            gui.moveToCurrentObject(true);
            return true;
        }
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onRender(GuiEnderCompendium gui, int x, int y, int mouseX, int mouseY, boolean isUnlocked) {
        KnowledgeObject<?> obj;
        String str = this.getString(isUnlocked);
        KnowledgeFragmentText.renderString(str, x + 1, y, 116, gui);
        if (isUnlocked && (obj = this.getHoveredObject(gui.field_146297_k.field_71466_p, mouseX, mouseY, x, y)) != null) {
            GuiItemRenderHelper.setupTooltip(mouseX, mouseY, obj.getTooltip() + "\n" + EnumChatFormatting.DARK_PURPLE + I18n.func_135052_a((String)"compendium.viewObject", (Object[])new Object[0]));
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected String getString(boolean isUnlocked) {
        String content = I18n.func_135052_a((String)("ec.reg." + this.globalID), (Object[])new Object[0]);
        return isUnlocked ? Baconizer.sentence(this.convertString(content)) : StringUtils.repeat((char)'?', (int)content.length());
    }

    public static void renderString(String str, int x, int y, GuiEnderCompendium gui) {
        KnowledgeFragmentText.renderString(str, x, y, 9999, gui);
    }

    public static void renderString(String str, int x, int y, int maxWidth, GuiEnderCompendium gui) {
        KnowledgeFragmentText.renderString(str, x, y, maxWidth, -16777216, -268435456, gui);
    }

    public static void renderString(String str, int x, int y, int normalColor, int smoothColor, GuiEnderCompendium gui) {
        KnowledgeFragmentText.renderString(str, x, y, 9999, normalColor, smoothColor, gui);
    }

    public static void renderString(String str, int x, int y, int maxWidth, int normalColor, int smoothColor, GuiEnderCompendium gui) {
        boolean origFont = gui.field_146297_k.field_71466_p.func_82883_a();
        gui.field_146297_k.field_71466_p.func_78264_a(true);
        if (smoothRenderingMode > 0) {
            gui.field_146297_k.field_71466_p.func_78279_b(str, x, y, maxWidth, smoothColor);
            GL11.glTranslatef((float)-0.2f, (float)0.0f, (float)0.0f);
            gui.field_146297_k.field_71466_p.func_78279_b(str, x, y, maxWidth, smoothColor);
            GL11.glTranslatef((float)0.2f, (float)0.0f, (float)0.0f);
            GL11.glTranslatef((float)0.0f, (float)(smoothRenderingMode == 1 ? -0.2f : 0.2f), (float)0.0f);
            gui.field_146297_k.field_71466_p.func_78279_b(str, x, y, maxWidth, smoothColor);
            GL11.glTranslatef((float)0.0f, (float)(smoothRenderingMode == 1 ? 0.2f : -0.2f), (float)0.0f);
        } else {
            gui.field_146297_k.field_71466_p.func_78279_b(str, x, y, maxWidth, normalColor);
        }
        gui.field_146297_k.field_71466_p.func_78264_a(origFont);
    }

    @SideOnly(value=Side.CLIENT)
    private String convertString(String str) {
        if (this.parsed != null) {
            return this.parsed;
        }
        if (str.indexOf(36) == -1) {
            this.parsed = str;
            return this.parsed;
        }
        int index = 0;
        int lastIndex = 0;
        char type = '\u0000';
        StringBuilder build = new StringBuilder(str.length());
        StringBuilder tmpBuild = new StringBuilder(16);
        while ((index = str.indexOf(36, lastIndex)) != -1) {
            char tmp;
            build.append(str.substring(lastIndex, index));
            if (index >= str.length() - 2) {
                Log.warn("Invalid text formatting, incorrect link start location: $0", str);
                break;
            }
            type = str.charAt(++index);
            if (str.charAt(++index) != ':') {
                Log.warn("Invalid text formatting, expected a colon: $0", str);
                break;
            }
            tmpBuild.setLength(0);
            while (index < str.length() - 1 && ((tmp = Character.toLowerCase(str.charAt(++index))) >= 'a' && tmp <= 'z' || tmp >= '0' && tmp <= '9' || tmp == '_' || tmp == '/' || tmp == '~')) {
                tmpBuild.append(str.charAt(index));
            }
            build.append(linkColor);
            if (str.charAt(index) == ':') {
                ++index;
                lastIndex = index;
                if ((index = str.indexOf(36, lastIndex)) == -1) {
                    Log.warn("Invalid text formatting, display text not terminated: $0", str);
                    break;
                }
                this.parsedObjects.add((KnowledgeObject)KnowledgeFragmentText.getObject(type, tmpBuild.toString()).getRight());
                build.append(str.substring(lastIndex, index++));
            } else if (tmpBuild.length() > 0) {
                Pair<String, KnowledgeObject<?>> pair = KnowledgeFragmentText.getObject(type, tmpBuild.toString());
                this.parsedObjects.add((KnowledgeObject)pair.getRight());
                build.append((String)pair.getLeft());
            } else {
                Log.warn("Invalid text formatting, identifier empty: $0", str);
                break;
            }
            lastIndex = index;
            build.append(EnumChatFormatting.BLACK);
        }
        if (this.parsedObjects.contains(null)) {
            Log.warn("Invalid text formatting, unknown object found: $0 $1", str, this.parsedObjects);
        }
        build.append(str.substring(lastIndex));
        this.parsed = build.toString();
        return this.parsed;
    }

    @SideOnly(value=Side.CLIENT)
    private KnowledgeObject<?> getHoveredObject(FontRenderer fontRenderer, int mouseX, int mouseY, int x, int y) {
        if (mouseX < x || mouseX > x + 126 - 10 || mouseY < y || !this.parsed.contains(linkColor)) {
            return null;
        }
        boolean origFont = fontRenderer.func_82883_a();
        fontRenderer.func_78264_a(true);
        List list = fontRenderer.func_78271_c(this.parsed, 116);
        if (mouseY <= y + list.size() * fontRenderer.field_78288_b) {
            boolean multiLine = false;
            int count = -1;
            for (int line = 0; line < list.size(); ++line) {
                int index;
                String lineStr = (String)list.get(line);
                int prevIndex = -1;
                while ((index = lineStr.indexOf(linkColor, ++prevIndex)) != -1) {
                    prevIndex = index;
                    if (multiLine) {
                        multiLine = false;
                    } else {
                        ++count;
                    }
                    prevIndex = index;
                    int startX = x + fontRenderer.func_78256_a(lineStr.substring(0, prevIndex));
                    index = lineStr.indexOf(EnumChatFormatting.BLACK.toString(), index);
                    if (index == -1) {
                        index = lineStr.length();
                        multiLine = true;
                    }
                    if (mouseY < y + line * fontRenderer.field_78288_b || mouseY > y + (line + 1) * fontRenderer.field_78288_b || mouseX < startX || mouseX > startX + fontRenderer.func_78256_a(lineStr.substring(prevIndex, index))) continue;
                    fontRenderer.func_78264_a(origFont);
                    return count < this.parsedObjects.size() ? this.parsedObjects.get(count) : null;
                }
            }
        }
        fontRenderer.func_78264_a(origFont);
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    private static Pair<String, KnowledgeObject<?>> getObject(char type, String identifier) {
        boolean isHEE;
        KnowledgeObject obj = null;
        String text = null;
        boolean bl = isHEE = identifier.charAt(0) == '~' && identifier.length() > 1;
        if (isHEE) {
            identifier = identifier.substring(1);
        }
        switch (type) {
            case 'b': 
            case 'i': {
                Item item;
                int metaIndex = identifier.indexOf(47);
                int meta = 0;
                if (metaIndex != -1 && metaIndex + 1 < identifier.length()) {
                    meta = DragonUtil.tryParse(identifier.substring(metaIndex + 1), 0);
                    identifier = identifier.substring(0, metaIndex);
                }
                if ((item = GameRegistry.findItem((String)(isHEE ? "HardcoreEnderExpansion" : "minecraft"), (String)identifier)) == null) break;
                text = StatCollector.func_74838_a((String)(item.func_77667_c(new ItemStack(item, 1, meta)) + ".name"));
                obj = KnowledgeObject.getObject(type == 'b' ? (item instanceof ItemBlock ? new ObjectBlock.BlockMetaWrapper(((ItemBlock)item).field_150939_a, meta) : null) : item);
                break;
            }
            case 'e': {
                if (isHEE) {
                    identifier = "HardcoreEnderExpansion." + identifier;
                    text = ItemSpawnEggs.getMobName((Class)EntityList.field_75625_b.get(identifier));
                } else {
                    text = StatCollector.func_74838_a((String)("entity." + identifier + ".name"));
                }
                Class cls = (Class)EntityList.field_75625_b.get(identifier);
                if (cls == null) break;
                obj = KnowledgeObject.getObject(cls);
                break;
            }
            case 'd': {
                obj = KnowledgeObject.getObject(identifier);
                if (obj == null) break;
                text = obj.getTooltip();
            }
        }
        if (text == null || obj == null) {
            Log.warn("Invalid object type or identifier: $0:$1", Character.valueOf(type), identifier);
            return Pair.of((Object)(text == null ? identifier : text), obj);
        }
        return Pair.of(text, obj);
    }
}

