/*
 * Decompiled with CFR 0.152.
 */
package mods.battlegear2.api;

import com.google.common.base.Predicate;
import java.util.Iterator;

public interface ISensible<T> {
    public boolean differenciate(T var1, T var2);

    public static final class Filter<T>
    implements Predicate<T> {
        private final Iterator<ISensible<T>> senses;
        private final T toCompare;

        public Filter(T compare, Iterator<ISensible<T>> sensitivities) {
            this.toCompare = compare;
            this.senses = sensitivities;
        }

        public Filter(T compare, Iterable<ISensible<T>> sensibles) {
            this(compare, sensibles.iterator());
        }

        public boolean apply(T input) {
            while (this.senses.hasNext()) {
                if (!this.senses.next().differenciate(input, this.toCompare)) continue;
                return false;
            }
            return true;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            return object != null && object instanceof Filter && this.toCompare.equals(((Filter)object).toCompare) && this.senses.equals(((Filter)object).senses);
        }
    }
}

