/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.block.tile;

import com.jaquadro.minecraft.storagedrawers.StorageDrawers;
import com.jaquadro.minecraft.storagedrawers.api.inventory.IDrawerInventory;
import com.jaquadro.minecraft.storagedrawers.api.security.ISecurityProvider;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawer;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerGroupInteractive;
import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.IDowngradable;
import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.ILockable;
import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.IProtectable;
import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.ISealable;
import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.LockAttribute;
import com.jaquadro.minecraft.storagedrawers.block.BlockDrawersCustom;
import com.jaquadro.minecraft.storagedrawers.block.tile.BaseTileEntity;
import com.jaquadro.minecraft.storagedrawers.config.ConfigManager;
import com.jaquadro.minecraft.storagedrawers.core.ModItems;
import com.jaquadro.minecraft.storagedrawers.inventory.ISideManager;
import com.jaquadro.minecraft.storagedrawers.inventory.StorageInventory;
import com.jaquadro.minecraft.storagedrawers.network.CountUpdateMessage;
import com.jaquadro.minecraft.storagedrawers.storage.IUpgradeProvider;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.EnumSet;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.util.MathHelper;
import org.apache.logging.log4j.Level;

public abstract class TileEntityDrawers
extends BaseTileEntity
implements IDrawerGroupInteractive,
ISidedInventory,
IUpgradeProvider,
ILockable,
ISealable,
IProtectable,
IDowngradable {
    private IDrawer[] drawers;
    private IDrawerInventory inventory;
    private int[] autoSides = new int[]{0, 1, 2, 3, 4, 5};
    private int direction;
    private int drawerCapacity = 1;
    private boolean shrouded = false;
    private boolean quantified = false;
    private boolean taped = false;
    private boolean hideUpgrade = false;
    private boolean downgraded = false;
    private UUID owner;
    private String securityKey;
    private EnumSet<LockAttribute> lockAttributes = null;
    private ItemStack[] upgrades = new ItemStack[5];
    private long lastClickTime;
    private UUID lastClickUUID;
    private String customName;
    private ItemStack materialSide;
    private ItemStack materialFront;
    private ItemStack materialTrim;

    protected TileEntityDrawers(int drawerCount) {
        this.initWithDrawerCount(drawerCount);
    }

    protected abstract IDrawer createDrawer(int var1);

    protected ISideManager getSideManager() {
        return new DefaultSideManager();
    }

    protected void initWithDrawerCount(int drawerCount) {
        this.drawers = new IDrawer[drawerCount];
        for (int i = 0; i < drawerCount; ++i) {
            this.drawers[i] = this.createDrawer(i);
        }
        this.inventory = new StorageInventory(this, this.getSideManager(), this);
    }

    public int getDirection() {
        return this.direction;
    }

    public void setDirection(int direction) {
        this.direction = direction % 6;
    }

    public int getMaxStorageLevel() {
        int maxLevel = 1;
        for (ItemStack upgrade : this.upgrades) {
            if (upgrade == null || upgrade.func_77973_b() != ModItems.upgrade) continue;
            maxLevel = Math.max(maxLevel, upgrade.func_77960_j());
        }
        return maxLevel;
    }

    public int getEffectiveStorageLevel() {
        int level = 0;
        for (ItemStack upgrade : this.upgrades) {
            if (upgrade == null || upgrade.func_77973_b() != ModItems.upgrade) continue;
            level += upgrade.func_77960_j();
        }
        return Math.max(level, 1);
    }

    public int getEffectiveStorageMultiplier() {
        ConfigManager config = StorageDrawers.config;
        int multiplier = 0;
        for (ItemStack stack : this.upgrades) {
            if (stack == null || stack.func_77973_b() != ModItems.upgrade) continue;
            multiplier += config.getStorageUpgradeMultiplier(stack.func_77960_j());
        }
        if (multiplier == 0) {
            multiplier = config.getStorageUpgradeMultiplier(1);
        }
        return multiplier;
    }

    public int getEffectiveStatusLevel() {
        int maxLevel = 0;
        for (ItemStack upgrade : this.upgrades) {
            if (upgrade == null || upgrade.func_77973_b() != ModItems.upgradeStatus) continue;
            maxLevel = upgrade.func_77960_j();
        }
        return maxLevel;
    }

    public int getUpgradeSlotCount() {
        return 5;
    }

    public ItemStack getUpgrade(int slot) {
        slot = MathHelper.func_76125_a((int)slot, (int)0, (int)4);
        return this.upgrades[slot];
    }

    public boolean addUpgrade(ItemStack upgrade) {
        int slot = this.getNextUpgradeSlot();
        if (slot == -1) {
            return false;
        }
        this.setUpgrade(slot, upgrade);
        this.checkDowngraded();
        return true;
    }

    public void setUpgrade(int slot, ItemStack upgrade) {
        slot = MathHelper.func_76125_a((int)slot, (int)0, (int)4);
        if (upgrade != null) {
            upgrade = upgrade.func_77946_l();
            upgrade.field_77994_a = 1;
        }
        this.upgrades[slot] = upgrade;
        if (this.field_145850_b != null) {
            if (!this.field_145850_b.field_72995_K) {
                this.func_70296_d();
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
            this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q());
            this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e, this.func_145838_q());
        }
    }

    public int getNextUpgradeSlot() {
        for (int i = 0; i < this.upgrades.length; ++i) {
            if (this.upgrades[i] != null) continue;
            return i;
        }
        return -1;
    }

    public int getDrawerCapacity() {
        return this.isDowngraded() ? 1 : this.drawerCapacity;
    }

    public void setDrawerCapacity(int stackCount) {
        this.drawerCapacity = stackCount;
    }

    @Override
    public boolean isLocked(LockAttribute attr) {
        if (!StorageDrawers.config.cache.enableLockUpgrades || this.lockAttributes == null) {
            return false;
        }
        return this.lockAttributes.contains((Object)attr);
    }

    @Override
    public boolean canLock(LockAttribute attr) {
        return StorageDrawers.config.cache.enableLockUpgrades;
    }

    @Override
    public void setLocked(LockAttribute attr, boolean isLocked) {
        if (!StorageDrawers.config.cache.enableLockUpgrades) {
            return;
        }
        if (isLocked && (this.lockAttributes == null || !this.lockAttributes.contains((Object)attr))) {
            if (this.lockAttributes == null) {
                this.lockAttributes = EnumSet.of(attr);
            } else {
                this.lockAttributes.add(attr);
            }
            if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
                this.func_70296_d();
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
        } else if (!isLocked && this.lockAttributes != null && this.lockAttributes.contains((Object)attr)) {
            this.lockAttributes.remove((Object)attr);
            if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
                this.func_70296_d();
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
        }
    }

    @Override
    public boolean isShrouded() {
        if (!StorageDrawers.config.cache.enableShroudUpgrades) {
            return false;
        }
        return this.shrouded;
    }

    public void setIsShrouded(boolean shrouded) {
        if (this.shrouded != shrouded) {
            this.shrouded = shrouded;
            if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
                this.func_70296_d();
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
        }
    }

    @Override
    public boolean isQuantified() {
        if (!StorageDrawers.config.cache.enableQuantifyUpgrades) {
            return false;
        }
        return this.quantified;
    }

    public void setIsQuantified(boolean quantified) {
        if (this.quantified != quantified) {
            this.quantified = quantified;
            if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
                this.func_70296_d();
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
        }
    }

    @Override
    public UUID getOwner() {
        if (!StorageDrawers.config.cache.enablePersonalUpgrades) {
            return null;
        }
        return this.owner;
    }

    @Override
    public boolean setOwner(UUID owner) {
        if (!StorageDrawers.config.cache.enablePersonalUpgrades) {
            return false;
        }
        if (this.owner != null && !this.owner.equals(owner) || owner != null && !owner.equals(this.owner)) {
            this.owner = owner;
            if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
                this.func_70296_d();
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
        }
        return true;
    }

    @Override
    public ISecurityProvider getSecurityProvider() {
        return StorageDrawers.securityRegistry.getProvider(this.securityKey);
    }

    @Override
    public boolean setSecurityProvider(ISecurityProvider provider) {
        String newKey;
        if (!StorageDrawers.config.cache.enablePersonalUpgrades) {
            return false;
        }
        String string = newKey = provider == null ? null : provider.getProviderID();
        if (newKey != null && !newKey.equals(this.securityKey) || this.securityKey != null && !this.securityKey.equals(newKey)) {
            this.securityKey = newKey;
            if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
                this.func_70296_d();
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
        }
        return true;
    }

    public boolean shouldHideUpgrades() {
        return this.hideUpgrade;
    }

    public void setShouldHideUpgrades(boolean hide) {
        this.hideUpgrade = hide;
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            this.func_70296_d();
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    @Override
    public boolean isSealed() {
        if (!StorageDrawers.config.cache.enableTape) {
            return false;
        }
        return this.taped;
    }

    @Override
    public boolean setIsSealed(boolean state) {
        if (!StorageDrawers.config.cache.enableTape) {
            return false;
        }
        if (this.taped != state) {
            this.taped = state;
            if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
                this.func_70296_d();
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
        }
        return true;
    }

    @Override
    public boolean isDowngraded() {
        return this.downgraded;
    }

    @Override
    public boolean canDowngrade() {
        return true;
    }

    @Override
    public boolean checkDowngraded() {
        for (ItemStack stack : this.upgrades) {
            if (stack == null || stack.func_77973_b() != ModItems.upgradeDowngrade) continue;
            this.downgraded = true;
            return true;
        }
        this.downgraded = false;
        return false;
    }

    @Override
    public void setDowngraded(boolean state) {
        this.downgraded = state;
    }

    @Override
    public boolean isVoid() {
        if (!StorageDrawers.config.cache.enableVoidUpgrades) {
            return false;
        }
        for (ItemStack stack : this.upgrades) {
            if (stack == null || stack.func_77973_b() != ModItems.upgradeVoid) continue;
            return true;
        }
        return false;
    }

    public boolean isUnlimited() {
        if (!StorageDrawers.config.cache.enableCreativeUpgrades) {
            return false;
        }
        for (ItemStack stack : this.upgrades) {
            if (stack == null || stack.func_77973_b() != ModItems.upgradeCreative) continue;
            return true;
        }
        return false;
    }

    public boolean isVending() {
        if (!StorageDrawers.config.cache.enableCreativeUpgrades) {
            return false;
        }
        for (ItemStack stack : this.upgrades) {
            if (stack == null || stack.func_77973_b() != ModItems.upgradeCreative || stack.func_77960_j() != 1) continue;
            return true;
        }
        return false;
    }

    public boolean isRedstone() {
        if (!StorageDrawers.config.cache.enableRedstoneUpgrades) {
            return false;
        }
        for (ItemStack stack : this.upgrades) {
            if (stack == null || stack.func_77973_b() != ModItems.upgradeRedstone) continue;
            return true;
        }
        return false;
    }

    public int getRedstoneLevel() {
        int redstoneType = -1;
        for (ItemStack stack : this.upgrades) {
            if (stack == null || stack.func_77973_b() != ModItems.upgradeRedstone) continue;
            redstoneType = stack.func_77960_j();
            break;
        }
        switch (redstoneType) {
            case 0: {
                return this.getCombinedRedstoneLevel();
            }
            case 1: {
                return this.getMaxRedstoneLevel();
            }
            case 2: {
                return this.getMinRedstoneLevel();
            }
        }
        return 0;
    }

    protected int getCombinedRedstoneLevel() {
        int active = 0;
        float fillRatio = 0.0f;
        for (int i = 0; i < this.getDrawerCount(); ++i) {
            if (!this.isDrawerEnabled(i)) continue;
            IDrawer drawer = this.getDrawer(i);
            if (drawer.getMaxCapacity() > 0) {
                fillRatio += (float)drawer.getStoredItemCount() / (float)drawer.getMaxCapacity();
            }
            ++active;
        }
        if (active == 0) {
            return 0;
        }
        if (fillRatio == (float)active) {
            return 15;
        }
        return (int)Math.ceil(fillRatio / (float)active * 14.0f);
    }

    protected int getMinRedstoneLevel() {
        float minRatio = 2.0f;
        for (int i = 0; i < this.getDrawerCount(); ++i) {
            if (!this.isDrawerEnabled(i)) continue;
            IDrawer drawer = this.getDrawer(i);
            minRatio = drawer.getMaxCapacity() > 0 ? Math.min(minRatio, (float)drawer.getStoredItemCount() / (float)drawer.getMaxCapacity()) : 0.0f;
        }
        if (minRatio > 1.0f) {
            return 0;
        }
        if (minRatio == 1.0f) {
            return 15;
        }
        return (int)Math.ceil(minRatio * 14.0f);
    }

    protected int getMaxRedstoneLevel() {
        float maxRatio = 0.0f;
        for (int i = 0; i < this.getDrawerCount(); ++i) {
            IDrawer drawer;
            if (!this.isDrawerEnabled(i) || (drawer = this.getDrawer(i)).getMaxCapacity() <= 0) continue;
            maxRatio = Math.max(maxRatio, (float)drawer.getStoredItemCount() / (float)drawer.getMaxCapacity());
        }
        if (maxRatio == 1.0f) {
            return 15;
        }
        return (int)Math.ceil(maxRatio * 14.0f);
    }

    @Override
    public boolean isSorting() {
        return false;
    }

    public ItemStack getMaterialSide() {
        return this.materialSide;
    }

    public ItemStack getMaterialFront() {
        return this.materialFront;
    }

    public ItemStack getMaterialTrim() {
        return this.materialTrim;
    }

    public ItemStack getEffectiveMaterialSide() {
        return this.materialSide;
    }

    public ItemStack getEffectiveMaterialFront() {
        return this.materialFront != null ? this.materialFront : this.materialSide;
    }

    public ItemStack getEffectiveMaterialTrim() {
        return this.materialTrim != null ? this.materialTrim : this.materialSide;
    }

    public void setMaterialSide(ItemStack material) {
        this.materialSide = material;
    }

    public void setMaterialFront(ItemStack material) {
        this.materialFront = material;
    }

    public void setMaterialTrim(ItemStack material) {
        this.materialTrim = material;
    }

    @Override
    public ItemStack takeItemsFromSlot(int slot, int count) {
        if (slot < 0 || slot >= this.getDrawerCount()) {
            return null;
        }
        ItemStack stack = this.getItemsFromSlot(slot, count);
        if (stack == null) {
            return null;
        }
        IDrawer drawer = this.drawers[slot];
        drawer.setStoredItemCount(drawer.getStoredItemCount() - stack.field_77994_a);
        if (this.isRedstone() && this.field_145850_b != null) {
            this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q());
            this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e, this.func_145838_q());
        }
        return stack;
    }

    protected ItemStack getItemsFromSlot(int slot, int count) {
        if (this.drawers[slot].isEmpty()) {
            return null;
        }
        ItemStack stack = this.drawers[slot].getStoredItemCopy();
        stack.field_77994_a = Math.min(stack.func_77976_d(), count);
        stack.field_77994_a = Math.min(stack.field_77994_a, this.drawers[slot].getStoredItemCount());
        return stack;
    }

    @Override
    public int putItemsIntoSlot(int slot, ItemStack stack, int count) {
        if (slot < 0 || slot >= this.getDrawerCount()) {
            return 0;
        }
        IDrawer drawer = this.drawers[slot];
        if (drawer.isEmpty()) {
            drawer.setStoredItem(stack, 0);
        }
        if (!drawer.canItemBeStored(stack)) {
            return 0;
        }
        int countAdded = Math.min(count, stack.field_77994_a);
        if (!this.isVoid()) {
            countAdded = Math.min(countAdded, drawer.getRemainingCapacity());
        }
        drawer.setStoredItemCount(drawer.getStoredItemCount() + countAdded);
        stack.field_77994_a -= countAdded;
        return countAdded;
    }

    @Override
    public int interactPutCurrentItemIntoSlot(int slot, EntityPlayer player) {
        int count = 0;
        ItemStack playerStack = player.field_71071_by.func_70448_g();
        if (playerStack != null) {
            count = this.putItemsIntoSlot(slot, playerStack, playerStack.field_77994_a);
        }
        if (count > 0) {
            this.func_70296_d();
        }
        return count;
    }

    @Override
    public int interactPutCurrentInventoryIntoSlot(int slot, EntityPlayer player) {
        int count = 0;
        if (!this.drawers[slot].isEmpty()) {
            int n = player.field_71071_by.func_70302_i_();
            for (int i = 0; i < n; ++i) {
                ItemStack subStack = player.field_71071_by.func_70301_a(i);
                if (subStack == null) continue;
                int subCount = this.putItemsIntoSlot(slot, subStack, subStack.field_77994_a);
                if (subCount > 0 && subStack.field_77994_a == 0) {
                    player.field_71071_by.func_70299_a(i, null);
                }
                count += subCount;
            }
        }
        if (count > 0) {
            StorageDrawers.proxy.updatePlayerInventory(player);
        }
        this.func_70296_d();
        return count;
    }

    public int interactPutItemsIntoSlot(int slot, EntityPlayer player) {
        int count = 0;
        count = this.field_145850_b.func_82737_E() - this.lastClickTime < 10L && player.getPersistentID().equals(this.lastClickUUID) ? this.interactPutCurrentInventoryIntoSlot(slot, player) : this.interactPutCurrentItemIntoSlot(slot, player);
        this.lastClickTime = this.field_145850_b.func_82737_E();
        this.lastClickUUID = player.getPersistentID();
        return count;
    }

    private void readLegacyUpgradeNBT(NBTTagCompound tag) {
        if (tag.func_74764_b("Lev") && tag.func_74771_c("Lev") > 1) {
            this.addUpgrade(new ItemStack((Item)ModItems.upgrade, 1, (int)tag.func_74771_c("Lev")));
        }
        if (tag.func_74764_b("Stat")) {
            this.addUpgrade(new ItemStack((Item)ModItems.upgradeStatus, 1, (int)tag.func_74771_c("Stat")));
        }
        if (tag.func_74764_b("Void")) {
            this.addUpgrade(new ItemStack((Item)ModItems.upgradeVoid));
        }
        if (tag.func_74764_b("Down")) {
            this.addUpgrade(new ItemStack((Item)ModItems.upgradeDowngrade));
        }
    }

    @Override
    protected void readFromFixedNBT(NBTTagCompound tag) {
        super.readFromFixedNBT(tag);
        this.setDirection(tag.func_74771_c("Dir"));
        this.taped = false;
        if (tag.func_74764_b("Tape")) {
            this.taped = tag.func_74767_n("Tape");
        }
        this.customName = null;
        if (tag.func_150297_b("CustomName", 8)) {
            this.customName = tag.func_74779_i("CustomName");
        }
        this.downgraded = tag.func_74764_b("Down") && tag.func_74767_n("Down");
    }

    @Override
    protected void writeToFixedNBT(NBTTagCompound tag) {
        super.writeToFixedNBT(tag);
        tag.func_74774_a("Dir", (byte)this.direction);
        if (this.taped) {
            tag.func_74757_a("Tape", this.taped);
        }
        if (this.func_145818_k_()) {
            tag.func_74778_a("CustomName", this.customName);
        }
        if (this.checkDowngraded()) {
            tag.func_74757_a("Down", this.downgraded);
        }
    }

    @Override
    public void readFromPortableNBT(NBTTagCompound tag) {
        int i;
        super.readFromPortableNBT(tag);
        this.upgrades = new ItemStack[this.upgrades.length];
        this.drawerCapacity = tag.func_74762_e("Cap");
        if (!tag.func_74764_b("Upgrades")) {
            this.readLegacyUpgradeNBT(tag);
        } else {
            NBTTagList upgradeList = tag.func_150295_c("Upgrades", 10);
            for (i = 0; i < upgradeList.func_74745_c(); ++i) {
                NBTTagCompound upgradeTag = upgradeList.func_150305_b(i);
                byte slot = upgradeTag.func_74771_c("Slot");
                this.setUpgrade(slot, ItemStack.func_77949_a((NBTTagCompound)upgradeTag));
            }
        }
        this.lockAttributes = null;
        if (tag.func_74764_b("Lock")) {
            this.lockAttributes = LockAttribute.getEnumSet(tag.func_74771_c("Lock"));
        }
        this.shrouded = false;
        if (tag.func_74764_b("Shr")) {
            this.shrouded = tag.func_74767_n("Shr");
        }
        this.quantified = false;
        if (tag.func_74764_b("Qua")) {
            this.quantified = tag.func_74767_n("Qua");
        }
        this.owner = null;
        if (tag.func_74764_b("Own")) {
            this.owner = UUID.fromString(tag.func_74779_i("Own"));
        }
        this.securityKey = null;
        if (tag.func_74764_b("Sec")) {
            this.securityKey = tag.func_74779_i("Sec");
        }
        this.hideUpgrade = false;
        if (tag.func_74764_b("HideUp")) {
            this.hideUpgrade = tag.func_74767_n("HideUp");
        }
        NBTTagList slots = tag.func_150295_c("Slots", 10);
        this.drawers = new IDrawer[slots.func_74745_c()];
        int n = this.drawers.length;
        for (i = 0; i < n; ++i) {
            NBTTagCompound slot = slots.func_150305_b(i);
            this.drawers[i] = this.createDrawer(i);
            this.drawers[i].readFromNBT(slot);
        }
        this.inventory = new StorageInventory(this, this.getSideManager(), this);
        this.materialSide = null;
        if (tag.func_74764_b("MatS")) {
            this.materialSide = ItemStack.func_77949_a((NBTTagCompound)tag.func_74775_l("MatS"));
        }
        this.materialFront = null;
        if (tag.func_74764_b("MatF")) {
            this.materialFront = ItemStack.func_77949_a((NBTTagCompound)tag.func_74775_l("MatF"));
        }
        this.materialTrim = null;
        if (tag.func_74764_b("MatT")) {
            this.materialTrim = ItemStack.func_77949_a((NBTTagCompound)tag.func_74775_l("MatT"));
        }
    }

    @Override
    public void writeToPortableNBT(NBTTagCompound tag) {
        NBTTagCompound itag;
        super.writeToPortableNBT(tag);
        tag.func_74768_a("Cap", this.drawerCapacity);
        NBTTagList upgradeList = new NBTTagList();
        for (int i = 0; i < this.upgrades.length; ++i) {
            if (this.upgrades[i] == null) continue;
            IDrawer[] upgradeTag = this.upgrades[i].func_77955_b(new NBTTagCompound());
            upgradeTag.func_74774_a("Slot", (byte)i);
            upgradeList.func_74742_a((NBTBase)upgradeTag);
        }
        if (upgradeList.func_74745_c() > 0) {
            tag.func_74782_a("Upgrades", (NBTBase)upgradeList);
        }
        if (this.lockAttributes != null) {
            tag.func_74774_a("Lock", (byte)LockAttribute.getBitfield(this.lockAttributes));
        }
        if (this.shrouded) {
            tag.func_74757_a("Shr", this.shrouded);
        }
        if (this.quantified) {
            tag.func_74757_a("Qua", this.quantified);
        }
        if (this.owner != null) {
            tag.func_74778_a("Own", this.owner.toString());
        }
        if (this.securityKey != null) {
            tag.func_74778_a("Sec", this.securityKey);
        }
        if (this.hideUpgrade) {
            tag.func_74757_a("HideUp", this.hideUpgrade);
        }
        NBTTagList slots = new NBTTagList();
        for (IDrawer drawer : this.drawers) {
            NBTTagCompound slot = new NBTTagCompound();
            drawer.writeToNBT(slot);
            slots.func_74742_a((NBTBase)slot);
        }
        tag.func_74782_a("Slots", (NBTBase)slots);
        if (this.materialSide != null) {
            itag = new NBTTagCompound();
            this.materialSide.func_77955_b(itag);
            tag.func_74782_a("MatS", (NBTBase)itag);
        }
        if (this.materialFront != null) {
            itag = new NBTTagCompound();
            this.materialFront.func_77955_b(itag);
            tag.func_74782_a("MatF", (NBTBase)itag);
        }
        if (this.materialTrim != null) {
            itag = new NBTTagCompound();
            this.materialTrim.func_77955_b(itag);
            tag.func_74782_a("MatT", (NBTBase)itag);
        }
    }

    public boolean canUpdate() {
        return false;
    }

    public void func_70296_d() {
        this.inventory.func_70296_d();
        if (this.isRedstone() && this.field_145850_b != null) {
            this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q());
            this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e, this.func_145838_q());
        }
        super.func_70296_d();
    }

    @Override
    public boolean markDirtyIfNeeded() {
        if (this.inventory.syncInventoryIfNeeded()) {
            super.func_70296_d();
            return true;
        }
        return false;
    }

    public void clientUpdateCount(int slot, int count) {
        IDrawer drawer = this.getDrawer(slot);
        if (drawer == null) {
            FMLLog.log((String)"StorageDrawers", (Level)Level.ERROR, (String)("Drawer at (" + this.field_145851_c + "," + this.field_145848_d + "," + this.field_145849_e + ") has no slot " + slot + ". Drawers.length is " + this.drawers.length), (Object[])new Object[0]);
            return;
        }
        if (drawer.getStoredItemCount() != count) {
            drawer.setStoredItemCount(count);
            switch (this.getEffectiveStatusLevel()) {
                case 1: {
                    if (drawer.getStoredItemCount() != 0 && drawer.getRemainingCapacity() != 0) break;
                    this.func_145831_w().func_147479_m(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                    break;
                }
                case 2: {
                    this.func_145831_w().func_147479_m(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                }
            }
        }
    }

    private void syncClientCount(int slot) {
        CountUpdateMessage message = new CountUpdateMessage(this.field_145851_c, this.field_145848_d, this.field_145849_e, slot, this.drawers[slot].getStoredItemCount());
        NetworkRegistry.TargetPoint targetPoint = new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.field_76574_g, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, 500.0);
        StorageDrawers.network.sendToAllAround((IMessage)message, targetPoint);
    }

    public Packet func_145844_m() {
        NBTTagCompound tag = new NBTTagCompound();
        this.func_145841_b(tag);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 5, tag);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
        this.func_145831_w().func_147479_m(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public int getDrawerCount() {
        return this.drawers.length;
    }

    @Override
    @Nullable
    public IDrawer getDrawer(int slot) {
        if (slot < 0 || slot >= this.drawers.length) {
            return null;
        }
        return this.drawers[slot];
    }

    @Override
    public IDrawerInventory getDrawerInventory() {
        return this.inventory;
    }

    @Override
    public boolean isDrawerEnabled(int slot) {
        if (this.isSealed()) {
            return false;
        }
        if (this.func_145838_q() instanceof BlockDrawersCustom && this.materialSide == null) {
            return false;
        }
        return this.getDrawer(slot) != null;
    }

    public int[] func_94128_d(int side) {
        return this.inventory.func_94128_d(side);
    }

    public boolean func_102007_a(int slot, ItemStack stack, int side) {
        IDrawer drawer;
        if (this.isSealed()) {
            return false;
        }
        if (this.isLocked(LockAttribute.LOCK_EMPTY) && this.inventory instanceof StorageInventory && (drawer = this.getDrawer(this.inventory.getDrawerSlot(slot))) != null && drawer.isEmpty()) {
            return false;
        }
        return this.inventory.func_102007_a(slot, stack, side);
    }

    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        if (this.isSealed()) {
            return false;
        }
        return this.inventory.func_102008_b(slot, stack, side);
    }

    public int func_70302_i_() {
        return this.inventory.func_70302_i_();
    }

    public ItemStack func_70301_a(int slot) {
        return this.inventory.func_70301_a(slot);
    }

    public ItemStack func_70298_a(int slot, int count) {
        return this.inventory.func_70298_a(slot, count);
    }

    public ItemStack func_70304_b(int slot) {
        return this.inventory.func_70304_b(slot);
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.inventory.func_70299_a(slot, stack);
    }

    public void setInventoryName(String name) {
        this.customName = name;
    }

    public String func_145825_b() {
        return this.func_145818_k_() ? this.customName : "storageDrawers.container.drawers";
    }

    public boolean func_145818_k_() {
        return this.customName != null && this.customName.length() > 0;
    }

    public int func_70297_j_() {
        return this.inventory.func_70297_j_();
    }

    public boolean func_70300_a(EntityPlayer player) {
        if (this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
        this.inventory.func_70295_k_();
    }

    public void func_70305_f() {
        this.inventory.func_70305_f();
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return this.inventory.func_94041_b(slot, stack);
    }

    private class DefaultSideManager
    implements ISideManager {
        private DefaultSideManager() {
        }

        @Override
        public int[] getSlotsForSide(int side) {
            return TileEntityDrawers.this.autoSides;
        }
    }
}

