/*
 * Decompiled with CFR 0.152.
 */
package tonius.neiintegration.mods.minefactoryreloaded;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.GuiRecipe;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import powercrystals.minefactoryreloaded.tile.machine.TileEntityGrinder;
import tonius.neiintegration.PositionedFluidTank;
import tonius.neiintegration.RecipeHandlerBase;
import tonius.neiintegration.Utils;

public class RecipeHandlerGrinder
extends RecipeHandlerBase {
    private static int energyPerOperation;

    @Override
    public void prepare() {
        TileEntityGrinder dummy = new TileEntityGrinder();
        energyPerOperation = dummy.getActivationEnergy() * dummy.getWorkMax();
        dummy = null;
    }

    public String getRecipeName() {
        return Utils.translate("tile.mfr.machine.grinder.name", false);
    }

    @Override
    public String getRecipeID() {
        return "minefactoryreloaded.grinder";
    }

    public String getGuiTexture() {
        return "minefactoryreloaded:textures/gui/grinder.png";
    }

    public void drawBackground(int recipe) {
        this.changeToGuiTexture();
        GuiDraw.drawTexturedModalRect((int)0, (int)0, (int)11, (int)13, (int)160, (int)65);
        this.changeToOverlayTexture();
        GuiDraw.drawTexturedModalRect((int)74, (int)25, (int)0, (int)0, (int)22, (int)15);
        GuiDraw.drawTexturedModalRect((int)44, (int)24, (int)16, (int)64, (int)16, (int)16);
    }

    public void drawExtras(int recipe) {
        this.drawProgressBar(129, 0, 176, 58, 8, 62, 1.0f, 3);
        this.drawProgressBar(139, 0, 185, 58, 8, 62, 20, 3);
    }

    @Override
    public List<String> provideTooltip(GuiRecipe<?> guiRecipe, List<String> currenttip, RecipeHandlerBase.CachedBaseRecipe crecipe, Point relMouse) {
        super.provideTooltip(guiRecipe, currenttip, crecipe, relMouse);
        if (new Rectangle(44, 24, 16, 16).contains(relMouse)) {
            currenttip.add(Utils.translate("handler.grinder.mobs"));
            currenttip.add(EnumChatFormatting.GRAY + Utils.translate("handler.grinder.mobs.1"));
            currenttip.add(EnumChatFormatting.GRAY + Utils.translate("handler.grinder.mobs.2"));
        } else if (new Rectangle(129, 2, 8, 60).contains(relMouse)) {
            currenttip.add(energyPerOperation + " RF");
        }
        return currenttip;
    }

    @Override
    public void loadAllRecipes() {
        this.arecipes.add(new CachedGrinderRecipe());
    }

    @Override
    public void loadCraftingRecipes(FluidStack result) {
        if (result.getFluid().getName() != null && result.getFluid().getName().equals("mobessence")) {
            this.loadAllRecipes();
        }
    }

    public class CachedGrinderRecipe
    extends RecipeHandlerBase.CachedBaseRecipe {
        PositionedFluidTank tank;

        public CachedGrinderRecipe() {
            super(RecipeHandlerGrinder.this);
            this.tank = new PositionedFluidTank(FluidRegistry.getFluidStack((String)"mobessence", (int)4000), 4000, new Rectangle(111, 2, 16, 60), RecipeHandlerGrinder.this.getGuiTexture(), new Point(176, 0));
            this.tank.showAmount = false;
        }

        public PositionedStack getResult() {
            return null;
        }

        @Override
        public PositionedFluidTank getFluidTank() {
            return this.tank;
        }
    }
}

