/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.scroll;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.nio.FloatBuffer;
import java.util.Stack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiHelper {
    private static final Stack<int[]> scissorFrameStack = new Stack();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void useScissor(int x, int y, int width, int height, Runnable codeBlock) {
        GuiHelper.pushScissorFrame(x, y, width, height);
        try {
            codeBlock.run();
        }
        finally {
            GuiHelper.popScissorFrame();
        }
    }

    private static int[] peekFirstScissorOrFullScreen() {
        int[] currentTopFrame;
        int[] nArray = currentTopFrame = scissorFrameStack.isEmpty() ? null : scissorFrameStack.peek();
        if (currentTopFrame == null) {
            Minecraft minecraft = Minecraft.func_71410_x();
            return new int[]{0, 0, minecraft.field_71443_c, minecraft.field_71440_d};
        }
        return currentTopFrame;
    }

    private static void pushScissorFrame(int x, int y, int width, int height) {
        int[] matrix = GuiHelper.prepareMatrix(x, y, width, height);
        int[] parentScissor = GuiHelper.peekFirstScissorOrFullScreen();
        int parentX = parentScissor[0];
        int parentY = parentScissor[1];
        int parentWidth = parentScissor[2];
        int parentHeight = parentScissor[3];
        boolean pushedFrame = false;
        x = matrix[0];
        y = matrix[1];
        width = matrix[2];
        height = matrix[3];
        if (x <= parentX + parentWidth && y <= parentY + parentHeight) {
            int newX = Math.max(x, parentX);
            int newY = Math.max(y, parentY);
            int newWidth = width - (newX - x);
            int newHeight = height - (newY - y);
            if (newWidth > 0 && newHeight > 0) {
                int maxWidth = parentWidth - (x - parentX);
                int maxHeight = parentHeight - (y - parentY);
                newWidth = Math.min(maxWidth, newWidth);
                newHeight = Math.min(maxHeight, newHeight);
                GuiHelper.applyScissor(newX, newY, newWidth, newHeight);
                if (scissorFrameStack.isEmpty()) {
                    GL11.glEnable((int)3089);
                }
                scissorFrameStack.push(new int[]{newX, newY, newWidth, newHeight});
                pushedFrame = true;
            }
        }
        if (!pushedFrame) {
            if (scissorFrameStack.isEmpty()) {
                GL11.glEnable((int)3089);
            }
            scissorFrameStack.push(new int[]{parentX, parentY, parentWidth, parentHeight});
        }
    }

    public static void popScissorFrame() {
        scissorFrameStack.pop();
        int[] parentScissor = GuiHelper.peekFirstScissorOrFullScreen();
        int parentX = parentScissor[0];
        int parentY = parentScissor[1];
        int parentWidth = parentScissor[2];
        int parentHeight = parentScissor[3];
        GuiHelper.applyScissor(parentX, parentY, parentWidth, parentHeight);
        if (scissorFrameStack.isEmpty()) {
            GL11.glDisable((int)3089);
        }
    }

    private static void applyScissor(int x, int y, int w, int h) {
        Minecraft mc = Minecraft.func_71410_x();
        ScaledResolution res = new ScaledResolution(mc, mc.field_71443_c, mc.field_71440_d);
        int scaleFactor = res.func_78325_e();
        int translatedY = mc.field_71440_d - (y + h) * scaleFactor;
        GL11.glScissor((int)(x * scaleFactor), (int)translatedY, (int)(w * scaleFactor), (int)(h * scaleFactor));
    }

    private static int[] prepareMatrix(int x, int y, int w, int h) {
        FloatBuffer matBuf = BufferUtils.createFloatBuffer((int)16);
        GL11.glGetFloat((int)2982, (FloatBuffer)matBuf);
        float xScale = matBuf.get(0);
        float yScale = matBuf.get(5);
        int xTranslate = (int)(matBuf.get(12) / xScale);
        int yTranslate = (int)(matBuf.get(13) / yScale);
        x += xTranslate;
        y += yTranslate;
        x = (int)((float)x * xScale);
        y = (int)((float)y * yScale);
        w = (int)((float)w * xScale);
        h = (int)((float)h * yScale);
        return new int[]{x, y, w, h};
    }
}

