/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.recipe;

import codechicken.nei.ClientHandler;
import codechicken.nei.ItemStackMap;
import codechicken.nei.LRUCache;
import codechicken.nei.api.IStackStringifyHandler;
import codechicken.nei.api.ItemInfo;
import codechicken.nei.recipe.stackinfo.DefaultStackStringifyHandler;
import codechicken.nei.recipe.stackinfo.GTFluidStackStringifyHandler;
import codechicken.nei.util.ItemStackKey;
import codechicken.nei.util.NBTHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;

public class StackInfo {
    private static final FluidStack NULL_FLUID = new FluidStack(FluidRegistry.WATER, 0);
    public static final List<IStackStringifyHandler> stackStringifyHandlers = new ArrayList<IStackStringifyHandler>();
    private static final Map<String, HashMap<String, String[]>> guidfilters = new HashMap<String, HashMap<String, String[]>>();
    private static final ItemStackMap<String> guidcache = new ItemStackMap();
    private static final LRUCache<ItemStackKey, FluidStack> fluidcache = new LRUCache(200);
    private static boolean isPausedItemDamageSound = false;

    public static NBTTagCompound itemStackToNBT(ItemStack stack) {
        return StackInfo.itemStackToNBT(stack, true);
    }

    public static NBTTagCompound itemStackToNBT(ItemStack stack, boolean saveStackSize) {
        NBTTagCompound nbTag = null;
        for (int i = stackStringifyHandlers.size() - 1; i >= 0 && nbTag == null; --i) {
            nbTag = stackStringifyHandlers.get(i).convertItemStackToNBT(stack, saveStackSize);
        }
        return nbTag;
    }

    public static ItemStack loadFromNBT(NBTTagCompound nbtTag, long customCount) {
        if (nbtTag != null) {
            nbtTag = (NBTTagCompound)nbtTag.func_74737_b();
            nbtTag.func_74768_a("Count", (int)Math.max(Math.min(customCount, Integer.MAX_VALUE), 0L));
            return StackInfo.loadFromNBT(nbtTag);
        }
        return null;
    }

    public static ItemStack loadFromNBT(NBTTagCompound nbtTag) {
        ItemStack stack = null;
        if (nbtTag != null) {
            for (int i = stackStringifyHandlers.size() - 1; i >= 0 && stack == null; --i) {
                stack = stackStringifyHandlers.get(i).convertNBTToItemStack(nbtTag);
            }
        }
        return stack;
    }

    public static ItemStack normalizeRecipeQueryStack(ItemStack stack) {
        ItemStack result = null;
        for (int i = stackStringifyHandlers.size() - 1; i >= 0 && result == null; --i) {
            result = stackStringifyHandlers.get(i).normalizeRecipeQueryStack(stack);
        }
        return result == null ? stack : result;
    }

    public static void pauseItemDamageSound(boolean pause) {
        if (isPausedItemDamageSound != (isPausedItemDamageSound = pause)) {
            for (IStackStringifyHandler handler : stackStringifyHandlers) {
                handler.pauseItemDamageSound(pause);
            }
        }
    }

    public static boolean isPausedItemDamageSound() {
        return isPausedItemDamageSound;
    }

    public static ItemStack withAmount(ItemStack stack, long customCount) {
        if (stack == null) {
            return null;
        }
        NBTTagCompound nbTag = StackInfo.itemStackToNBT(stack);
        return nbTag != null ? StackInfo.loadFromNBT(nbTag, customCount) : null;
    }

    public static int getAmount(ItemStack stack) {
        if (stack == null) {
            return 0;
        }
        NBTTagCompound nbTag = StackInfo.itemStackToNBT(stack);
        return nbTag != null ? nbTag.func_74762_e("Count") : 0;
    }

    public static boolean equalItemAndNBT(ItemStack stackA, ItemStack stackB, boolean useNBT) {
        if (stackA == null || stackB == null || stackA.func_77973_b() != stackB.func_77973_b()) {
            return false;
        }
        if (useNBT && stackA != stackB) {
            NBTTagCompound tagCompoundA = StackInfo.itemStackToNBT(stackA, false);
            NBTTagCompound tagCompoundB = StackInfo.itemStackToNBT(stackB, false);
            return tagCompoundA == null && tagCompoundB == null || tagCompoundA != null && tagCompoundB != null && tagCompoundA.equals((Object)tagCompoundB);
        }
        return true;
    }

    public static synchronized FluidStack getFluid(ItemStack stack) {
        ItemStackKey key = new ItemStackKey(stack);
        FluidStack fluid = (FluidStack)fluidcache.get(key);
        if (fluid == null) {
            for (int i = stackStringifyHandlers.size() - 1; i >= 0 && fluid == null; --i) {
                fluid = stackStringifyHandlers.get(i).getFluid(stack);
            }
            fluidcache.put(key, fluid == null ? NULL_FLUID : fluid);
        }
        return fluid == NULL_FLUID ? null : fluid;
    }

    public static boolean isFluidContainer(ItemStack stack) {
        return stack.func_77973_b() instanceof IFluidContainerItem || FluidContainerRegistry.isContainer((ItemStack)stack);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getItemStackGUID(ItemStack stack) {
        String guid = guidcache.get(stack);
        if (guid != null) {
            return guid;
        }
        NBTTagCompound nbTag = StackInfo.itemStackToNBT(stack, false);
        if (nbTag == null) {
            return "unknown";
        }
        nbTag.func_82580_o("Count");
        if (nbTag.func_74765_d("Damage") == 0) {
            nbTag.func_82580_o("Damage");
        }
        if (nbTag.func_74764_b("tag") && nbTag.func_74775_l("tag").func_82582_d()) {
            nbTag.func_82580_o("tag");
        }
        if (nbTag.func_74764_b("strId") && (guidfilters.containsKey(nbTag.func_74779_i("strId")) || guidfilters.containsKey(nbTag.func_74779_i("strId") + "&" + nbTag.func_74765_d("Damage")))) {
            String strId = nbTag.func_74779_i("strId") + (guidfilters.containsKey(nbTag.func_74779_i("strId")) ? "" : "&" + nbTag.func_74765_d("Damage"));
            ArrayList<String> keys = new ArrayList<String>();
            keys.add(strId);
            guidfilters.get(strId).forEach((key, rule) -> {
                Object local = nbTag;
                for (int i = 0; i < ((String[])rule).length; ++i) {
                    try {
                        if (local instanceof NBTTagCompound) {
                            NBTTagCompound item = local;
                            local = item.func_74781_a(rule[i]);
                            continue;
                        }
                        if (!(local instanceof NBTTagList)) break;
                        NBTTagList item = (NBTTagList)local;
                        local = item.field_74747_a.get(Integer.parseInt(rule[i]));
                        continue;
                    }
                    catch (Throwable e) {
                        break;
                    }
                }
                if (local instanceof NBTBase) {
                    NBTBase item = (NBTBase)local;
                    keys.add(NBTHelper.toString(item));
                } else if (local != null) {
                    keys.add(String.valueOf(local));
                }
            });
            ItemStackMap<String> itemStackMap = guidcache;
            synchronized (itemStackMap) {
                guidcache.put(stack, keys.toString());
            }
        }
        ItemStackMap<String> itemStackMap = guidcache;
        synchronized (itemStackMap) {
            guidcache.put(stack, NBTHelper.toString((NBTBase)nbTag));
        }
        return guidcache.get(stack);
    }

    public static void loadGuidFilters() {
        guidfilters.clear();
        ClientHandler.loadSettingsFile("guidfilters.cfg", lines -> lines.forEach(guidStr -> {
            String[] parts = guidStr.split(",");
            HashMap<String, String[]> rules = new HashMap<String, String[]>();
            for (int j = 1; j < parts.length; ++j) {
                rules.put(parts[j], parts[j].split("\\."));
            }
            guidfilters.put(parts[0], rules);
        }));
    }

    public static ItemStack getItemStackWithMinimumDamage(ItemStack[] stacks) {
        ItemStack result = stacks[0];
        if (stacks.length > 1) {
            for (ItemStack stack : stacks) {
                if (stack.func_77973_b() == null || ItemInfo.isHidden(stack) || stack.func_77960_j() >= result.func_77960_j() && (stack.func_77960_j() != result.func_77960_j() || Item.field_150901_e.func_148750_c((Object)stack.func_77973_b()).compareTo(Item.field_150901_e.func_148750_c((Object)result.func_77973_b())) >= 0)) continue;
                result = stack;
            }
        }
        return result.func_77946_l();
    }

    static {
        stackStringifyHandlers.add(new DefaultStackStringifyHandler());
        stackStringifyHandlers.add(new GTFluidStackStringifyHandler());
    }
}

