/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.config;

import codechicken.nei.config.OptionButton;

public class OptionCycled
extends OptionButton {
    public final int count;
    public final boolean prefixed;

    public OptionCycled(String name, int count, boolean prefixed) {
        super(name);
        this.count = count;
        this.prefixed = prefixed;
    }

    public OptionCycled(String name, int count) {
        this(name, count, false);
    }

    public int value() {
        return this.renderTag().getIntValue();
    }

    @Override
    public String getButtonText() {
        return this.translateN(this.name + "." + this.value(), new Object[0]);
    }

    @Override
    public String getPrefix() {
        return this.prefixed ? this.translateN(this.name, new Object[0]) : null;
    }

    @Override
    public String getTooltip() {
        String tooltip = this.name + "." + this.value() + ".tip";
        String s = this.translateN(tooltip, new Object[0]);
        if (!s.equals(this.namespaced(tooltip))) {
            return s;
        }
        return super.getTooltip();
    }

    @Override
    public boolean onClick(int button) {
        return this.cycle();
    }

    public boolean cycle() {
        int next = this.value();
        while (!this.optionValid(next = (next + 1) % this.count)) {
        }
        if (next == this.value()) {
            return false;
        }
        this.getTag().setIntValue(next);
        return true;
    }

    public boolean optionValid(int index) {
        return true;
    }
}

