/*
 * Decompiled with CFR 0.152.
 */
package openmods.entity;

import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.ForgeDirection;
import openmods.Log;
import openmods.fakeplayer.FakePlayerPool;
import openmods.fakeplayer.OpenModsFakePlayer;
import openmods.utils.BlockManipulator;
import openmods.utils.BlockProperties;

public class EntityBlock
extends Entity
implements IEntityAdditionalSpawnData {
    private static final String TAG_TILE_ENTITY = "TileEntity";
    private static final String TAG_BLOCK_META = "BlockMeta";
    private static final String TAG_BLOCK_NAME = "BlockName";
    private static final int OBJECT_BLOCK_NAME = 11;
    private static final int OBJECT_BLOCK_META = 12;
    private boolean hasGravity = false;
    private boolean shouldDrop = true;
    private boolean hasAirResistance = true;
    public static final ForgeDirection[] PLACE_DIRECTIONS = new ForgeDirection[]{ForgeDirection.UNKNOWN, ForgeDirection.UP, ForgeDirection.NORTH, ForgeDirection.SOUTH, ForgeDirection.WEST, ForgeDirection.EAST, ForgeDirection.DOWN};
    private NBTTagCompound tileEntity;

    public EntityBlock(World world) {
        super(world);
        this.func_70105_a(0.925f, 0.925f);
    }

    private void setHeight(float height) {
        this.field_70131_O = height;
        this.field_70129_M = 0.0f;
    }

    public static EntityBlock create(EntityPlayer player, World world, int x, int y, int z) {
        return EntityBlock.create(player, world, x, y, z, EntityBlock.class);
    }

    public static EntityBlock create(EntityPlayer player, World world, int x, int y, int z, Class<? extends EntityBlock> klazz) {
        boolean blockRemoved;
        EntityBlock entity;
        Block block = world.func_147439_a(x, y, z);
        if (block.isAir((IBlockAccess)world, x, y, z)) {
            return null;
        }
        int meta = world.func_72805_g(x, y, z);
        try {
            entity = klazz.getConstructor(World.class).newInstance(world);
        }
        catch (Throwable t) {
            Log.warn(t, "Failed to create EntityBlock(%s) at %d,%d,%d", klazz, x, y, z);
            return null;
        }
        entity.setBlockNameAndMeta(BlockProperties.getBlockName(block), meta);
        TileEntity te = world.func_147438_o(x, y, z);
        if (te != null) {
            entity.tileEntity = new NBTTagCompound();
            te.func_145841_b(entity.tileEntity);
        }
        if (!(blockRemoved = new BlockManipulator(world, player, x, y, z).setSilentTeRemove(true).remove())) {
            return null;
        }
        entity.func_70080_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, 0.0f, 0.0f);
        return entity;
    }

    protected void func_70088_a() {
        this.field_70180_af.func_75682_a(11, (Object)BlockProperties.getBlockName(Blocks.field_150357_h));
        this.field_70180_af.func_75682_a(12, (Object)0);
    }

    public void setBlockNameAndMeta(String name, int meta) {
        this.field_70180_af.func_75692_b(11, (Object)name);
        this.field_70180_af.func_75692_b(12, (Object)meta);
    }

    public String getBlockName() {
        return this.field_70180_af.func_75681_e(11);
    }

    public Block getBlock() {
        return BlockProperties.getBlockByName(this.getBlockName());
    }

    public int getBlockMeta() {
        return this.field_70180_af.func_75679_c(12);
    }

    public void setShouldDrop(boolean bool) {
        this.shouldDrop = bool;
    }

    public void setHasAirResistance(boolean bool) {
        this.hasAirResistance = bool;
    }

    protected void func_70037_a(NBTTagCompound tag) {
        String blockName = tag.func_74779_i(TAG_BLOCK_NAME);
        Block block = BlockProperties.getBlockByName(blockName);
        if (block == null) {
            this.func_70106_y();
            return;
        }
        int blockMeta = tag.func_74762_e(TAG_BLOCK_META);
        this.setBlockNameAndMeta(blockName, blockMeta);
        this.tileEntity = tag.func_150297_b(TAG_TILE_ENTITY, 10) ? tag.func_74775_l(TAG_TILE_ENTITY) : null;
    }

    protected void func_70014_b(NBTTagCompound tag) {
        tag.func_74778_a(TAG_BLOCK_NAME, this.getBlockName());
        tag.func_74768_a(TAG_BLOCK_META, this.getBlockMeta());
        if (this.tileEntity != null) {
            tag.func_74782_a(TAG_TILE_ENTITY, this.tileEntity.func_74737_b());
        }
    }

    public void func_70071_h_() {
        if (this.field_70163_u < -500.0) {
            this.func_70106_y();
            return;
        }
        if (this.hasGravity) {
            this.field_70181_x -= (double)0.04f;
        }
        if (this.hasAirResistance) {
            this.field_70159_w *= 0.98;
            this.field_70181_x *= 0.98;
            this.field_70179_y *= 0.98;
        }
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        this.func_70066_B();
        this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
        Block block = this.getBlock();
        if (block == null) {
            this.func_70106_y();
        } else {
            this.setHeight((float)block.func_149669_A());
        }
        if (this.field_70170_p instanceof WorldServer && this.shouldPlaceBlock()) {
            int z;
            int y;
            int x = MathHelper.func_76128_c((double)this.field_70165_t);
            if (!this.tryPlaceBlock((WorldServer)this.field_70170_p, x, y = MathHelper.func_76128_c((double)this.field_70163_u), z = MathHelper.func_76128_c((double)this.field_70161_v))) {
                this.dropBlock();
            }
            this.func_70106_y();
        }
    }

    protected boolean shouldPlaceBlock() {
        return this.field_70122_E && this.shouldDrop;
    }

    private boolean tryPlaceBlock(WorldServer world, final int baseX, final int baseY, final int baseZ) {
        return FakePlayerPool.instance.executeOnPlayer(world, new FakePlayerPool.PlayerUserReturning<Boolean>(){

            @Override
            public Boolean usePlayer(OpenModsFakePlayer fakePlayer) {
                for (ForgeDirection dir : PLACE_DIRECTIONS) {
                    boolean blockPlaced;
                    int x = baseX + dir.offsetX;
                    int y = baseY + dir.offsetY;
                    int z = baseZ + dir.offsetZ;
                    if (!EntityBlock.this.field_70170_p.func_147437_c(x, y, z) || !(blockPlaced = new BlockManipulator(EntityBlock.this.field_70170_p, (EntityPlayer)fakePlayer, x, y, z).place(EntityBlock.this.getBlock(), EntityBlock.this.getBlockMeta()))) continue;
                    if (EntityBlock.this.tileEntity != null) {
                        EntityBlock.this.tileEntity.func_74768_a("x", x);
                        EntityBlock.this.tileEntity.func_74768_a("y", y);
                        EntityBlock.this.tileEntity.func_74768_a("z", z);
                        TileEntity te = EntityBlock.this.field_70170_p.func_147438_o(x, y, z);
                        te.func_145839_a(EntityBlock.this.tileEntity);
                    }
                    return true;
                }
                return false;
            }
        });
    }

    private void dropBlock() {
        ItemStack item = new ItemStack(this.getBlock(), 1, this.getBlockMeta());
        this.func_70099_a(item, 0.1f);
        if (this.tileEntity instanceof IInventory) {
            IInventory inv = (IInventory)this.tileEntity;
            for (int i = 0; i < inv.func_70302_i_(); ++i) {
                ItemStack is = inv.func_70301_a(i);
                if (is == null) continue;
                this.func_70099_a(is, 0.1f);
            }
        }
    }

    public void setHasGravity(boolean gravity) {
        this.hasGravity = gravity;
    }

    public boolean hasGravity() {
        return this.hasGravity;
    }

    @SideOnly(value=Side.CLIENT)
    public float func_70053_R() {
        return 0.0f;
    }

    public boolean func_90999_ad() {
        return false;
    }

    public boolean func_70067_L() {
        return !this.field_70128_L;
    }

    public boolean func_70104_M() {
        return !this.field_70128_L;
    }

    protected void func_70081_e(int i) {
    }

    public void writeSpawnData(ByteBuf data) {
        data.writeBoolean(this.hasGravity);
    }

    public boolean func_70097_a(DamageSource p_70097_1_, float p_70097_2_) {
        if (!this.field_70128_L && !this.field_70170_p.field_72995_K) {
            this.dropBlock();
        }
        this.func_70106_y();
        return false;
    }

    public void readSpawnData(ByteBuf additionalData) {
        this.hasGravity = additionalData.readBoolean();
    }
}

