/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.gtnhlib.client.model.template;

import com.gtnewhorizon.gtnhlib.blockpos.IBlockPos;
import com.gtnewhorizon.gtnhlib.client.model.template.BlockStaticCube;
import com.gtnewhorizon.gtnhlib.client.renderer.quad.Quad;
import com.gtnewhorizon.gtnhlib.client.renderer.quad.QuadProvider;
import com.gtnewhorizon.gtnhlib.client.renderer.quad.QuadView;
import it.unimi.dsi.fastutil.objects.ObjectImmutableList;
import java.util.List;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockColoredCube
extends BlockStaticCube {
    private ThreadLocal<List<QuadView>[]> threadedStore;

    public BlockColoredCube(String block) {
        super(block);
    }

    @Override
    protected void bake() {
        super.bake();
        this.threadedStore = ThreadLocal.withInitial(() -> {
            List[] ret = new List[7];
            for (int i = 0; i < 6; ++i) {
                ret[i] = this.store[i].stream().map(new Quad()::copyFrom).collect(ObjectImmutableList.toListWithExpectedSize(1));
            }
            ret[6] = ObjectImmutableList.of();
            return ret;
        });
    }

    @Override
    public int getColor(IBlockAccess world, IBlockPos pos, Block block, int meta, Random random) {
        return QuadProvider.getDefaultColor(world, pos, block);
    }

    @Override
    public List<QuadView> getQuads(IBlockAccess world, IBlockPos pos, Block block, int meta, ForgeDirection dir, Random random, int color, Supplier<QuadView> quadPool) {
        List<QuadView> ret = this.threadedStore.get()[dir.ordinal()];
        if (dir != ForgeDirection.UNKNOWN) {
            ret.get(0).setColors(color);
        }
        return ret;
    }
}

