/*
 * Decompiled with CFR 0.152.
 */
package de.keridos.floodlights.tileentity;

import de.keridos.floodlights.handler.ConfigHandler;
import de.keridos.floodlights.tileentity.TileEntityFLElectric;
import de.keridos.floodlights.util.MathUtil;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntitySmallFloodlight
extends TileEntityFLElectric {
    private boolean rotationState = false;

    @Override
    public void readOwnFromNBT(NBTTagCompound nbtTagCompound) {
        super.readOwnFromNBT(nbtTagCompound);
        if (nbtTagCompound.func_74764_b("teRotationState")) {
            this.rotationState = nbtTagCompound.func_74767_n("teRotationState");
        }
    }

    @Override
    public void writeOwnToNBT(NBTTagCompound nbtTagCompound) {
        super.writeOwnToNBT(nbtTagCompound);
        nbtTagCompound.func_74757_a("teRotationState", this.rotationState);
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        return from.getOpposite().ordinal() == this.orientation.ordinal();
    }

    public void toggleRotationState() {
        this.rotationState = !this.rotationState;
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public boolean getRotationState() {
        return this.rotationState;
    }

    public void setRotationState(boolean rotationState) {
        this.rotationState = rotationState;
    }

    public void smallSource(boolean remove) {
        for (int i = 0; i < 5; ++i) {
            int a = 0;
            int b = 0;
            int c = 0;
            if (i == 0) {
                a = 1;
                c = 0;
                b = 0;
            } else if (i == 1) {
                c = 0;
                a = 0;
                b = 1;
            } else if (i == 2) {
                c = 0;
                a = 0;
                b = -1;
            } else if (i == 3) {
                b = 0;
                a = 0;
                c = 1;
            } else if (i == 4) {
                b = 0;
                a = 0;
                c = -1;
            }
            int[] rotatedCoords = MathUtil.rotate(a, b, c, this.orientation);
            int x = this.field_145851_c + rotatedCoords[0];
            int y = this.field_145848_d + rotatedCoords[1];
            int z = this.field_145849_e + rotatedCoords[2];
            this.setLightChecked(x, y, z, remove);
        }
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        World world = this.func_145831_w();
        if (!world.field_72995_K) {
            int realEnergyUsage = ConfigHandler.energyUsageSmallFloodlight;
            if (this.timeout > 0) {
                --this.timeout;
                return;
            }
            if (this.active && (this.storage.getEnergyStored() >= realEnergyUsage || this.storageEU >= (double)realEnergyUsage / 8.0)) {
                if (this.update) {
                    this.smallSource(true);
                    this.smallSource(false);
                    world.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                    this.update = false;
                } else if (!this.wasActive) {
                    this.smallSource(false);
                    world.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                }
                if (this.storageEU >= (double)realEnergyUsage / 8.0) {
                    this.storageEU -= (double)realEnergyUsage / 8.0;
                } else {
                    this.storage.modifyEnergyStored(-realEnergyUsage);
                }
                this.wasActive = true;
            } else if ((!this.active || this.storage.getEnergyStored() < realEnergyUsage && this.storageEU < (double)realEnergyUsage / 8.0) && this.wasActive) {
                this.smallSource(true);
                world.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                this.wasActive = false;
                this.timeout = ConfigHandler.timeoutFloodlights;
                this.update = false;
            }
        }
    }
}

