/*
 * Decompiled with CFR 0.152.
 */
package com.djgiannuzz.thaumcraftneiplugin.nei.recipehandler;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.OffsetPositioner;
import codechicken.nei.PositionedStack;
import codechicken.nei.api.IOverlayHandler;
import codechicken.nei.api.IRecipeOverlayRenderer;
import codechicken.nei.api.IStackPositioner;
import codechicken.nei.recipe.RecipeInfo;
import codechicken.nei.recipe.ShapedRecipeHandler;
import codechicken.nei.recipe.TemplateRecipeHandler;
import com.djgiannuzz.thaumcraftneiplugin.items.ItemAspect;
import com.djgiannuzz.thaumcraftneiplugin.nei.NEIHelper;
import com.djgiannuzz.thaumcraftneiplugin.nei.overlay.ArcaneWorkbenchOverlayRenderer;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;
import org.lwjgl.opengl.GL11;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.ThaumcraftApiHelper;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.crafting.ShapedArcaneRecipe;
import thaumcraft.api.wands.WandCap;
import thaumcraft.api.wands.WandRod;
import thaumcraft.client.gui.GuiArcaneWorkbench;
import thaumcraft.client.lib.UtilsFX;
import thaumcraft.common.items.wands.ItemWandCasting;

public class ArcaneShapedRecipeHandler
extends ShapedRecipeHandler {
    public static final String OVERLAY_IDENTIFIER = "arcaneshapedrecipes";
    protected ArrayList<int[]> aspectsAmount = new ArrayList();
    String username;
    public static final int[][][] positions = new int[][][]{new int[][]{{48, 33}, {75, 33}, {103, 33}}, new int[][]{{49, 60}, {76, 60}, {103, 60}}, new int[][]{{49, 87}, {76, 87}, {103, 87}}};

    public ArcaneShapedRecipeHandler() {
        this.username = Minecraft.func_71410_x().field_71439_g.getDisplayName();
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(26, -14, 110, 13), this.getOverlayIdentifier(), new Object[0]));
    }

    public int recipiesPerPage() {
        return 1;
    }

    public String getOverlayIdentifier() {
        return OVERLAY_IDENTIFIER;
    }

    public Class<? extends GuiContainer> getGuiClass() {
        return GuiArcaneWorkbench.class;
    }

    public boolean hasOverlay(GuiContainer gui, Container container, int recipe) {
        return RecipeInfo.hasDefaultOverlay((GuiContainer)gui, (String)this.getOverlayIdentifier()) || RecipeInfo.hasOverlayHandler((GuiContainer)gui, (String)this.getOverlayIdentifier());
    }

    public IRecipeOverlayRenderer getOverlayRenderer(GuiContainer gui, int recipe) {
        ArrayList<PositionedStack> ingred = new ArrayList<PositionedStack>();
        if (this.arecipes.get(recipe) != null) {
            if (this.arecipes.get(recipe) instanceof ArcaneShapedCachedRecipe) {
                ArcaneShapedCachedRecipe arcaneRecipe = (ArcaneShapedCachedRecipe)((Object)this.arecipes.get(recipe));
                ingred = arcaneRecipe.getPositionedStacksForOverlay();
            } else if (this.arecipes.get(recipe) instanceof ArcaneWandChachedRecipe) {
                ArcaneWandChachedRecipe arcaneRecipe = (ArcaneWandChachedRecipe)((Object)this.arecipes.get(recipe));
                ingred = arcaneRecipe.getPositionedStacksForOverlay();
            }
        }
        return new ArcaneWorkbenchOverlayRenderer(ingred, (IStackPositioner)new OffsetPositioner(0, 0));
    }

    public IOverlayHandler getOverlayHandler(GuiContainer gui, int recipe) {
        return RecipeInfo.getOverlayHandler((GuiContainer)gui, (String)this.getOverlayIdentifier());
    }

    public String getRecipeName() {
        return StatCollector.func_74838_a((String)"recipe.type.arcaneworkbenchshaped");
    }

    public void drawExtras(int recipe) {
        NEIHelper.drawAspectsArcane(this.aspectsAmount.get(recipe));
    }

    protected static int[] getAmounts(ShapedArcaneRecipe recipe) {
        int[] amounts = new int[Aspect.getPrimalAspects().size()];
        AspectList aspects = recipe.getAspects();
        int i = 0;
        for (Aspect aspect : Aspect.getPrimalAspects()) {
            amounts[i] = aspects.getAmount(aspect);
            ++i;
        }
        return amounts;
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals(this.getOverlayIdentifier())) {
            for (Object o : ThaumcraftApi.getCraftingRecipes()) {
                ShapedArcaneRecipe tcRecipe;
                ArcaneShapedCachedRecipe recipe;
                if (o == null || !(o instanceof ShapedArcaneRecipe) || (recipe = new ArcaneShapedCachedRecipe(tcRecipe = (ShapedArcaneRecipe)o)) == null || !recipe.isValid() || !ThaumcraftApiHelper.isResearchComplete((String)this.username, (String)tcRecipe.getResearch())) continue;
                recipe.computeVisuals();
                this.arecipes.add(recipe);
                this.aspectsAmount.add(ArcaneShapedRecipeHandler.getAmounts(tcRecipe));
            }
        } else if (outputId.equals("item")) {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        if (result != null && result.func_77973_b() instanceof ItemWandCasting) {
            ItemWandCasting wand = (ItemWandCasting)result.func_77973_b();
            WandRod rod = wand.getRod(result);
            WandCap cap = wand.getCap(result);
            if (wand.isSceptre(result) && !ThaumcraftApiHelper.isResearchComplete((String)this.username, (String)"SCEPTRE")) {
                return;
            }
            if (!ThaumcraftApiHelper.isResearchComplete((String)this.username, (String)cap.getResearch()) || !ThaumcraftApiHelper.isResearchComplete((String)this.username, (String)rod.getResearch())) {
                return;
            }
            ArcaneWandChachedRecipe recipe = new ArcaneWandChachedRecipe(rod, cap, result, wand.isSceptre(result));
            recipe.computeVisuals();
            this.arecipes.add(recipe);
            this.aspectsAmount.add(NEIHelper.getWandAspectsWandCost(result));
            return;
        }
        for (Object o : ThaumcraftApi.getCraftingRecipes()) {
            ShapedArcaneRecipe tcRecipe;
            ArcaneShapedCachedRecipe recipe;
            if (o == null || !(o instanceof ShapedArcaneRecipe) || (recipe = new ArcaneShapedCachedRecipe(tcRecipe = (ShapedArcaneRecipe)o)) == null || !recipe.isValid() || !ThaumcraftApiHelper.isResearchComplete((String)this.username, (String)tcRecipe.getResearch()) || !NEIServerUtils.areStacksSameTypeCrafting((ItemStack)tcRecipe.getRecipeOutput(), (ItemStack)result) || !recipe.isValid()) continue;
            recipe.computeVisuals();
            this.arecipes.add(recipe);
            this.aspectsAmount.add(ArcaneShapedRecipeHandler.getAmounts(tcRecipe));
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        for (Object o : ThaumcraftApi.getCraftingRecipes()) {
            ShapedArcaneRecipe tcRecipe;
            ArcaneShapedCachedRecipe recipe;
            if (o == null || !(o instanceof ShapedArcaneRecipe) || (recipe = new ArcaneShapedCachedRecipe(tcRecipe = (ShapedArcaneRecipe)o)) == null || !recipe.isValid() || !recipe.contains(recipe.ingredients, ingredient) || !ThaumcraftApiHelper.isResearchComplete((String)this.username, (String)tcRecipe.getResearch())) continue;
            recipe.computeVisuals();
            recipe.setIngredientPermutation(recipe.ingredients, ingredient);
            this.arecipes.add(recipe);
            this.aspectsAmount.add(ArcaneShapedRecipeHandler.getAmounts(tcRecipe));
        }
    }

    public void drawBackground(int recipe) {
        int x = 34;
        int y = -15;
        UtilsFX.bindTexture((String)"textures/gui/gui_researchbook_overlay.png");
        GL11.glPushMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)3042);
        GL11.glTranslatef((float)x, (float)y, (float)0.0f);
        GL11.glScalef((float)1.7f, (float)1.7f, (float)1.0f);
        GuiDraw.drawTexturedModalRect((int)2, (int)23, (int)112, (int)15, (int)52, (int)52);
        GuiDraw.drawTexturedModalRect((int)20, (int)7, (int)20, (int)3, (int)16, (int)16);
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.4f);
        GL11.glEnable((int)3042);
        GL11.glTranslatef((float)x, (float)(y + 164), (float)0.0f);
        GL11.glScalef((float)2.0f, (float)2.0f, (float)1.0f);
        GuiDraw.drawTexturedModalRect((int)0, (int)0, (int)68, (int)76, (int)12, (int)12);
        GL11.glPopMatrix();
    }

    public List<PositionedStack> getIngredientStacksForOverlay(int recipe) {
        if (this.arecipes.get(recipe) instanceof ArcaneShapedCachedRecipe) {
            return ((ArcaneShapedCachedRecipe)((Object)this.arecipes.get(recipe))).getPositionedStacksForOverlay();
        }
        return null;
    }

    private class ArcaneShapedCachedRecipe
    extends ShapedRecipeHandler.CachedShapedRecipe {
        protected AspectList aspects;
        protected Object[] overlay;
        protected int width;
        protected int height;

        public ArcaneShapedCachedRecipe(ShapedArcaneRecipe recipe) {
            super((ShapedRecipeHandler)ArcaneShapedRecipeHandler.this, recipe.width, recipe.height, recipe.getInput(), recipe.getRecipeOutput());
            this.result = new PositionedStack((Object)recipe.getRecipeOutput(), 74, 2);
            this.aspects = recipe.getAspects();
            this.overlay = recipe.getInput();
            this.width = recipe.width;
            this.height = recipe.height;
            NEIHelper.addAspectsToIngredients(this.aspects, this.ingredients, 0);
        }

        public AspectList getAspectList() {
            return this.aspects;
        }

        public boolean isValid() {
            return !this.ingredients.isEmpty() && this.result != null;
        }

        public void setIngredients(int width, int height, Object[] items) {
            if (items != null && items.length > 0) {
                int y;
                int x;
                int[][][] positions2 = new int[width][height][2];
                int shiftX = 0;
                int shiftY = 0;
                for (x = 0; x < width && x < 3; ++x) {
                    for (y = 0; y < height && y < 3; ++y) {
                        positions2[x][y][0] = positions[y][x][0];
                        positions2[x][y][1] = positions[y][x][1];
                    }
                }
                for (x = 0; x < width && x < 3; ++x) {
                    for (y = 0; y < height && y < 3; ++y) {
                        if (items[y * width + x] == null || !(items[y * width + x] instanceof ItemStack) && !(items[y * width + x] instanceof ItemStack[]) && !(items[y * width + x] instanceof String) && !(items[y * width + x] instanceof List) || items[y * width + x] instanceof List && ((List)items[y * width + x]).isEmpty()) continue;
                        PositionedStack stack = new PositionedStack(items[y * width + x], positions2[x][y][0] + shiftX, positions2[x][y][1] + shiftY, false);
                        stack.setMaxSize(1);
                        this.ingredients.add(stack);
                    }
                }
            }
        }

        private void printMatrix3(int[][][] m) {
            for (int i = 0; i < m.length; ++i) {
                for (int j = 0; j < m[0].length; ++j) {
                    System.out.print("{" + m[i][j][0] + ", " + m[i][j][1] + "} ");
                }
                System.out.println();
            }
        }

        public ArrayList<PositionedStack> getPositionedStacksForOverlay() {
            ArrayList<PositionedStack> stacks = new ArrayList<PositionedStack>();
            if (this.overlay != null && this.overlay.length > 0) {
                for (int x = 0; x < this.width; ++x) {
                    for (int y = 0; y < this.height; ++y) {
                        if (this.overlay[y * this.width + x] == null || !(this.overlay[y * this.width + x] instanceof ItemStack) && !(this.overlay[y * this.width + x] instanceof ItemStack[]) && !(this.overlay[y * this.width + x] instanceof String) && !(this.overlay[y * this.width + x] instanceof List) || this.overlay[y * this.width + x] instanceof List && ((List)this.overlay[y * this.width + x]).isEmpty()) continue;
                        stacks.add(new PositionedStack(this.overlay[y * this.width + x], 40 + x * 24, 40 + y * 24));
                    }
                }
            }
            return stacks;
        }

        public boolean contains(Collection<PositionedStack> ingredients, ItemStack ingredient) {
            if (ingredient.func_77973_b() instanceof ItemAspect) {
                return false;
            }
            return super.contains(ingredients, ingredient);
        }
    }

    private class ArcaneWandChachedRecipe
    extends ShapedRecipeHandler.CachedShapedRecipe {
        protected AspectList aspects;
        protected Object[] overlay;

        public ArcaneWandChachedRecipe(WandRod rod, WandCap cap, ItemStack result) {
            this(rod, cap, result, false);
        }

        public ArcaneWandChachedRecipe(WandRod rod, WandCap cap, ItemStack result, boolean isScepter) {
            super((ShapedRecipeHandler)ArcaneShapedRecipeHandler.this, 3, 3, isScepter ? NEIHelper.buildScepterInput(rod, cap) : NEIHelper.buildWandInput(rod, cap), result);
            this.overlay = isScepter ? NEIHelper.buildScepterInput(rod, cap) : NEIHelper.buildWandInput(rod, cap);
            this.result = new PositionedStack((Object)result, 74, 2);
            this.aspects = NEIHelper.getPrimalAspectListFromAmounts(NEIHelper.getWandAspectsWandCost(result));
            NEIHelper.addAspectsToIngredients(this.aspects, this.ingredients, 0);
        }

        public boolean isValid() {
            return !this.ingredients.isEmpty() && this.result != null;
        }

        public void setIngredients(int width, int height, Object[] items) {
            if (items != null && items.length > 0) {
                int[][] positions = new int[][]{{48, 32}, {75, 33}, {103, 33}, {49, 60}, {76, 60}, {103, 60}, {49, 87}, {76, 87}, {103, 87}};
                int[][] positions2 = new int[][]{{48, 32}, {75, 33}, {49, 60}, {76, 60}};
                int shiftX = 0;
                int shiftY = 0;
                for (int x = 0; x < width; ++x) {
                    for (int y = 0; y < height; ++y) {
                        if (items[y * width + x] == null || !(items[y * width + x] instanceof ItemStack) && !(items[y * width + x] instanceof ItemStack[]) && !(items[y * width + x] instanceof String) && !(items[y * width + x] instanceof List) || items[y * width + x] instanceof List && ((List)items[y * width + x]).isEmpty()) continue;
                        if (width == 2 && height == 2) {
                            positions = positions2;
                        }
                        PositionedStack stack = new PositionedStack(items[y * width + x], positions[y * width + x][0] + shiftX, positions[y * width + x][1] + shiftY, false);
                        stack.setMaxSize(1);
                        this.ingredients.add(stack);
                    }
                }
            }
        }

        public ArrayList<PositionedStack> getPositionedStacksForOverlay() {
            ArrayList<PositionedStack> stacks = new ArrayList<PositionedStack>();
            if (this.overlay != null && this.overlay.length > 0) {
                boolean shiftX = false;
                boolean shiftY = false;
                for (int x = 0; x < 3; ++x) {
                    for (int y = 0; y < 3; ++y) {
                        if (this.overlay[y * 3 + x] == null || !(this.overlay[y * 3 + x] instanceof ItemStack) && !(this.overlay[y * 3 + x] instanceof ItemStack[]) && !(this.overlay[y * 3 + x] instanceof String) && !(this.overlay[y * 3 + x] instanceof List) || this.overlay[y * 3 + x] instanceof List && ((List)this.overlay[y * 3 + x]).isEmpty()) continue;
                        stacks.add(new PositionedStack(this.overlay[y * 3 + x], 40 + x * 24, 40 + y * 24));
                    }
                }
            }
            return stacks;
        }

        public boolean contains(Collection<PositionedStack> ingredients, ItemStack ingredient) {
            if (ingredient.func_77973_b() instanceof ItemAspect) {
                return false;
            }
            return super.contains(ingredients, ingredient);
        }
    }
}

