/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.list;

import buildcraft.api.lists.ListMatchHandler;
import buildcraft.core.lib.inventory.StackHelper;
import buildcraft.core.lib.utils.FluidUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;

public class ListMatchHandlerFluid
extends ListMatchHandler {
    @Override
    public boolean matches(ListMatchHandler.Type type, ItemStack stack, ItemStack target, boolean precise) {
        if (type == ListMatchHandler.Type.TYPE) {
            ItemStack emptyContainerTarget;
            ItemStack emptyContainerStack;
            if (FluidContainerRegistry.isContainer((ItemStack)stack) && FluidContainerRegistry.isContainer((ItemStack)target) && StackHelper.isMatchingItem(emptyContainerStack = FluidContainerRegistry.drainFluidContainer((ItemStack)stack), emptyContainerTarget = FluidContainerRegistry.drainFluidContainer((ItemStack)target), true, true)) {
                return true;
            }
        } else if (type == ListMatchHandler.Type.MATERIAL) {
            FluidStack fStack = FluidUtils.getFluidStackFromItemStack(stack);
            FluidStack fTarget = FluidUtils.getFluidStackFromItemStack(target);
            if (fStack != null && fTarget != null) {
                return fStack.isFluidEqual(fTarget);
            }
        }
        return false;
    }

    @Override
    public boolean isValidSource(ListMatchHandler.Type type, ItemStack stack) {
        if (type == ListMatchHandler.Type.TYPE) {
            return FluidContainerRegistry.isContainer((ItemStack)stack);
        }
        if (type == ListMatchHandler.Type.MATERIAL) {
            return FluidUtils.getFluidStackFromItemStack(stack) != null;
        }
        return false;
    }

    @Override
    public List<ItemStack> getClientExamples(ListMatchHandler.Type type, ItemStack stack) {
        if (type == ListMatchHandler.Type.MATERIAL) {
            FluidStack fStack = FluidUtils.getFluidStackFromItemStack(stack);
            if (fStack != null) {
                ArrayList<ItemStack> examples = new ArrayList<ItemStack>();
                for (FluidContainerRegistry.FluidContainerData data : FluidContainerRegistry.getRegisteredFluidContainerData()) {
                    if (!fStack.isFluidEqual(data.fluid)) continue;
                    examples.add(data.filledContainer);
                }
                return examples;
            }
        } else if (type == ListMatchHandler.Type.TYPE && FluidContainerRegistry.isContainer((ItemStack)stack)) {
            ArrayList<ItemStack> examples = new ArrayList<ItemStack>();
            ItemStack emptyContainerStack = FluidContainerRegistry.drainFluidContainer((ItemStack)stack);
            examples.add(stack);
            examples.add(emptyContainerStack);
            for (FluidContainerRegistry.FluidContainerData data : FluidContainerRegistry.getRegisteredFluidContainerData()) {
                if (!StackHelper.isMatchingItem(data.emptyContainer, emptyContainerStack, true, true)) continue;
                examples.add(data.filledContainer);
            }
            return examples;
        }
        return null;
    }
}

