/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.betterbarrels.common.items.dolly;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.registry.GameData;
import forestry.factory.recipes.MemorizedRecipe;
import forestry.factory.recipes.RecipeMemory;
import forestry.factory.tiles.TileWorktable;
import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import mcp.mobius.betterbarrels.BetterBarrels;
import mcp.mobius.betterbarrels.Utils;
import mcp.mobius.betterbarrels.common.JabbaCreativeTab;
import mcp.mobius.betterbarrels.common.LocalizedChat;
import mcp.mobius.betterbarrels.common.blocks.TileEntityBarrel;
import mcp.mobius.betterbarrels.network.BarrelPacketHandler;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class ItemBarrelMover
extends Item {
    protected IIcon text_empty = null;
    protected IIcon text_filled = null;
    protected DollyType type = DollyType.NORMAL;
    private static final String PREVENT_FOLD_TAG_KEY = "prevent_fold";
    protected static ArrayList<Class> classExtensions = new ArrayList();
    protected static ArrayList<String> classExtensionsNames = new ArrayList();
    protected static HashMap<String, Class> classMap = new HashMap();
    protected static ArrayList<String> spawnerClassExtensionsNames = new ArrayList();
    protected static Set<Class<?>> spawnerClasses = new HashSet();
    protected Method tagCompoundWrite = Utils.ReflectionHelper.getMethod(NBTTagCompound.class, new String[]{"a", "func_74734_a", "write"}, new Class[]{DataOutput.class});

    public ItemBarrelMover() {
        this.func_77625_d(1);
        this.func_77637_a(JabbaCreativeTab.tab);
        this.setNoRepair();
    }

    public void func_94581_a(IIconRegister par1IconRegister) {
        this.text_empty = this.field_77791_bV = par1IconRegister.func_94245_a("JABBA:dolly_" + this.type.name().toLowerCase() + "_empty");
        this.text_filled = par1IconRegister.func_94245_a("JABBA:dolly_" + this.type.name().toLowerCase() + "_filled");
    }

    public String func_77658_a() {
        return this.func_77667_c(null);
    }

    public String func_77667_c(ItemStack stack) {
        if (stack != null && stack.func_77942_o() && stack.func_77978_p().func_74764_b("Container")) {
            return "item.dolly." + this.type.name().toLowerCase() + ".full";
        }
        return "item.dolly." + this.type.name().toLowerCase() + ".empty";
    }

    public IIcon getIcon(ItemStack stack, int pass) {
        return this.func_77650_f(stack);
    }

    public IIcon func_77650_f(ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("Container")) {
            return this.text_filled;
        }
        return this.text_empty;
    }

    public boolean onItemUseFirst(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return false;
        }
        if (FMLCommonHandler.instance().getMinecraftServerInstance().func_96290_a(world, x, y, z, player)) {
            return false;
        }
        if (!stack.func_77942_o() || !stack.func_77978_p().func_74764_b("Container")) {
            return this.pickupContainer(stack, player, world, x, y, z);
        }
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("Container")) {
            stack.func_77978_p().func_74757_a(PREVENT_FOLD_TAG_KEY, true);
            return this.placeContainer(stack, player, world, x, y, z, side);
        }
        return false;
    }

    public ItemStack func_77659_a(ItemStack itemStack, World world, EntityPlayer player) {
        if (world.field_72995_K) {
            return itemStack;
        }
        if (BetterBarrels.disableDollyStacking) {
            return itemStack;
        }
        if (itemStack.func_77942_o() && itemStack.func_77978_p().func_74764_b(PREVENT_FOLD_TAG_KEY)) {
            itemStack.func_77978_p().func_82580_o(PREVENT_FOLD_TAG_KEY);
            return itemStack;
        }
        if (!(!player.func_70093_af() || this.type != DollyType.NORMAL || itemStack.func_77942_o() && itemStack.func_77978_p().func_74764_b("Container"))) {
            EntityItem newItem = new EntityItem(world, player.field_70165_t, player.field_70163_u, player.field_70161_v, new ItemStack(BetterBarrels.itemFoldedMover, 1));
            newItem.field_145804_b = 0;
            world.func_72838_d((Entity)newItem);
            --itemStack.field_77994_a;
        }
        return itemStack;
    }

    protected boolean placeContainer(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side) {
        NBTTagCompound nbtStack = stack.func_77978_p();
        NBTTagCompound nbtContainerStack = nbtStack.func_74775_l("Container");
        Block storedBlock = nbtContainerStack.func_74764_b("ID") ? Block.func_149729_e((int)nbtContainerStack.func_74762_e("ID")) : Block.func_149684_b((String)nbtContainerStack.func_74779_i("Block"));
        int blockMeta = nbtContainerStack.func_74762_e("Meta");
        String TEClassName = nbtContainerStack.func_74779_i("TEClass");
        NBTTagCompound nbtContainer = nbtStack.func_74775_l("Container").func_74775_l("NBT");
        ForgeDirection targSide = ForgeDirection.getOrientation((int)side);
        int targX = x;
        int targY = y;
        int targZ = z;
        Block targetBlock = world.func_147439_a(targX, targY, targZ);
        if (targetBlock == Blocks.field_150433_aE) {
            targSide = ForgeDirection.UP;
        }
        if (!(targetBlock == Blocks.field_150395_bd || targetBlock == Blocks.field_150329_H || targetBlock == Blocks.field_150330_I || targetBlock != null && targetBlock.isReplaceable((IBlockAccess)world, targX, targY, targZ))) {
            if (targSide.equals((Object)ForgeDirection.NORTH)) {
                --targZ;
            }
            if (targSide.equals((Object)ForgeDirection.SOUTH)) {
                ++targZ;
            }
            if (targSide.equals((Object)ForgeDirection.WEST)) {
                --targX;
            }
            if (targSide.equals((Object)ForgeDirection.EAST)) {
                ++targX;
            }
            if (targSide.equals((Object)ForgeDirection.UP)) {
                ++targY;
            }
            if (targSide.equals((Object)ForgeDirection.DOWN)) {
                --targY;
            }
        }
        if (!world.func_147472_a(storedBlock, targX, targY, targZ, false, side, (Entity)null, stack)) {
            return false;
        }
        nbtContainer.func_74768_a("x", targX);
        nbtContainer.func_74768_a("y", targY);
        nbtContainer.func_74768_a("z", targZ);
        if (TEClassName.contains("net.minecraft.tileentity.TileEntityChest")) {
            blockMeta = this.getBarrelOrientationOnPlacement(player).ordinal();
        } else if (TEClassName.contains("appeng.tile.storage.TileSkyChest") && nbtContainer.func_74764_b("orientation_forward")) {
            nbtContainer.func_74778_a("orientation_forward", this.getBarrelOrientationOnPlacement(player).toString());
        } else if (TEClassName.contains("buildcraft.energy.TileEngine") && nbtContainer.func_74764_b("orientation")) {
            nbtContainer.func_74768_a("orientation", 1);
        } else if (TEClassName.contains("mods.railcraft.common.blocks.machine.beta") && nbtContainer.func_74764_b("direction")) {
            nbtContainer.func_74774_a("direction", (byte)1);
        } else if (TEClassName.contains("forestry.energy.gadgets") && nbtContainer.func_74764_b("Orientation")) {
            nbtContainer.func_74768_a("Orientation", 1);
        } else if ((TEClassName.contains("forestry.apiculture.tiles.TileApiaristChest") || TEClassName.contains("forestry.arboriculture.tiles.TileArboristChest") || TEClassName.contains("forestry.lepidopterology.tiles.TileLepidopteristChest") || TEClassName.contains("forestry.factory.tiles.TileWorktable")) && nbtContainer.func_74764_b("Orientation")) {
            nbtContainer.func_74768_a("Orientation", this.getBarrelOrientationOnPlacement(player).ordinal());
        } else if (TEClassName.contains("bluedart.tile.TileEntityForceEngine") && nbtContainer.func_74764_b("facing")) {
            nbtContainer.func_74774_a("facing", (byte)1);
        } else if (TEClassName.contains("thermalexpansion.block.engine") && nbtContainer.func_74764_b("side.facing")) {
            nbtContainer.func_74774_a("side.facing", (byte)1);
        } else if (TEClassName.contains("cpw.mods.ironchest") && nbtContainer.func_74764_b("facing")) {
            nbtContainer.func_74774_a("facing", (byte)this.getBarrelOrientationOnPlacement(player).ordinal());
        } else if (TEClassName.contains("ic2.core.block") && nbtContainer.func_74764_b("facing")) {
            nbtContainer.func_74777_a("facing", (short)6);
        } else if (TEClassName.contains("gregtechmod") && nbtContainer.func_74764_b("mFacing")) {
            nbtContainer.func_74777_a("mFacing", (short)this.getBarrelOrientationOnPlacement(player).ordinal());
        } else if (TEClassName.contains("dmillerw.cchests.block.tile") && nbtContainer.func_74764_b("orientation")) {
            nbtContainer.func_74774_a("orientation", (byte)this.getBarrelOrientationOnPlacement(player).ordinal());
        } else if (TEClassName.contains("net.mcft.copy.betterstorage.block.tileentity") && nbtContainer.func_74764_b("orientation")) {
            nbtContainer.func_74774_a("orientation", (byte)this.getBarrelOrientationOnPlacement(player).ordinal());
        } else if (TEClassName.contains("jds.bibliocraft.tileentities")) {
            this.orientBibliocraftTileToPlayer(nbtContainer, "bookcaseAngle", player);
            this.orientBibliocraftTileToPlayer(nbtContainer, "potionshelfAngle", player);
            this.orientBibliocraftTileToPlayer(nbtContainer, "rackAngle", player);
            this.orientBibliocraftTileToPlayer(nbtContainer, "genericShelfAngle", player);
            this.orientBibliocraftTileToPlayer(nbtContainer, "labelAngle", player);
        } else if (TEClassName.contains("jds.bibliocraft.tileentities.TileEntityArmorStand")) {
            blockMeta = this.fromForgeToBiblio(this.getBarrelOrientationOnPlacement(player));
        } else if (TEClassName.contains("com.rwtema.extrautils.tileentity.chests.TileFullChest")) {
            blockMeta = this.fromForgeToBiblio(this.getBarrelOrientationOnPlacement(player)) == 3 ? 0 : this.fromForgeToBiblio(this.getBarrelOrientationOnPlacement(player)) + 1;
        } else if (TEClassName.contains("team.chisel.block.tileentity.TileEntityPresent") && nbtContainer.func_74764_b("rotation")) {
            nbtContainer.func_74768_a("rotation", (int)((byte)this.getBarrelOrientationOnPlacement(player).ordinal()));
        } else if (TEClassName.contains("com.jaquadro.minecraft.storagedrawers.block.tile") && nbtContainer.func_74764_b("Dir")) {
            nbtContainer.func_74768_a("Dir", (int)((short)this.getBarrelOrientationOnPlacement(player).ordinal()));
        } else if (TEClassName.contains("com.bluepowermod.tile") && nbtContainer.func_74764_b("rotation")) {
            try {
                Class<?> blockClazz = storedBlock.getClass();
                Method allowVertical = null;
                while (allowVertical == null && !blockClazz.equals(Object.class)) {
                    try {
                        allowVertical = blockClazz.getDeclaredMethod("canRotateVertical", new Class[0]);
                    }
                    catch (NoSuchMethodException e) {
                        blockClazz = blockClazz.getSuperclass();
                    }
                }
                allowVertical.setAccessible(true);
                boolean vertAllowed = (Boolean)allowVertical.invoke((Object)storedBlock, (Object[])null);
                nbtContainer.func_74768_a("rotation", (int)((short)Utils.getDirectionFacingEntity((EntityLivingBase)player, vertAllowed).ordinal()));
            }
            catch (Exception e) {
                BetterBarrels.log.warn("Unable to rotate BluePower machine. place machine will not be rotated to be facing player.");
            }
        } else if (TEClassName.contains("thermalexpansion.block.machine") && nbtContainer.func_74764_b("side.facing")) {
            ForgeDirection new_facing = this.getBarrelOrientationOnPlacement(player);
            byte[] side_array_old = nbtContainer.func_74770_j("side.array");
            byte[] side_array_new = (byte[])side_array_old.clone();
            int rotations = 0;
            for (ForgeDirection side_facing = ForgeDirection.getOrientation((int)nbtContainer.func_74771_c("side.facing")); side_facing != new_facing; side_facing = side_facing.getRotation(ForgeDirection.UP)) {
                ++rotations;
            }
            for (int i = 2; i < 6; ++i) {
                ForgeDirection new_direction = ForgeDirection.getOrientation((int)i);
                for (int j = 0; j < rotations; ++j) {
                    new_direction = new_direction.getRotation(ForgeDirection.DOWN);
                }
                side_array_new[i] = side_array_old[new_direction.ordinal()];
            }
            nbtContainer.func_74773_a("side.array", side_array_new);
            nbtContainer.func_74774_a("side.facing", (byte)new_facing.ordinal());
        } else if (TEClassName.contains("ganymedes01.etfuturum.tileentities.TileEntityBarrel")) {
            blockMeta = this.getBarrelOrientationOnPlacement(player).ordinal();
        } else if (!TEClassName.contains("ganymedes01.etfuturum.tileentities.TileEntityBarrel") && nbtContainer.func_74779_i("id").equals("TileEntityBarrel")) {
            int i;
            ForgeDirection newBarrelRotation = Utils.getDirectionFacingEntity((EntityLivingBase)player, false);
            ForgeDirection oldBarrelRotation = ForgeDirection.getOrientation((int)nbtContainer.func_74762_e("rotation"));
            ForgeDirection newBarrelOrientation = Utils.getDirectionFacingEntity((EntityLivingBase)player, BetterBarrels.allowVerticalPlacement);
            ForgeDirection oldBarrelOrientation = ForgeDirection.getOrientation((int)nbtContainer.func_74762_e("orientation"));
            int[] newSideArray = new int[6];
            int[] oldSideArray = nbtContainer.func_74759_k("sideUpgrades");
            int[] newSideMetaArray = new int[6];
            int[] oldSideMetaArray = nbtContainer.func_74759_k("sideMeta");
            if (oldBarrelRotation == ForgeDirection.UNKNOWN) {
                oldBarrelRotation = ForgeDirection.SOUTH;
            }
            if (oldBarrelOrientation == ForgeDirection.UNKNOWN) {
                oldBarrelOrientation = ForgeDirection.SOUTH;
            }
            if (oldBarrelOrientation == ForgeDirection.UP || oldBarrelOrientation == ForgeDirection.DOWN) {
                ForgeDirection rot = oldBarrelRotation.getRotation(oldBarrelOrientation);
                for (i = 0; i < 6; ++i) {
                    int j = ForgeDirection.getOrientation((int)i).getRotation(rot).ordinal();
                    newSideArray[j] = oldSideArray[i];
                    newSideMetaArray[j] = oldSideMetaArray[i];
                }
                oldBarrelOrientation = oldBarrelRotation;
                oldSideArray = (int[])newSideArray.clone();
                oldSideMetaArray = (int[])newSideMetaArray.clone();
            }
            int numberRotationsVAxis = 0;
            while (newBarrelRotation != oldBarrelRotation) {
                ++numberRotationsVAxis;
                oldBarrelRotation = oldBarrelRotation.getRotation(ForgeDirection.UP);
            }
            for (i = 0; i < 6; ++i) {
                ForgeDirection idir = ForgeDirection.getOrientation((int)i);
                for (int rot = 0; rot < numberRotationsVAxis; ++rot) {
                    idir = idir.getRotation(ForgeDirection.UP);
                }
                newSideArray[idir.ordinal()] = oldSideArray[i];
                newSideMetaArray[idir.ordinal()] = oldSideMetaArray[i];
            }
            if (newBarrelOrientation == ForgeDirection.UP || newBarrelOrientation == ForgeDirection.DOWN) {
                oldSideArray = (int[])newSideArray.clone();
                oldSideMetaArray = (int[])newSideMetaArray.clone();
                ForgeDirection rot = newBarrelRotation.getRotation(newBarrelOrientation.getOpposite());
                for (int i2 = 0; i2 < 6; ++i2) {
                    int j = ForgeDirection.getOrientation((int)i2).getRotation(rot).ordinal();
                    newSideArray[j] = oldSideArray[i2];
                    newSideMetaArray[j] = oldSideMetaArray[i2];
                }
            }
            nbtContainer.func_74768_a("orientation", newBarrelOrientation.ordinal());
            nbtContainer.func_74768_a("rotation", newBarrelRotation.ordinal());
            nbtContainer.func_74783_a("sideUpgrades", newSideArray);
            nbtContainer.func_74783_a("sideMeta", newSideMetaArray);
        }
        world.func_147465_d(targX, targY, targZ, storedBlock, blockMeta, 3);
        TileEntity entity = world.func_147438_o(targX, targY, targZ);
        entity.func_145839_a(nbtContainer);
        if (classMap.get("ic2.api.tile.IWrenchable") != null && classMap.get("ic2.api.tile.IWrenchable").isInstance(entity)) {
            this.fixIC2Orientation(entity, player, targY);
        }
        if (TEClassName.contains("net.minecraft.tileentity.TileEntityChest")) {
            world.func_72921_c(targX, targY, targZ, blockMeta, 3);
        } else if (TEClassName.contains("forestry.factory.tiles.TileWorktable")) {
            RecipeMemory recipeMemory = ((TileWorktable)entity).getMemory();
            for (int i = 0; i < 9; ++i) {
                MemorizedRecipe recipe = recipeMemory.getRecipe(i);
                if (recipe == null) continue;
                recipe.calculateRecipeOutput(world);
            }
        }
        stack.func_77978_p().func_82580_o("Container");
        world.func_147471_g(targX, targY, targZ);
        return true;
    }

    private void orientBibliocraftTileToPlayer(NBTTagCompound nbtContainer, String angleKey, EntityPlayer player) {
        if (nbtContainer.func_74764_b(angleKey)) {
            nbtContainer.func_74768_a(angleKey, (int)this.fromForgeToBiblio(this.getBarrelOrientationOnPlacement(player)));
        }
    }

    private void fixIC2Orientation(TileEntity entity, EntityPlayer player, int targY) {
        try {
            Method setFacing = classMap.get("ic2.api.tile.IWrenchable").getMethod("setFacing", Short.TYPE);
            Method wrenchCanSetFacing = classMap.get("ic2.api.tile.IWrenchable").getMethod("wrenchCanSetFacing", EntityPlayer.class, Integer.TYPE);
            if (((Boolean)wrenchCanSetFacing.invoke((Object)entity, player, (short)this.getBarrelOrientationOnPlacement(player, targY, true).ordinal())).booleanValue()) {
                setFacing.invoke((Object)entity, (short)this.getBarrelOrientationOnPlacement(player, targY, true).ordinal());
            } else {
                setFacing.invoke((Object)entity, (short)this.getBarrelOrientationOnPlacement(player, targY, false).ordinal());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean isTEMovable(TileEntity te) {
        if (ItemBarrelMover.tileIsASpawner(te)) {
            return this.canPickSpawners();
        }
        if (te instanceof TileEntityBarrel) {
            return true;
        }
        if (te instanceof TileEntityChest) {
            return true;
        }
        if (this.isTileBlacklisted(te.getClass())) {
            return false;
        }
        for (Class c : classExtensions) {
            if (c == null || !c.isInstance(te)) continue;
            return true;
        }
        return false;
    }

    private static boolean tileIsASpawner(TileEntity te) {
        for (Class<?> c : spawnerClasses) {
            if (c == null || !c.isInstance(te)) continue;
            return true;
        }
        return false;
    }

    private boolean isTileBlacklisted(Class clazz) {
        for (Class<? extends TileEntity> tileClass : BetterBarrels.BlacklistedTileEntityClasses) {
            if (clazz != tileClass) continue;
            return true;
        }
        return false;
    }

    private boolean pickupBetterStorageFix(TileEntity container) {
        Method disconnect;
        Object lock;
        Method getLock;
        if (classMap.get("net.mcft.copy.betterstorage.api.lock.ILockable") != null && classMap.get("net.mcft.copy.betterstorage.api.lock.ILockable").isInstance(container)) {
            try {
                getLock = classMap.get("net.mcft.copy.betterstorage.api.lock.ILockable").getDeclaredMethod("getLock", null);
                lock = getLock.invoke((Object)container, (Object[])null);
                if (lock != null) {
                    return false;
                }
            }
            catch (Exception e) {
                System.out.printf("%s \n", e);
                return false;
            }
        }
        if (classMap.get("net.mcft.copy.betterstorage.api.ILockable") != null && classMap.get("net.mcft.copy.betterstorage.api.ILockable").isInstance(container)) {
            try {
                getLock = classMap.get("net.mcft.copy.betterstorage.api.ILockable").getDeclaredMethod("getLock", null);
                lock = getLock.invoke((Object)container, (Object[])null);
                if (lock != null) {
                    return false;
                }
            }
            catch (Exception e) {
                System.out.printf("%s \n", e);
                return false;
            }
        }
        if (classMap.get("net.mcft.copy.betterstorage.tile.entity.TileEntityConnectable") != null && classMap.get("net.mcft.copy.betterstorage.tile.entity.TileEntityConnectable").isInstance(container)) {
            try {
                disconnect = classMap.get("net.mcft.copy.betterstorage.tile.entity.TileEntityConnectable").getDeclaredMethod("disconnect", null);
                disconnect.invoke((Object)container, (Object[])null);
            }
            catch (Exception e) {
                System.out.printf("%s \n", e);
                return false;
            }
        }
        if (classMap.get("net.mcft.copy.betterstorage.block.tileentity.TileEntityConnectable") != null && classMap.get("net.mcft.copy.betterstorage.block.tileentity.TileEntityConnectable").isInstance(container)) {
            try {
                disconnect = classMap.get("net.mcft.copy.betterstorage.block.tileentity.TileEntityConnectable").getDeclaredMethod("disconnect", null);
                disconnect.invoke((Object)container, (Object[])null);
            }
            catch (Exception e) {
                System.out.printf("%s \n", e);
                return false;
            }
        }
        return true;
    }

    protected boolean canPickSpawners() {
        return false;
    }

    protected boolean pickupContainer(ItemStack stack, EntityPlayer player, World world, int x, int y, int z) {
        TileEntity containerTE = world.func_147438_o(x, y, z);
        if (containerTE == null) {
            return false;
        }
        Block storedBlock = world.func_147439_a(x, y, z);
        int blockMeta = world.func_72805_g(x, y, z);
        NBTTagCompound nbtContainer = new NBTTagCompound();
        NBTTagCompound nbtTarget = new NBTTagCompound();
        if (!this.isTEMovable(containerTE)) {
            return false;
        }
        if (!this.pickupBetterStorageFix(containerTE)) {
            return false;
        }
        containerTE.func_145841_b(nbtContainer);
        nbtTarget.func_74778_a("Block", GameData.getBlockRegistry().func_148750_c((Object)storedBlock));
        nbtTarget.func_74768_a("Meta", blockMeta);
        nbtTarget.func_74778_a("TEClass", containerTE.getClass().getName());
        nbtTarget.func_74757_a("isSpawner", ItemBarrelMover.tileIsASpawner(containerTE));
        nbtTarget.func_74782_a("NBT", (NBTBase)nbtContainer);
        if (this.tagCompoundWrite != null) {
            ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
            try {
                DataOutputStream outStream = new DataOutputStream(byteStream);
                this.tagCompoundWrite.invoke((Object)nbtTarget, outStream);
                outStream.close();
                if (byteStream.toByteArray().length > 0x100000) {
                    BarrelPacketHandler.sendLocalizedChat(player, LocalizedChat.DOLLY_TOO_COMPLEX, new Object[0]);
                    return false;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        } else if (stack.func_77978_p().func_74764_b("Container")) {
            stack.func_77978_p().func_82580_o("Container");
        }
        stack.func_77978_p().func_74782_a("Container", (NBTBase)nbtTarget);
        try {
            if (containerTE instanceof TileEntityChest) {
                ((TileEntityChest)containerTE).func_70305_f();
            }
            world.func_147475_p(x, y, z);
            world.func_147465_d(x, y, z, Blocks.field_150350_a, 0, 3);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int par4, boolean par5) {
        if (world.field_72995_K) {
            return;
        }
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("Container") && entity instanceof EntityPlayer) {
            int amplifier = 1;
            if (stack.func_77978_p().func_74764_b("amount")) {
                amplifier = Math.min(4, stack.func_77978_p().func_74762_e("amount") / 2048);
            }
            ((EntityPlayer)entity).func_70690_d(new PotionEffect(Potion.field_76419_f.field_76415_H, 10, amplifier));
            ((EntityPlayer)entity).func_70690_d(new PotionEffect(Potion.field_76421_d.field_76415_H, 10, amplifier));
        }
    }

    public void func_77624_a(ItemStack itemStack, EntityPlayer player, List tooltip, boolean p_77624_4_) {
        super.func_77624_a(itemStack, player, tooltip, p_77624_4_);
        if (!(this.type != DollyType.NORMAL || BetterBarrels.disableDollyStacking || itemStack.func_77942_o() && itemStack.func_77978_p().func_74764_b("Container"))) {
            tooltip.add(StatCollector.func_74838_a((String)"item.dolly.folding_hint.1"));
            tooltip.add(StatCollector.func_74838_a((String)"item.dolly.folding_hint.2"));
        }
    }

    private ForgeDirection getBarrelOrientationOnPlacement(EntityPlayer player) {
        return this.getBarrelOrientationOnPlacement(player, 0, false);
    }

    private ForgeDirection getBarrelOrientationOnPlacement(EntityPlayer player, int targY, boolean allowVertical) {
        ForgeDirection barrelOrientation = ForgeDirection.UNKNOWN;
        Vec3 playerLook = player.func_70040_Z();
        barrelOrientation = Math.abs(playerLook.field_72450_a) >= Math.abs(playerLook.field_72449_c) ? (playerLook.field_72450_a > 0.0 ? ForgeDirection.WEST : ForgeDirection.EAST) : (playerLook.field_72449_c > 0.0 ? ForgeDirection.NORTH : ForgeDirection.SOUTH);
        if (allowVertical && player.field_70163_u > (double)targY) {
            barrelOrientation = ForgeDirection.UP;
        } else if (allowVertical && playerLook.field_72448_b > 0.73) {
            barrelOrientation = ForgeDirection.DOWN;
        }
        return barrelOrientation;
    }

    private ArrayList<ForgeDirection> convertOrientationFlagToForge(int flags) {
        ArrayList<ForgeDirection> directions = new ArrayList<ForgeDirection>();
        for (int i = 0; i < 4; ++i) {
            if ((1 << i & flags) == 0) continue;
            directions.add(ForgeDirection.getOrientation((int)(i + 2)));
        }
        return directions;
    }

    private int convertForgeToOrientationFlag(ArrayList<ForgeDirection> directions) {
        int flags = 0;
        for (ForgeDirection direction : directions) {
            flags += 1 << direction.ordinal() - 2;
        }
        return flags;
    }

    private String getBlockName(TileEntity tileEntity) {
        Block teBlock = tileEntity.func_145831_w().func_147439_a(tileEntity.field_145851_c, tileEntity.field_145848_d, tileEntity.field_145849_e);
        ItemStack pick = null;
        try {
            pick = teBlock.getPickBlock(null, tileEntity.func_145831_w(), tileEntity.field_145851_c, tileEntity.field_145848_d, tileEntity.field_145849_e);
            if (pick != null) {
                return pick.func_82833_r();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return "<Unknown>";
    }

    private ForgeDirection fromMCToForge(short side) {
        switch (side) {
            case 0: {
                return ForgeDirection.DOWN;
            }
            case 1: {
                return ForgeDirection.UP;
            }
            case 2: {
                return ForgeDirection.EAST;
            }
            case 3: {
                return ForgeDirection.WEST;
            }
            case 4: {
                return ForgeDirection.NORTH;
            }
            case 5: {
                return ForgeDirection.SOUTH;
            }
        }
        return ForgeDirection.UNKNOWN;
    }

    private short fromForgeToMC(ForgeDirection side) {
        switch (side) {
            case DOWN: {
                return 0;
            }
            case UP: {
                return 1;
            }
            case EAST: {
                return 2;
            }
            case WEST: {
                return 3;
            }
            case NORTH: {
                return 4;
            }
            case SOUTH: {
                return 5;
            }
            case UNKNOWN: {
                return -1;
            }
        }
        return -1;
    }

    private short fromForgeToBiblio(ForgeDirection side) {
        switch (side) {
            case EAST: {
                return 2;
            }
            case WEST: {
                return 0;
            }
            case NORTH: {
                return 1;
            }
            case SOUTH: {
                return 3;
            }
        }
        return -1;
    }

    static {
        classExtensionsNames.add("appeng.tile.storage.TileSkyChest");
        classExtensionsNames.add("cpw.mods.ironchest.TileEntityIronChest");
        classExtensionsNames.add("buildcraft.energy.TileEngine");
        classExtensionsNames.add("buildcraft.factory.TileTank");
        classExtensionsNames.add("ic2.api.tile.IWrenchable");
        classExtensionsNames.add("mods.railcraft.common.blocks.machine.beta.TileEngine");
        classExtensionsNames.add("forestry.core.gadgets.Engine");
        classExtensionsNames.add("forestry.apiculture.tiles.TileApiaristChest");
        classExtensionsNames.add("forestry.arboriculture.tiles.TileArboristChest");
        classExtensionsNames.add("forestry.lepidopterology.tiles.TileLepidopteristChest");
        classExtensionsNames.add("forestry.factory.tiles.TileWorktable");
        classExtensionsNames.add("bluedart.tile.TileEntityForceEngine");
        classExtensionsNames.add("thermalexpansion.block.engine.TileEngineRoot");
        classExtensionsNames.add("thermalexpansion.block.machine.TileMachineRoot");
        classExtensionsNames.add("dmillerw.cchests.block.tile.TileChest");
        classExtensionsNames.add("net.mcft.copy.betterstorage.block.tileentity.TileEntityReinforcedChest");
        classExtensionsNames.add("net.mcft.copy.betterstorage.block.tileentity.TileEntityLocker");
        classExtensionsNames.add("net.mcft.copy.betterstorage.block.tileentity.TileEntityCardboardBox");
        classExtensionsNames.add("net.mcft.copy.betterstorage.tile.entity.TileEntityConnectable");
        classExtensionsNames.add("net.mcft.copy.betterstorage.block.tileentity.TileEntityConnectable");
        classExtensionsNames.add("net.mcft.copy.betterstorage.api.lock.ILockable");
        classExtensionsNames.add("net.mcft.copy.betterstorage.api.ILockable");
        classExtensionsNames.add("jds.bibliocraft.tileentities.TileEntityBookcase");
        classExtensionsNames.add("jds.bibliocraft.tileentities.TileEntityPotionShelf");
        classExtensionsNames.add("jds.bibliocraft.tileentities.TileEntityWeaponRack");
        classExtensionsNames.add("jds.bibliocraft.tileentities.TileEntityGenericShelf");
        classExtensionsNames.add("jds.bibliocraft.tileentities.TileEntityArmorStand");
        classExtensionsNames.add("jds.bibliocraft.tileentities.TileEntityLabel");
        classExtensionsNames.add("com.jaquadro.minecraft.storagedrawers.block.tile.TileEntityDrawers");
        classExtensionsNames.add("com.jaquadro.minecraft.storagedrawers.block.tile.TileEntityCompDrawers");
        classExtensionsNames.add("com.bluepowermod.tile.TileBase");
        classExtensionsNames.add("com.rwtema.extrautils.tileentity.chests.TileFullChest");
        classExtensionsNames.add("team.chisel.block.tileentity.TileEntityPresent");
        classExtensionsNames.add("ganymedes01.etfuturum.tileentities.TileEntityBarrel");
        for (String s : classExtensionsNames) {
            try {
                classExtensions.add(Class.forName(s));
                classMap.put(s, Class.forName(s));
            }
            catch (ClassNotFoundException e) {
                classExtensions.add(null);
            }
        }
        spawnerClassExtensionsNames.add("chylex.hee.tileentity.TileEntityCustomSpawner");
        spawnerClasses.add(TileEntityMobSpawner.class);
        for (String s : spawnerClassExtensionsNames) {
            try {
                spawnerClasses.add(Class.forName(s));
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
    }

    protected static enum DollyType {
        NORMAL,
        DIAMOND;

    }
}

