/*
 * Decompiled with CFR 0.152.
 */
package serverutils.integration.navigator;

import com.gtnewhorizons.navigator.api.NavigatorApi;
import com.gtnewhorizons.navigator.api.model.locations.IWaypointAndLocationProvider;
import com.gtnewhorizons.navigator.api.model.waypoints.Waypoint;
import com.gtnewhorizons.navigator.api.util.Util;
import java.util.Collections;
import java.util.Set;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.ChunkCoordIntPair;
import org.lwjgl.input.Keyboard;
import serverutils.client.gui.ClientClaimedChunks;
import serverutils.lib.EnumTeamColor;
import serverutils.net.MessageClaimedChunksModify;
import serverutils.net.MessageNavigatorRequest;

public class ClaimsLocation
implements IWaypointAndLocationProvider {
    private final int blockX;
    private final int blockZ;
    private final int dimensionId;
    private final ClientClaimedChunks.ChunkData chunkData;

    public ClaimsLocation(int chunkX, int chunkZ, int dim, ClientClaimedChunks.ChunkData data) {
        this.blockX = Util.coordChunkToBlock((int)chunkX);
        this.blockZ = Util.coordChunkToBlock((int)chunkZ);
        this.dimensionId = dim;
        this.chunkData = data;
    }

    public double getBlockX() {
        return (double)this.blockX + 0.5;
    }

    public double getBlockZ() {
        return (double)this.blockZ + 0.5;
    }

    public int getDimensionId() {
        return this.dimensionId;
    }

    public String getTeamName() {
        return this.getTeamColor().getEnumChatFormatting() + this.getTeam().nameComponent.func_150260_c();
    }

    public EnumTeamColor getTeamColor() {
        return this.getTeam().color;
    }

    public boolean isOwnTeam() {
        return this.getTeam().isMember;
    }

    public boolean isAlly() {
        return this.getTeam().isAlly;
    }

    public ClientClaimedChunks.Team getTeam() {
        return this.chunkData.team;
    }

    public boolean isLoaded() {
        return this.chunkData.isLoaded();
    }

    public String loadedHint() {
        return this.isLoaded() ? EnumChatFormatting.GREEN + I18n.func_135052_a((String)"serverutilities.lang.chunks.chunk_loaded", (Object[])new Object[0]) : "";
    }

    public String teamHint() {
        if (this.isOwnTeam()) {
            return EnumChatFormatting.DARK_AQUA + I18n.func_135052_a((String)"serverutilities.jm.own_team", (Object[])new Object[0]);
        }
        if (this.isAlly()) {
            return EnumChatFormatting.YELLOW + I18n.func_135052_a((String)"serverutilities.lang.team_status.ally", (Object[])new Object[0]);
        }
        return "";
    }

    public String claimHint() {
        return EnumChatFormatting.DARK_GRAY + I18n.func_135052_a((String)"serverutilities.jm.claim", (Object[])new Object[0]);
    }

    public String toggleLoadHint() {
        return EnumChatFormatting.DARK_GRAY + I18n.func_135052_a((String)"serverutilities.jm.load_hint", (Object[])new Object[0]);
    }

    public String unclaimHint() {
        return EnumChatFormatting.DARK_GRAY + I18n.func_135052_a((String)"serverutilities.jm.unclaim_hint", (Object[])new Object[]{Keyboard.getKeyName((int)NavigatorApi.ACTION_KEY.func_151463_i())});
    }

    public void toggleLoaded() {
        int selectionMode = this.isLoaded() ? 3 : 2;
        int chunkX = this.getChunkX();
        int chunkZ = this.getChunkZ();
        Set<ChunkCoordIntPair> chunks = Collections.singleton(new ChunkCoordIntPair(chunkX, chunkZ));
        new MessageClaimedChunksModify(chunkX, chunkZ, selectionMode, chunks).sendToServer();
        new MessageNavigatorRequest(chunkX, chunkX, chunkZ, chunkZ).sendToServer();
        this.chunkData.setLoaded(!this.isLoaded());
    }

    public Waypoint toWaypoint() {
        this.toggleLoaded();
        return null;
    }

    public boolean isActiveAsWaypoint() {
        return false;
    }

    public void onWaypointCleared() {
    }

    public void onWaypointUpdated(Waypoint waypoint) {
    }
}

