/*
 * Decompiled with CFR 0.152.
 */
package serverutils.command.team;

import java.util.List;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import serverutils.ServerUtilities;
import serverutils.lib.command.CmdBase;
import serverutils.lib.data.ForgePlayer;
import serverutils.lib.data.ForgeTeam;
import serverutils.lib.data.Universe;
import serverutils.lib.util.StringUtils;

public class CmdInfo
extends CmdBase {
    public CmdInfo() {
        super("info", CmdBase.Level.ALL);
    }

    @Override
    public List<String> func_71516_a(ICommandSender sender, String[] args) {
        if (args.length == 1) {
            return CmdInfo.matchFromIterable(args, Universe.get().getTeams());
        }
        return super.func_71516_a(sender, args);
    }

    public void func_71515_b(ICommandSender sender, String[] args) throws CommandException {
        this.checkArgs(sender, args, 1);
        ForgeTeam team = Universe.get().getTeam(args[0]);
        if (!team.isValid()) {
            throw ServerUtilities.error(sender, "serverutilities.lang.team.error.not_found", args[0]);
        }
        sender.func_145747_a(ServerUtilities.lang(sender, "commands.team.info.id", StringUtils.color((IChatComponent)new ChatComponentText(team.getId()), EnumChatFormatting.BLUE)));
        sender.func_145747_a(ServerUtilities.lang(sender, "commands.team.info.uid", StringUtils.color((IChatComponent)new ChatComponentText(team.getUID() + " / " + String.format("%04x", team.getUID())), EnumChatFormatting.BLUE)));
        sender.func_145747_a(ServerUtilities.lang(sender, "commands.team.info.owner", team.getOwner() == null ? "-" : StringUtils.color(team.getOwner().getDisplayName(), EnumChatFormatting.BLUE)));
        ChatComponentText component = new ChatComponentText("");
        component.func_150256_b().func_150238_a(EnumChatFormatting.GOLD);
        boolean first = true;
        for (ForgePlayer player : team.getMembers()) {
            if (first) {
                first = false;
            } else {
                component.func_150258_a(", ");
            }
            IChatComponent n = player.getDisplayName();
            n.func_150256_b().func_150238_a(EnumChatFormatting.BLUE);
            component.func_150257_a(n);
        }
        sender.func_145747_a(ServerUtilities.lang(sender, "commands.team.info.members", component));
    }
}

