/*
 * Decompiled with CFR 0.152.
 */
package serverutils.command.pregen;

import java.io.IOException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import serverutils.lib.command.CmdBase;
import serverutils.lib.command.ICommandWithParent;
import serverutils.lib.util.misc.PregeneratorCommandInfo;
import serverutils.pregenerator.ChunkLoaderManager;

public class CmdStart
extends CmdBase {
    public CmdStart() {
        super("start", CmdBase.Level.OP);
    }

    public void func_71515_b(ICommandSender sender, String[] args) {
        int radius;
        double zLoc;
        double xLoc;
        this.checkArgs(sender, args, 1);
        if (args.length == 3) {
            xLoc = CmdStart.func_110661_a((ICommandSender)sender, (String)args[0], (double)-3.0E7, (double)3.0E7);
            zLoc = CmdStart.func_110661_a((ICommandSender)sender, (String)args[1], (double)-3.0E7, (double)3.0E7);
            radius = CmdStart.func_71526_a((ICommandSender)sender, (String)args[2]);
            if (radius > 2000) {
                sender.func_145747_a((IChatComponent)new ChatComponentText("Radii larger than 2000 are not permitted. World sizes will be 100's of gbs"));
                return;
            }
        } else {
            xLoc = sender.func_82114_b().field_71574_a;
            zLoc = sender.func_82114_b().field_71573_c;
            radius = CmdStart.func_71526_a((ICommandSender)sender, (String)args[0]);
            if (radius > 2000) {
                sender.func_145747_a((IChatComponent)new ChatComponentText("Radii larger than 2000 are not permitted. World sizes will be 100's of gbs"));
                return;
            }
        }
        int dimensionID = sender.func_130014_f_().field_73011_w.field_76574_g;
        PregeneratorCommandInfo commandInfo = new PregeneratorCommandInfo(xLoc, zLoc, radius, dimensionID);
        if (!ChunkLoaderManager.instance.isGenerating()) {
            try {
                sender.func_145747_a((IChatComponent)new ChatComponentText("Initializing pregenerator. Check progress with '/pregen progress'."));
                ChunkLoaderManager.instance.initializePregenerator(commandInfo, MinecraftServer.func_71276_C());
            }
            catch (IOException e) {
                e.printStackTrace();
                sender.func_145747_a((IChatComponent)new ChatComponentText("Cannot start a pregenerator! File exception when starting pregenerator!"));
            }
        } else {
            sender.func_145747_a((IChatComponent)new ChatComponentText("Cannot start a pregenerator! There's already generation in progress!"));
        }
    }

    @Override
    public void checkArgs(ICommandSender sender, String[] args, int i) {
        if (args.length < i) {
            throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
        }
        if (sender instanceof MinecraftServer ? args.length != 3 : args.length != 1 && args.length != 3) {
            throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
        }
    }

    @Override
    public String func_71518_a(ICommandSender sender) {
        if (sender instanceof MinecraftServer) {
            return "commands." + ICommandWithParent.getCommandPath(this) + ".usage_server";
        }
        return "commands." + ICommandWithParent.getCommandPath(this) + ".usage_client";
    }
}

