/*
 * Decompiled with CFR 0.152.
 */
package appeng.items.contents;

import appeng.api.config.PinsState;
import appeng.api.storage.data.IAEItemStack;
import appeng.core.AELog;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.PacketPinsUpdate;
import appeng.items.contents.PinsHolder;
import appeng.tile.inventory.AppEngInternalAEInventory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;

public class PinsHandler {
    private final PinsHolder holder;
    private final AppEngInternalAEInventory pinsInv;
    private PinsState pinsState;
    private final EntityPlayer player;
    private boolean needUpdate = true;
    IAEItemStack[] cache = new IAEItemStack[0];

    public PinsHandler(PinsHolder holder, EntityPlayer player) {
        this.holder = holder;
        this.pinsInv = this.holder.getPinsInv(player);
        this.player = player;
        this.setPinsState(this.holder.getPinsState(player));
    }

    public void setPin(int idx, ItemStack stack) {
        if (stack != null) {
            stack = stack.func_77946_l();
            stack.field_77994_a = 0;
            for (int i = 0; i < this.pinsInv.func_70302_i_(); ++i) {
                if (this.pinsInv.getAEStackInSlot(i) == null || !this.pinsInv.getAEStackInSlot(i).isSameType(stack)) continue;
                this.pinsInv.func_70299_a(i, this.pinsInv.func_70301_a(idx));
                break;
            }
        }
        this.pinsInv.func_70299_a(idx, stack);
        this.needUpdate = true;
        this.holder.markDirty();
    }

    public ItemStack getPin(int idx) {
        return this.pinsInv.func_70301_a(idx);
    }

    public void addItemsToPins(Iterable<IAEItemStack> pinsList) {
        Iterator<IAEItemStack> it = pinsList.iterator();
        ArrayList<IAEItemStack> checkCache = new ArrayList<IAEItemStack>();
        for (int i = 0; i < this.pinsInv.func_70302_i_(); ++i) {
            IAEItemStack ais = this.pinsInv.getAEStackInSlot(i);
            if (ais == null) continue;
            checkCache.add(ais);
        }
        ItemStack itemStack = null;
        for (int i = 0; i < this.pinsInv.func_70302_i_(); ++i) {
            while (itemStack == null && it.hasNext()) {
                IAEItemStack AEis = it.next();
                if (AEis == null || checkCache.contains(AEis)) continue;
                itemStack = AEis.getItemStack();
                itemStack.field_77994_a = 0;
                break;
            }
            if (itemStack == null) break;
            if (this.pinsInv.getAEStackInSlot(i) != null) continue;
            this.pinsInv.func_70299_a(i, itemStack);
            itemStack = null;
        }
        this.needUpdate = true;
        this.holder.markDirty();
    }

    public void setPinsState(PinsState state) {
        if (this.pinsState == state) {
            return;
        }
        this.pinsState = state;
        this.holder.setPinsState(this.player, state);
        this.update(false);
    }

    public PinsState getPinsState() {
        return this.pinsState;
    }

    public IAEItemStack[] getEnabledPins() {
        if (this.needUpdate) {
            this.update();
        }
        return this.cache;
    }

    public EntityPlayer getPlayer() {
        return this.player;
    }

    public void update() {
        this.update(false);
    }

    public void update(boolean forceSendPacket) {
        this.needUpdate = false;
        Object[] newPins = new IAEItemStack[this.pinsState.ordinal() * 9];
        for (int i = 0; i < this.pinsState.ordinal() * 9; ++i) {
            newPins[i] = this.pinsInv.getAEStackInSlot(i);
        }
        if (!forceSendPacket && Arrays.equals(this.cache, newPins)) {
            return;
        }
        this.cache = newPins;
        EntityPlayer entityPlayer = this.player;
        if (entityPlayer instanceof EntityPlayerMP) {
            EntityPlayerMP mp = (EntityPlayerMP)entityPlayer;
            try {
                NetworkHandler.instance.sendTo(new PacketPinsUpdate((IAEItemStack[])newPins, this.pinsState), mp);
            }
            catch (IOException e) {
                AELog.debug(e);
            }
        }
    }
}

