/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.enchanter;

import crazypants.enderio.ModObject;
import crazypants.enderio.TileEntityEio;
import crazypants.enderio.config.Config;
import crazypants.enderio.machine.enchanter.EnchanterRecipe;
import crazypants.enderio.machine.enchanter.EnchanterRecipeManager;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEnchanter
extends TileEntityEio
implements ISidedInventory {
    private ItemStack[] inv = new ItemStack[3];
    private short facing = (short)ForgeDirection.NORTH.ordinal();

    public void setFacing(short s) {
        this.facing = s;
    }

    public short getFacing() {
        return this.facing;
    }

    protected void writeCustomNBT(NBTTagCompound root) {
        NBTTagList itemList = new NBTTagList();
        for (int i = 0; i < this.inv.length; ++i) {
            if (this.inv[i] == null) continue;
            NBTTagCompound itemStackNBT = new NBTTagCompound();
            itemStackNBT.func_74774_a("Slot", (byte)i);
            this.inv[i].func_77955_b(itemStackNBT);
            itemList.func_74742_a((NBTBase)itemStackNBT);
        }
        root.func_74782_a("Items", (NBTBase)itemList);
        root.func_74777_a("facing", this.facing);
    }

    protected void readCustomNBT(NBTTagCompound root) {
        NBTTagList itemList = (NBTTagList)root.func_74781_a("Items");
        if (itemList != null) {
            for (int i = 0; i < itemList.func_74745_c(); ++i) {
                NBTTagCompound itemStack = itemList.func_150305_b(i);
                byte slot = itemStack.func_74771_c("Slot");
                if (slot < 0 || slot >= this.inv.length) continue;
                this.inv[slot] = ItemStack.func_77949_a((NBTTagCompound)itemStack);
            }
        }
        this.facing = root.func_74765_d("facing");
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.canPlayerAccess(player);
    }

    public int func_70302_i_() {
        return this.inv.length;
    }

    public ItemStack func_70301_a(int slot) {
        if (slot < 0 || slot >= this.inv.length) {
            return null;
        }
        return this.inv[slot];
    }

    public ItemStack func_70298_a(int slot, int amount) {
        if (amount <= 0 || slot < 0 || slot >= this.inv.length || this.inv[slot] == null) {
            return null;
        }
        ItemStack fromStack = this.inv[slot];
        if (fromStack == null) {
            return null;
        }
        if (fromStack.field_77994_a <= amount) {
            this.inv[slot] = null;
            return fromStack;
        }
        ItemStack result = new ItemStack(fromStack.func_77973_b(), amount, fromStack.func_77960_j());
        if (fromStack.field_77990_d != null) {
            result.field_77990_d = (NBTTagCompound)fromStack.field_77990_d.func_74737_b();
        }
        fromStack.field_77994_a -= amount;
        return result;
    }

    public ItemStack func_70304_b(int p_70304_1_) {
        return null;
    }

    public void func_70299_a(int slot, ItemStack contents) {
        this.inv[slot] = contents == null ? contents : contents.func_77946_l();
        if (contents != null && contents.field_77994_a > this.func_70297_j_()) {
            contents.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_145825_b() {
        return ModObject.blockEnchanter.unlocalisedName;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        if (stack == null) {
            return false;
        }
        if (slot == 0) {
            return Items.field_151099_bA == stack.func_77973_b();
        }
        if (slot == 1) {
            return EnchanterRecipeManager.getInstance().getEnchantmentRecipeForInput(stack) != null;
        }
        return false;
    }

    public EnchanterRecipe getCurrentEnchantmentRecipe() {
        if (this.inv[0] == null) {
            return null;
        }
        if (this.inv[1] == null) {
            return null;
        }
        EnchanterRecipe ench = EnchanterRecipeManager.getInstance().getEnchantmentRecipeForInput(this.inv[1]);
        if (ench == null) {
            return null;
        }
        int level = ench.getLevelForStackSize(this.inv[1].field_77994_a);
        if (level <= 0) {
            return null;
        }
        return ench;
    }

    public EnchantmentData getCurrentEnchantmentData() {
        EnchanterRecipe rec = this.getCurrentEnchantmentRecipe();
        if (rec == null || this.inv[1] == null) {
            return null;
        }
        int level = rec.getLevelForStackSize(this.inv[1].field_77994_a);
        if (level <= 0) {
            return null;
        }
        return new EnchantmentData(rec.getEnchantment(), level);
    }

    public int getCurrentEnchantmentCost() {
        return this.getEnchantmentCost(this.getCurrentEnchantmentRecipe());
    }

    private int getEnchantmentCost(EnchanterRecipe currentEnchantment) {
        ItemStack item = this.inv[1];
        if (item == null) {
            return 0;
        }
        if (currentEnchantment == null) {
            return 0;
        }
        int level = currentEnchantment.getLevelForStackSize(item.field_77994_a);
        return TileEnchanter.getEnchantmentCost(currentEnchantment, level);
    }

    public static int getEnchantmentCost(EnchanterRecipe recipe, int level) {
        if (level > recipe.getEnchantment().func_77325_b()) {
            level = recipe.getEnchantment().func_77325_b();
        }
        int costPerLevel = recipe.getCostPerLevel();
        int res = Config.enchanterBaseLevelCost;
        for (int i = 0; i < level; ++i) {
            res += costPerLevel * level;
        }
        return res;
    }

    public void setOutput(ItemStack output) {
        this.inv[this.inv.length - 1] = output;
        this.func_70296_d();
    }

    public int[] func_94128_d(int p_94128_1_) {
        return new int[0];
    }

    public boolean func_102007_a(int p_102007_1_, ItemStack p_102007_2_, int p_102007_3_) {
        return false;
    }

    public boolean func_102008_b(int p_102008_1_, ItemStack p_102008_2_, int p_102008_3_) {
        return false;
    }
}

