/*
 * Decompiled with CFR 0.152.
 */
package com.recursive_pineapple.matter_manipulator.common.building.providers;

import appeng.api.AEApi;
import appeng.api.definitions.IItemDefinition;
import com.recursive_pineapple.matter_manipulator.common.building.IPseudoInventory;
import com.recursive_pineapple.matter_manipulator.common.building.providers.IItemProvider;
import com.recursive_pineapple.matter_manipulator.common.utils.BigItemStack;
import java.util.Arrays;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import org.jetbrains.annotations.Nullable;

public class PatternItemProvider
implements IItemProvider {
    private Integer amount;
    private NBTTagCompound pattern;
    private static final IItemDefinition BLANK_PATTERN = AEApi.instance().definitions().materials().blankPattern();
    private static final IItemDefinition PATTERN = AEApi.instance().definitions().items().encodedPattern();

    public static PatternItemProvider fromPattern(ItemStack stack) {
        if (!PATTERN.isSameAs(stack)) {
            return null;
        }
        PatternItemProvider pattern = new PatternItemProvider();
        pattern.amount = stack.field_77994_a != 1 ? Integer.valueOf(stack.field_77994_a) : null;
        pattern.pattern = stack.func_77978_p();
        return pattern;
    }

    @Override
    @Nullable
    public ItemStack getStack(IPseudoInventory inv, boolean consume) {
        ItemStack toConsume;
        ItemStack stack = (ItemStack)PATTERN.maybeStack(1).get();
        stack.field_77994_a = this.amount == null ? 1 : this.amount;
        stack.func_77982_d(this.pattern != null ? (NBTTagCompound)this.pattern.func_74737_b() : null);
        if (consume && !inv.tryConsumeItems(Arrays.asList(BigItemStack.create(stack)), 16).firstBoolean() && !inv.tryConsumeItems(toConsume = (ItemStack)BLANK_PATTERN.maybeStack(this.amount == null ? 1 : this.amount).get())) {
            return null;
        }
        return stack;
    }

    @Override
    public String describe() {
        return ((ItemStack)BLANK_PATTERN.maybeStack(1).get()).func_82833_r();
    }

    @Override
    public PatternItemProvider clone() {
        PatternItemProvider dup = new PatternItemProvider();
        dup.amount = this.amount;
        dup.pattern = (NBTTagCompound)this.pattern.func_74737_b();
        return dup;
    }
}

