/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.structures;

import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import twilightforest.TFTreasure;
import twilightforest.entity.TFCreatures;
import twilightforest.structures.StructureTFComponent;
import twilightforest.world.TFGenCaveStalactite;

public class ComponentTFHollowHill
extends StructureTFComponent {
    int hillSize;
    int radius;

    public ComponentTFHollowHill() {
    }

    public ComponentTFHollowHill(World world, Random rand, int i, int size, int x, int y, int z) {
        super(i);
        this.setCoordBaseMode(0);
        this.hillSize = size;
        this.radius = (this.hillSize * 2 + 1) * 8 - 6;
        this.field_74887_e = StructureTFComponent.getComponentToAddBoundingBox(x, y, z, -this.radius, -3, -this.radius, this.radius * 2, 10, this.radius * 2, 0);
    }

    @Override
    protected void func_143012_a(NBTTagCompound par1NBTTagCompound) {
        super.func_143012_a(par1NBTTagCompound);
        par1NBTTagCompound.func_74768_a("hillSize", this.hillSize);
    }

    @Override
    protected void func_143011_b(NBTTagCompound par1NBTTagCompound) {
        super.func_143011_b(par1NBTTagCompound);
        this.hillSize = par1NBTTagCompound.func_74762_e("hillSize");
        this.radius = (this.hillSize * 2 + 1) * 8 - 6;
    }

    public void func_74861_a(StructureComponent structurecomponent, List list, Random random) {
    }

    public boolean func_74875_a(World world, Random rand, StructureBoundingBox sbb) {
        int[] dest;
        int i;
        int[] sna = new int[]{0, 128, 256, 512};
        int sn = sna[this.hillSize];
        int[] mga = new int[]{0, 1, 4, 9};
        int mg = mga[this.hillSize];
        int[] tca = new int[]{0, 2, 6, 12};
        int tc = tca[this.hillSize];
        for (i = 0; i < mg; ++i) {
            dest = this.getCoordsInHill2D(rand);
            String mobID = this.getMobID(rand);
            this.placeSpawnerAtCurrentPosition(world, rand, dest[0], rand.nextInt(4), dest[1], mobID, sbb);
        }
        for (i = 0; i < tc; ++i) {
            dest = this.getCoordsInHill2D(rand);
            this.generateTreasureChest(world, dest[0], 0, dest[1], sbb);
        }
        for (i = 0; i < sn; ++i) {
            dest = this.getCoordsInHill2D(rand);
            this.generateOreStalactite(world, dest[0], 1, dest[1], sbb);
        }
        for (i = 0; i < sn; ++i) {
            dest = this.getCoordsInHill2D(rand);
            this.generateBlockStalactite(world, Blocks.field_150348_b, 1.0f, true, dest[0], 1, dest[1], sbb);
        }
        for (i = 0; i < sn; ++i) {
            dest = this.getCoordsInHill2D(rand);
            this.generateBlockStalactite(world, Blocks.field_150348_b, 0.9f, false, dest[0], 1, dest[1], sbb);
        }
        return true;
    }

    protected void generateTreasureChest(World world, int x, int y, int z, StructureBoundingBox sbb) {
        Random chestRNG = new Random(world.func_72905_C() + (long)(x * z));
        this.placeTreasureAtCurrentPosition(world, chestRNG, x, y, z, this.hillSize == 3 ? TFTreasure.hill3 : (this.hillSize == 2 ? TFTreasure.hill2 : TFTreasure.hill1), sbb);
        this.func_151554_b(world, Blocks.field_150347_e, 0, x, y - 1, z, sbb);
    }

    protected void generateOreStalactite(World world, int x, int y, int z, StructureBoundingBox sbb) {
        int dz;
        int dy;
        int dx = this.func_74865_a(x, z);
        if (sbb.func_78890_b(dx, dy = this.func_74862_a(y), dz = this.func_74873_b(x, z)) && world.func_147439_a(dx, dy, dz) != Blocks.field_150474_ac) {
            Random stalRNG = new Random(world.func_72905_C() + (long)(dx * dz));
            TFGenCaveStalactite stalag = TFGenCaveStalactite.makeRandomOreStalactite(stalRNG, this.hillSize);
            stalag.func_76484_a(world, stalRNG, dx, dy, dz);
        }
    }

    protected void generateBlockStalactite(World world, Block blockToGenerate, float length, boolean up, int x, int y, int z, StructureBoundingBox sbb) {
        int dz;
        int dy;
        int dx = this.func_74865_a(x, z);
        if (sbb.func_78890_b(dx, dy = this.func_74862_a(y), dz = this.func_74873_b(x, z)) && world.func_147439_a(dx, dy, dz) != Blocks.field_150474_ac) {
            Random stalRNG = new Random(world.func_72905_C() + (long)(dx * dz));
            if (this.hillSize == 1) {
                length *= 1.9f;
            }
            new TFGenCaveStalactite(blockToGenerate, length, up).func_76484_a(world, stalRNG, dx, dy, dz);
        }
    }

    boolean isInHill(int cx, int cz) {
        int dx = this.radius - cx;
        int dz = this.radius - cz;
        int dist = (int)Math.sqrt(dx * dx + dz * dz);
        return dist < this.radius;
    }

    boolean isInHill(int mapX, int mapY, int mapZ) {
        int dx = this.field_74887_e.field_78897_a + this.radius - mapX;
        int dy = (this.field_74887_e.field_78895_b - mapY) * 2;
        int dz = this.field_74887_e.field_78896_c + this.radius - mapZ;
        int dist = dx * dx + dy * dy + dz * dz;
        return dist < this.radius * this.radius;
    }

    int[] getCoordsInHill2D(Random rand) {
        return this.getCoordsInHill2D(rand, this.radius);
    }

    int[] getCoordsInHill2D(Random rand, int rad) {
        int rz;
        int rx;
        while (!this.isInHill(rx = rand.nextInt(2 * rad), rz = rand.nextInt(2 * rad))) {
        }
        int[] coords = new int[]{rx, rz};
        return coords;
    }

    protected String getMobID(Random rand) {
        return this.getMobID(rand, this.hillSize);
    }

    protected String getMobID(Random rand, int level) {
        String string;
        switch (level) {
            case 1: {
                string = this.getLevel1Mob(rand);
                break;
            }
            case 2: {
                string = this.getLevel2Mob(rand);
                break;
            }
            case 3: {
                string = this.getLevel3Mob(rand);
                break;
            }
            default: {
                string = "Spider";
            }
        }
        return string;
    }

    public String getLevel1Mob(Random rand) {
        String string;
        switch (rand.nextInt(10)) {
            case 0: 
            case 1: 
            case 2: {
                string = TFCreatures.getSpawnerNameFor("Swarm Spider");
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                string = "Spider";
                break;
            }
            case 6: 
            case 7: {
                string = "Zombie";
                break;
            }
            case 8: {
                string = "Silverfish";
                break;
            }
            case 9: {
                string = TFCreatures.getSpawnerNameFor("Redcap");
                break;
            }
            default: {
                string = TFCreatures.getSpawnerNameFor("Swarm Spider");
            }
        }
        return string;
    }

    public String getLevel2Mob(Random rand) {
        String string;
        switch (rand.nextInt(10)) {
            case 0: 
            case 1: 
            case 2: {
                string = TFCreatures.getSpawnerNameFor("Redcap");
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                string = "Zombie";
                break;
            }
            case 6: 
            case 7: {
                string = "Skeleton";
                break;
            }
            case 8: {
                string = TFCreatures.getSpawnerNameFor("Swarm Spider");
                break;
            }
            case 9: {
                string = "CaveSpider";
                break;
            }
            default: {
                string = TFCreatures.getSpawnerNameFor("Redcap");
            }
        }
        return string;
    }

    public String getLevel3Mob(Random rand) {
        String string;
        switch (rand.nextInt(11)) {
            case 0: {
                string = TFCreatures.getSpawnerNameFor("Slime Beetle");
                break;
            }
            case 1: {
                string = TFCreatures.getSpawnerNameFor("Fire Beetle");
                break;
            }
            case 2: {
                string = TFCreatures.getSpawnerNameFor("Pinch Beetle");
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                string = "Skeleton";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                string = "CaveSpider";
                break;
            }
            case 9: {
                string = "Creeper";
                break;
            }
            default: {
                string = TFCreatures.getSpawnerNameFor("Twilight Wraith");
            }
        }
        return string;
    }
}

