/*
 * Decompiled with CFR 0.152.
 */
package openblocks.rubbish;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatBase;
import net.minecraft.world.World;
import net.minecraftforge.common.IExtendedEntityProperties;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import openblocks.OpenBlocks;
import openblocks.events.PlayerActionEvent;
import openmods.utils.ItemUtils;

public class BrickManager {
    public static final String BOWELS_PROPERTY = "Bowels";

    public static BowelContents getProperty(Entity entity) {
        IExtendedEntityProperties prop = entity.getExtendedProperties(BOWELS_PROPERTY);
        return prop instanceof BowelContents ? (BowelContents)prop : null;
    }

    @SubscribeEvent
    public void onEntityConstruct(EntityEvent.EntityConstructing evt) {
        if (evt.entity instanceof EntityPlayer) {
            evt.entity.registerExtendedProperties(BOWELS_PROPERTY, (IExtendedEntityProperties)new BowelContents());
        }
    }

    @SubscribeEvent
    public void onEntityDeath(LivingDropsEvent evt) {
        if (evt.entity.field_70170_p.field_72995_K) {
            return;
        }
        IExtendedEntityProperties prop = evt.entity.getExtendedProperties(BOWELS_PROPERTY);
        if (prop instanceof BowelContents) {
            BowelContents tag = (BowelContents)prop;
            for (int i = 0; i < Math.min(tag.brickCount, 16); ++i) {
                EntityItem entityItem = BrickManager.createBrick(evt.entity);
                evt.drops.add(entityItem);
            }
        }
    }

    private static boolean canDropBrick(EntityPlayer player) {
        if (player.field_71075_bZ.field_75098_d) {
            return true;
        }
        IExtendedEntityProperties prop = player.getExtendedProperties(BOWELS_PROPERTY);
        if (prop instanceof BowelContents) {
            BowelContents tag = (BowelContents)prop;
            if (tag.brickCount > 0) {
                --tag.brickCount;
                return true;
            }
        }
        return false;
    }

    @SubscribeEvent
    public void onPlayerScared(PlayerActionEvent evt) {
        if (evt.type == PlayerActionEvent.Type.BOO && evt.sender != null) {
            EntityPlayer player = evt.sender;
            player.field_70170_p.func_72956_a((Entity)player, "openblocks:best.feature.ever.fart", 1.0f, 1.0f);
            if (BrickManager.canDropBrick(player)) {
                EntityItem drop = BrickManager.createBrick((Entity)player);
                drop.field_145804_b = 20;
                player.field_70170_p.func_72838_d((Entity)drop);
                player.func_71029_a((StatBase)OpenBlocks.brickAchievement);
                player.func_71064_a(OpenBlocks.brickStat, 1);
            }
        }
    }

    private static EntityItem createBrick(Entity dropper) {
        ItemStack brick = new ItemStack(Items.field_151118_aC);
        EntityItem drop = ItemUtils.createDrop((Entity)dropper, (ItemStack)brick);
        double rotation = Math.toRadians(dropper.field_70177_z) - 1.5707963267948966;
        double dx = Math.cos(rotation);
        double dz = Math.sin(rotation);
        drop.func_70091_d(0.75 * dx, 0.5, 0.75 * dz);
        drop.field_70159_w = 0.5 * dx;
        drop.field_70181_x = 0.2;
        drop.field_70179_y = 0.5 * dz;
        return drop;
    }

    public static class BowelContents
    implements IExtendedEntityProperties {
        public int brickCount;

        public void saveNBTData(NBTTagCompound entityTag) {
            entityTag.func_74768_a("Bricks", this.brickCount);
        }

        public void loadNBTData(NBTTagCompound entityTag) {
            this.brickCount = entityTag.func_74762_e("Bricks");
        }

        public void init(Entity entity, World world) {
        }
    }
}

