/*
 * Decompiled with CFR 0.152.
 */
package openblocks.client.renderer.tileentity.tank;

import com.google.common.collect.Maps;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import openblocks.client.renderer.tileentity.tank.DiagonalConnection;
import openblocks.client.renderer.tileentity.tank.DoubledCoords;
import openblocks.client.renderer.tileentity.tank.GridConnection;
import openblocks.client.renderer.tileentity.tank.HorizontalConnection;
import openblocks.client.renderer.tileentity.tank.ITankConnections;
import openblocks.client.renderer.tileentity.tank.ITankRenderFluidData;
import openblocks.client.renderer.tileentity.tank.RenderConnection;
import openblocks.client.renderer.tileentity.tank.TankRenderUtils;
import openblocks.client.renderer.tileentity.tank.VerticalConnection;
import openblocks.common.tileentity.TileEntityTank;
import openmods.liquids.GenericTank;
import openmods.utils.Diagonal;

public class TankRenderLogic {
    private final GenericTank tank;
    private int x;
    private int y;
    private int z;
    private World world;
    private TankConnections connections;
    private TankRenderFluidData renderData;

    public TankRenderLogic(GenericTank tank) {
        this.tank = tank;
    }

    private DoubledCoords createCoords(ForgeDirection dir) {
        return new DoubledCoords(this.x, this.y, this.z, dir);
    }

    private DoubledCoords createCoords(Diagonal dir) {
        return new DoubledCoords(this.x, this.y, this.z, dir);
    }

    private ITankConnections getNeighbourTank(int x, int y, int z) {
        TileEntity te = TankRenderUtils.getTileEntitySafe(this.world, x, y, z);
        return te instanceof TileEntityTank ? ((TileEntityTank)te).getTankConnections() : null;
    }

    private ITankConnections getNeighbourTank(ForgeDirection dir) {
        return this.getNeighbourTank(this.x + dir.offsetX, this.y + dir.offsetY, this.z + dir.offsetZ);
    }

    private ITankConnections getNeighbourTank(Diagonal dir) {
        return this.getNeighbourTank(this.x + dir.offsetX, this.y + dir.offsetY, this.z + dir.offsetZ);
    }

    private DiagonalConnection selectDiagonalConnection(ITankConnections tankCW, ITankConnections tankD, ITankConnections tankCCW, Diagonal dir) {
        Diagonal start = dir;
        dir = dir.rotateCW();
        if (tankCW != null) {
            return tankCW.getDiagonalConnection(dir);
        }
        dir = dir.rotateCW();
        if (tankD != null) {
            return tankD.getDiagonalConnection(dir);
        }
        dir = dir.rotateCW();
        if (tankCCW != null) {
            return tankCCW.getDiagonalConnection(dir);
        }
        return new DiagonalConnection(TankRenderUtils.calculatePhase(this.x, this.y, this.z, start), this.createCoords(start));
    }

    private void tryCornerConnection(Map<Diagonal, DiagonalConnection> diagonalConnections, ITankConnections tankCW, ITankConnections tankD, ITankConnections tankCCW, Diagonal dir) {
        DiagonalConnection connection = this.selectDiagonalConnection(tankCW, tankD, tankCCW, dir);
        diagonalConnections.put(dir, connection);
    }

    private void tryHorizontalConnection(Map<ForgeDirection, HorizontalConnection> horizontalConnections, ITankConnections neighbour, ForgeDirection dir) {
        HorizontalConnection connection = neighbour != null ? neighbour.getHorizontalConnection(dir.getOpposite()) : new HorizontalConnection(this.createCoords(dir));
        horizontalConnections.put(dir, connection);
    }

    private VerticalConnection tryBottomConnection(ITankConnections neighbour) {
        return neighbour != null ? neighbour.getTopConnection() : new VerticalConnection(this.createCoords(ForgeDirection.DOWN));
    }

    private VerticalConnection tryTopConnection(ITankConnections neighbour) {
        return neighbour != null ? neighbour.getBottomConnection() : new VerticalConnection(this.createCoords(ForgeDirection.UP));
    }

    private TankConnections updateConnections() {
        ITankConnections tankN = this.getNeighbourTank(ForgeDirection.NORTH);
        ITankConnections tankS = this.getNeighbourTank(ForgeDirection.SOUTH);
        ITankConnections tankW = this.getNeighbourTank(ForgeDirection.WEST);
        ITankConnections tankE = this.getNeighbourTank(ForgeDirection.EAST);
        ITankConnections tankNE = this.getNeighbourTank(Diagonal.NE);
        ITankConnections tankNW = this.getNeighbourTank(Diagonal.NW);
        ITankConnections tankSE = this.getNeighbourTank(Diagonal.SE);
        ITankConnections tankSW = this.getNeighbourTank(Diagonal.SW);
        ITankConnections tankT = this.getNeighbourTank(ForgeDirection.UP);
        ITankConnections tankB = this.getNeighbourTank(ForgeDirection.DOWN);
        VerticalConnection topConnection = this.tryTopConnection(tankT);
        VerticalConnection bottomConnection = this.tryBottomConnection(tankB);
        EnumMap diagonalConnections = Maps.newEnumMap(Diagonal.class);
        EnumMap horizontalConnections = Maps.newEnumMap(ForgeDirection.class);
        this.tryHorizontalConnection(horizontalConnections, tankN, ForgeDirection.NORTH);
        this.tryHorizontalConnection(horizontalConnections, tankS, ForgeDirection.SOUTH);
        this.tryHorizontalConnection(horizontalConnections, tankW, ForgeDirection.WEST);
        this.tryHorizontalConnection(horizontalConnections, tankE, ForgeDirection.EAST);
        this.tryCornerConnection(diagonalConnections, tankN, tankNW, tankW, Diagonal.NW);
        this.tryCornerConnection(diagonalConnections, tankW, tankSW, tankS, Diagonal.SW);
        this.tryCornerConnection(diagonalConnections, tankE, tankNE, tankN, Diagonal.NE);
        this.tryCornerConnection(diagonalConnections, tankS, tankSE, tankE, Diagonal.SE);
        return new TankConnections(this.tank, diagonalConnections, horizontalConnections, topConnection, bottomConnection);
    }

    public void initialize(World world, int x, int y, int z) {
        this.world = world;
        this.x = x;
        this.y = y;
        this.z = z;
        if (this.connections != null) {
            this.connections.detach();
        }
        if (world == null) {
            this.connections = null;
            this.renderData = null;
        } else {
            float phase = TankRenderUtils.calculatePhase(x, y, z);
            this.connections = this.updateConnections();
            this.renderData = new TankRenderFluidData(this.connections, this.tank, phase);
        }
    }

    public void validateConnections(World world, int x, int y, int z) {
        if (world != this.world || this.connections == null || !this.connections.checkConsistency(x, y, z)) {
            this.initialize(world, x, y, z);
        }
    }

    public void invalidateConnections() {
        if (this.connections != null) {
            this.connections.detach();
        }
        this.connections = null;
        this.renderData = null;
    }

    public void updateFluid(FluidStack stack) {
        if (this.connections != null) {
            this.connections.updateFluid(stack);
        }
    }

    public ITankRenderFluidData getTankRenderData() {
        return this.renderData;
    }

    public ITankConnections getTankConnections() {
        return this.connections;
    }

    private static class TankConnections
    implements ITankConnections {
        private final GenericTank tank;
        private final Map<Diagonal, DiagonalConnection> diagonalConnections;
        private final Map<ForgeDirection, HorizontalConnection> horizontalConnections;
        private final VerticalConnection topConnection;
        private final VerticalConnection bottomConnection;

        public TankConnections(GenericTank tank, Map<Diagonal, DiagonalConnection> diagonalConnections, Map<ForgeDirection, HorizontalConnection> horizontalConnections, VerticalConnection topConnection, VerticalConnection bottomConnection) {
            this.tank = tank;
            this.diagonalConnections = diagonalConnections;
            this.horizontalConnections = horizontalConnections;
            this.topConnection = topConnection;
            this.bottomConnection = bottomConnection;
        }

        @Override
        public VerticalConnection getTopConnection() {
            return this.topConnection;
        }

        @Override
        public VerticalConnection getBottomConnection() {
            return this.bottomConnection;
        }

        @Override
        public HorizontalConnection getHorizontalConnection(ForgeDirection dir) {
            return this.horizontalConnections.get(dir);
        }

        @Override
        public DiagonalConnection getDiagonalConnection(Diagonal dir) {
            return this.diagonalConnections.get(dir);
        }

        public void updateFluid(FluidStack fluidStack) {
            for (Map.Entry<Diagonal, DiagonalConnection> entry : this.diagonalConnections.entrySet()) {
                entry.getValue().updateFluid(entry.getKey().getOpposite(), fluidStack);
            }
            for (Map.Entry<Object, RenderConnection> entry : this.horizontalConnections.entrySet()) {
                ((HorizontalConnection)entry.getValue()).updateFluid(((ForgeDirection)entry.getKey()).getOpposite(), fluidStack);
            }
            this.topConnection.updateBottomFluid(fluidStack, this.tank.getSpace() == 0);
            this.bottomConnection.updateTopFluid(fluidStack);
        }

        private static boolean checkConsistency(RenderConnection connection, int x, int y, int z, ForgeDirection dir) {
            return connection != null && connection.isPositionEqualTo(x, y, z, dir);
        }

        private static boolean checkConsistency(RenderConnection connection, int x, int y, int z, Diagonal dir) {
            return connection != null && connection.isPositionEqualTo(x, y, z, dir);
        }

        private boolean checkHorizontalConsistency(int x, int y, int z, ForgeDirection dir) {
            return TankConnections.checkConsistency((RenderConnection)this.horizontalConnections.get(dir), x, y, z, dir);
        }

        private boolean checkDiagonalConsistency(int x, int y, int z, Diagonal dir) {
            return TankConnections.checkConsistency((RenderConnection)this.diagonalConnections.get(dir), x, y, z, dir);
        }

        public boolean checkConsistency(int x, int y, int z) {
            return TankConnections.checkConsistency((RenderConnection)this.topConnection, x, y, z, ForgeDirection.UP) && TankConnections.checkConsistency((RenderConnection)this.bottomConnection, x, y, z, ForgeDirection.DOWN) && this.checkHorizontalConsistency(x, y, z, ForgeDirection.NORTH) && this.checkHorizontalConsistency(x, y, z, ForgeDirection.SOUTH) && this.checkHorizontalConsistency(x, y, z, ForgeDirection.EAST) && this.checkHorizontalConsistency(x, y, z, ForgeDirection.WEST) && this.checkDiagonalConsistency(x, y, z, Diagonal.NE) && this.checkDiagonalConsistency(x, y, z, Diagonal.NW) && this.checkDiagonalConsistency(x, y, z, Diagonal.SE) && this.checkDiagonalConsistency(x, y, z, Diagonal.SW);
        }

        public void detach() {
            for (Map.Entry<Diagonal, DiagonalConnection> entry : this.diagonalConnections.entrySet()) {
                entry.getValue().clearFluid(entry.getKey().getOpposite());
            }
            for (Map.Entry<Object, RenderConnection> entry : this.horizontalConnections.entrySet()) {
                ((HorizontalConnection)entry.getValue()).clearFluid(((ForgeDirection)entry.getKey()).getOpposite());
            }
            if (this.topConnection != null) {
                this.topConnection.clearBottomFluid();
            }
            if (this.bottomConnection != null) {
                this.bottomConnection.clearTopFluid();
            }
        }
    }

    private static class TankRenderFluidData
    implements ITankRenderFluidData {
        private final TankConnections connections;
        private final GenericTank tank;
        private final float phase;

        public TankRenderFluidData(TankConnections connections, GenericTank tank, float phase) {
            this.connections = connections;
            this.tank = tank;
            this.phase = phase;
        }

        private static boolean isConnected(GridConnection connection) {
            return connection != null ? connection.isConnected() : false;
        }

        @Override
        public boolean shouldRenderFluidWall(ForgeDirection side) {
            switch (side) {
                case DOWN: {
                    return !TankRenderFluidData.isConnected(this.connections.getBottomConnection());
                }
                case UP: {
                    return !TankRenderFluidData.isConnected(this.connections.getTopConnection());
                }
                case EAST: 
                case WEST: 
                case NORTH: 
                case SOUTH: {
                    return !TankRenderFluidData.isConnected(this.connections.getHorizontalConnection(side));
                }
            }
            return true;
        }

        @Override
        public boolean hasFluid() {
            return this.tank.getFluidAmount() > 0;
        }

        @Override
        public FluidStack getFluid() {
            return this.tank.getFluid();
        }

        @Override
        public float getCenterFluidLevel(float time) {
            float raw = (float)this.tank.getFluidAmount() / (float)this.tank.getCapacity();
            float waving = TankRenderUtils.calculateWaveAmplitude(time, this.phase) + raw;
            return TankRenderUtils.clampLevel(waving);
        }

        @Override
        public float getCornerFluidLevel(Diagonal corner, float time) {
            DiagonalConnection diagonal = this.connections.getDiagonalConnection(corner);
            return diagonal != null ? diagonal.getRenderHeight(corner.getOpposite(), time) : this.getCenterFluidLevel(time);
        }
    }
}

