/*
 * Decompiled with CFR 0.152.
 */
package tb.common.enchantment;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.Iterator;
import java.util.LinkedHashMap;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.item.ItemExpireEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import tb.init.TBEnchant;
import tb.utils.TBUtils;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.entities.IEldritchMob;
import thaumcraft.api.entities.ITaintedMob;
import thaumcraft.api.nodes.NodeType;
import thaumcraft.codechicken.lib.math.MathHelper;
import thaumcraft.common.blocks.BlockAiry;
import thaumcraft.common.config.Config;
import thaumcraft.common.config.ConfigItems;
import thaumcraft.common.entities.EntityAspectOrb;
import thaumcraft.common.items.ItemCrystalEssence;
import thaumcraft.common.lib.research.ResearchManager;
import thaumcraft.common.lib.research.ScanManager;
import thaumcraft.common.tiles.TileNode;

public class EnchantmentHandler {
    @SubscribeEvent
    public void itemExpire(ItemExpireEvent event) {
        if (event.entityItem != null && event.entityItem.func_92059_d() != null && !event.entityItem.field_70170_p.field_72995_K) {
            TileEntity t;
            int x = MathHelper.floor_double((double)event.entityItem.field_70165_t);
            int y = MathHelper.floor_double((double)event.entityItem.field_70163_u);
            int z = MathHelper.floor_double((double)event.entityItem.field_70161_v);
            World w = event.entityItem.field_70170_p;
            ItemStack is = event.entityItem.func_92059_d();
            Block b = w.func_147439_a(x, y, z);
            if (b != null && b instanceof BlockAiry && (t = w.func_147438_o(x, y, z)) != null && t instanceof TileNode && ((TileNode)TileNode.class.cast(t)).getNodeType() == NodeType.TAINTED && is.func_77973_b() instanceof ItemSword && EnchantmentHelper.func_77506_a((int)TBEnchant.tainted.field_77352_x, (ItemStack)is) <= 0) {
                LinkedHashMap lhm = (LinkedHashMap)EnchantmentHelper.func_82781_a((ItemStack)is);
                boolean canApply = true;
                if (!lhm.isEmpty()) {
                    Iterator $i = lhm.keySet().iterator();
                    while ($i.hasNext()) {
                        Enchantment ench;
                        int i = (Integer)$i.next();
                        if (i >= Enchantment.field_77331_b.length || Enchantment.field_77331_b[i] == null || (ench = Enchantment.field_77331_b[i]).func_77326_a(TBEnchant.tainted)) continue;
                        canApply = false;
                        break;
                    }
                }
                if (canApply) {
                    is.func_77966_a(TBEnchant.tainted, 1 + w.field_73012_v.nextInt(3));
                    event.extraLife = 1000;
                    event.setCanceled(true);
                }
            }
        }
    }

    @SubscribeEvent
    public void onMobDeath(LivingDeathEvent event) {
        if (event.entityLiving != null && !event.entityLiving.field_70170_p.field_72995_K && event.source != null && event.source.func_76364_f() != null && event.source.func_76364_f() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)EntityPlayer.class.cast(event.source.func_76364_f());
            EntityLivingBase dyingMob = event.entityLiving;
            ItemStack currentItem = player.func_71045_bC();
            if (currentItem != null) {
                AspectList aspects;
                int enchLevel;
                if (EnchantmentHelper.func_77506_a((int)TBEnchant.elderKnowledge.field_77352_x, (ItemStack)currentItem) > 0 && player.field_70170_p.field_73012_v.nextInt(Math.max(1, 7 - (enchLevel = EnchantmentHelper.func_77506_a((int)TBEnchant.elderKnowledge.field_77352_x, (ItemStack)currentItem)))) == 0) {
                    ThaumcraftApi.EntityTags eTags = null;
                    for (int i = 0; i < ThaumcraftApi.scanEntities.size(); ++i) {
                        ThaumcraftApi.EntityTags tags = (ThaumcraftApi.EntityTags)ThaumcraftApi.scanEntities.get(i);
                        if (tags == null || EntityList.func_75621_b((Entity)dyingMob) == null || !EntityList.func_75621_b((Entity)dyingMob).equalsIgnoreCase(tags.entityName)) continue;
                        eTags = tags;
                        break;
                    }
                    if (eTags != null) {
                        AspectList al = eTags.aspects;
                        for (int i = 0; i < al.size(); ++i) {
                            TBUtils.addAspectToKnowledgePool(player, al.getAspects()[i], (short)1);
                            if (player.field_70170_p.field_73012_v.nextBoolean()) break;
                        }
                    }
                }
                if (EnchantmentHelper.func_77506_a((int)TBEnchant.magicTouch.field_77352_x, (ItemStack)currentItem) > 0) {
                    enchLevel = EnchantmentHelper.func_77506_a((int)TBEnchant.magicTouch.field_77352_x, (ItemStack)currentItem);
                    AspectList aspectsCompound = ScanManager.generateEntityAspects((Entity)dyingMob);
                    if (aspectsCompound != null && aspectsCompound.size() > 0) {
                        AspectList aspects2 = ResearchManager.reduceToPrimals((AspectList)aspectsCompound);
                        for (int i = 0; i < enchLevel; ++i) {
                            for (Aspect aspect : aspects2.getAspects()) {
                                if (!event.entityLiving.field_70170_p.field_73012_v.nextBoolean()) continue;
                                EntityAspectOrb orb = new EntityAspectOrb(event.entityLiving.field_70170_p, event.entityLiving.field_70165_t, event.entityLiving.field_70163_u, event.entityLiving.field_70161_v, aspect, 1 + event.entityLiving.field_70170_p.field_73012_v.nextInt(aspects2.getAmount(aspect)));
                                event.entityLiving.field_70170_p.func_72838_d((Entity)orb);
                            }
                            if (player.field_70170_p.field_73012_v.nextBoolean()) break;
                        }
                    }
                }
                if (EnchantmentHelper.func_77506_a((int)TBEnchant.vaporising.field_77352_x, (ItemStack)currentItem) > 0 && event.entity.field_70170_p.field_73012_v.nextInt(Math.max(1, 5 - (enchLevel = EnchantmentHelper.func_77506_a((int)TBEnchant.vaporising.field_77352_x, (ItemStack)currentItem)))) == 0 && (aspects = ScanManager.generateEntityAspects((Entity)event.entityLiving)) != null && aspects.size() > 0) {
                    for (Aspect aspect : aspects.getAspects()) {
                        if (!event.entity.field_70170_p.field_73012_v.nextBoolean()) {
                            int size = 1 + event.entity.field_70170_p.field_73012_v.nextInt(aspects.getAmount(aspect));
                            size = Math.max(1, size / 2);
                            ItemStack stack = new ItemStack(ConfigItems.itemCrystalEssence, size, 0);
                            ((ItemCrystalEssence)stack.func_77973_b()).setAspects(stack, new AspectList().add(aspect, 1));
                            EntityItem cEs = new EntityItem(event.entity.field_70170_p, event.entityLiving.field_70165_t, event.entityLiving.field_70163_u + (double)event.entityLiving.func_70047_e(), event.entityLiving.field_70161_v, stack);
                            event.entity.field_70170_p.func_72838_d((Entity)cEs);
                        }
                        if (event.entity.field_70170_p.field_73012_v.nextInt(2 + enchLevel) == 0) break;
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void onMobDamage(LivingHurtEvent event) {
        if (event.entityLiving != null && !event.entityLiving.field_70170_p.field_72995_K && event.source != null && event.source.func_76364_f() != null && event.source.func_76364_f() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)EntityPlayer.class.cast(event.source.func_76364_f());
            EntityLivingBase mob = event.entityLiving;
            ItemStack currentItem = player.func_71045_bC();
            if (currentItem != null) {
                int enchLevel;
                if ((mob instanceof EntityEnderman || mob instanceof IEldritchMob) && EnchantmentHelper.func_77506_a((int)TBEnchant.eldritchBane.field_77352_x, (ItemStack)currentItem) > 0) {
                    enchLevel = EnchantmentHelper.func_77506_a((int)TBEnchant.eldritchBane.field_77352_x, (ItemStack)currentItem);
                    event.ammount += (float)enchLevel * 5.0f;
                }
                if (EnchantmentHelper.func_77506_a((int)TBEnchant.tainted.field_77352_x, (ItemStack)currentItem) > 0) {
                    enchLevel = EnchantmentHelper.func_77506_a((int)TBEnchant.tainted.field_77352_x, (ItemStack)currentItem);
                    if (!(mob instanceof ITaintedMob)) {
                        event.ammount += (float)enchLevel * 3.0f;
                        if (player.field_70170_p.field_73012_v.nextInt(Math.max(1, 4 - enchLevel)) == 0) {
                            mob.func_70690_d(new PotionEffect(Config.potionTaintPoisonID, 200, enchLevel - 1, true));
                        }
                    }
                }
            }
        }
    }
}

