/*
 * Decompiled with CFR 0.152.
 */
package tectech.recipe;

import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.math.Pos2d;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.common.widget.DrawableWidget;
import gregtech.api.recipe.BasicUIPropertiesBuilder;
import gregtech.api.recipe.NEIRecipePropertiesBuilder;
import gregtech.api.recipe.RecipeMapFrontend;
import gregtech.api.util.GTRecipeConstants;
import gregtech.api.util.GTUtility;
import gregtech.api.util.MethodsReturnNonnullByDefault;
import gregtech.nei.RecipeDisplayInfo;
import java.util.Collections;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.util.StatCollector;
import tectech.thing.gui.TecTechUITextures;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class GodforgePlasmaFrontend
extends RecipeMapFrontend {
    public GodforgePlasmaFrontend(BasicUIPropertiesBuilder uiPropertiesBuilder, NEIRecipePropertiesBuilder neiPropertiesBuilder) {
        super(uiPropertiesBuilder, neiPropertiesBuilder);
    }

    @Override
    public void addGregTechLogo(ModularWindow.Builder builder, Pos2d windowOffset) {
        builder.widget(new DrawableWidget().setDrawable((IDrawable)TecTechUITextures.PICTURE_GODFORGE_LOGO).setSize(18, 18).setPos(new Pos2d(151, 63).add(windowOffset)));
    }

    @Override
    public List<Pos2d> getItemInputPositions(int itemInputCount) {
        return Collections.singletonList(new Pos2d(52, 33));
    }

    @Override
    public List<Pos2d> getItemOutputPositions(int itemOutputCount) {
        return Collections.singletonList(new Pos2d(106, 33));
    }

    @Override
    protected void drawEnergyInfo(RecipeDisplayInfo recipeInfo) {
        String string;
        long eut = recipeInfo.recipe.mEUt;
        long duration = recipeInfo.recipe.mDuration;
        String multistep = "No";
        if (recipeInfo.recipe.getMetadataOrDefault(GTRecipeConstants.FOG_PLASMA_MULTISTEP, false).booleanValue()) {
            multistep = "Yes";
        }
        switch (recipeInfo.recipe.getMetadataOrDefault(GTRecipeConstants.FOG_PLASMA_TIER, 0)) {
            case 1: {
                string = "T4-T5";
                break;
            }
            case 2: {
                string = "Exotic";
                break;
            }
            default: {
                string = "T1-T3";
            }
        }
        String requiredUpgrade = string;
        recipeInfo.drawText(GTUtility.trans("152", "Total: ") + GTUtility.formatNumbers(eut * duration) + " EU");
        recipeInfo.drawText(GTUtility.trans("153", "Usage: ") + GTUtility.formatNumbers(eut) + " EU/t");
        recipeInfo.drawText(GTUtility.trans("158", "Time: ") + GTUtility.formatNumbers((double)duration / 20.0) + " secs" + (duration < 20L ? " (" + duration + " ticks)" : ""));
        recipeInfo.drawText(StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.FOG.plasmamultistep") + ": " + multistep);
        recipeInfo.drawText(StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.FOG.plasmarecipetier") + ": " + requiredUpgrade);
    }

    @Override
    protected void drawDurationInfo(RecipeDisplayInfo recipeInfo) {
    }
}

