/*
 * Decompiled with CFR 0.152.
 */
package gregtech.loaders.misc.bees;

import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IBeeModifier;
import forestry.api.genetics.IEffectData;
import forestry.core.genetics.EffectData;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.metatileentity.BaseMetaTileEntity;
import gregtech.api.metatileentity.implementations.MTETieredMachineBlock;
import gregtech.loaders.misc.bees.GTAlleleEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;

public class GTEffectMachineBoost
extends GTAlleleEffect {
    public GTEffectMachineBoost() {
        super("effectMachineBoost", false, 600);
    }

    @Override
    public IEffectData validateStorage(IEffectData storedData) {
        if (storedData == null) {
            storedData = new EffectData(1, 1);
        }
        return storedData;
    }

    @Override
    protected IEffectData doEffectTickThrottled(IBeeGenome genome, IEffectData storedData, IBeeHousing housing) {
        BaseMetaTileEntity machine;
        IMetaTileEntity iMetaTileEntity;
        int zCoord;
        int yCoord;
        World world = housing.getWorld();
        ChunkCoordinates coords = housing.getCoordinates();
        IBeeModifier beeModifier = BeeManager.beeRoot.createBeeHousingModifier(housing);
        int xRange = (int)(beeModifier.getTerritoryModifier(genome, 1.0f) * (float)genome.getTerritory()[0]);
        int yRange = (int)(beeModifier.getTerritoryModifier(genome, 1.0f) * (float)genome.getTerritory()[1]);
        int zRange = (int)(beeModifier.getTerritoryModifier(genome, 1.0f) * (float)genome.getTerritory()[2]);
        int xCoord = coords.field_71574_a + world.field_73012_v.nextInt(xRange) - xRange / 2;
        TileEntity tileEntity = world.func_147438_o(xCoord, yCoord = coords.field_71572_b + world.field_73012_v.nextInt(yRange) - yRange / 2, zCoord = coords.field_71573_c + world.field_73012_v.nextInt(zRange) - zRange / 2);
        if (tileEntity instanceof BaseMetaTileEntity && (iMetaTileEntity = (machine = (BaseMetaTileEntity)tileEntity).getMetaTileEntity()) instanceof MTETieredMachineBlock) {
            MTETieredMachineBlock tieredMachine = (MTETieredMachineBlock)iMetaTileEntity;
            if (tieredMachine.mTier <= 4 && machine.isActive() && machine.getMaxProgress() > 60) {
                machine.increaseProgress(40);
            }
        }
        storedData.setInteger(0, 0);
        return storedData;
    }
}

