/*
 * Decompiled with CFR 0.152.
 */
package gregtech.crossmod.ae2;

import appeng.api.config.AccessRestriction;
import appeng.api.config.Actionable;
import appeng.api.networking.IGridNode;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.storage.IBaseMonitor;
import appeng.api.parts.IPart;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IMEMonitorHandlerReceiver;
import appeng.api.storage.StorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.util.item.AEItemStack;
import appeng.util.item.ItemList;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.util.GTUtility;
import gregtech.crossmod.ae2.IMEAwareItemInventory;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.item.ItemStack;

public class MEItemInventoryHandler<T extends IMetaTileEntity & IMEAwareItemInventory>
implements IMEMonitor<IAEItemStack> {
    private final T machine;
    private final Map<IMEMonitorHandlerReceiver<IAEItemStack>, Object> listeners = new HashMap<IMEMonitorHandlerReceiver<IAEItemStack>, Object>();

    public MEItemInventoryHandler(T machine) {
        this.machine = machine;
    }

    public void addListener(IMEMonitorHandlerReceiver<IAEItemStack> l, Object verificationToken) {
        this.listeners.put(l, verificationToken);
    }

    public void removeListener(IMEMonitorHandlerReceiver<IAEItemStack> l) {
        this.listeners.remove(l);
    }

    public AccessRestriction getAccess() {
        return AccessRestriction.READ_WRITE;
    }

    public boolean isPrioritized(IAEItemStack aeItemStack) {
        ItemStack s = ((IMEAwareItemInventory)this.machine).getItemStack();
        if (s == null || aeItemStack == null) {
            return false;
        }
        return aeItemStack.isSameType(s);
    }

    public boolean canAccept(IAEItemStack aeItemStack) {
        ItemStack s = ((IMEAwareItemInventory)this.machine).getItemStack();
        if (s == null || aeItemStack == null) {
            return true;
        }
        return aeItemStack.isSameType(s);
    }

    public int getPriority() {
        return 0;
    }

    public int getSlot() {
        return 0;
    }

    public boolean validForPass(int i) {
        return true;
    }

    public IItemList<IAEItemStack> getAvailableItems(IItemList<IAEItemStack> out, int iteration) {
        return this.gatherItems(out);
    }

    public IItemList<IAEItemStack> getStorageList() {
        return this.gatherItems((IItemList<IAEItemStack>)new ItemList());
    }

    private IItemList<IAEItemStack> gatherItems(IItemList<IAEItemStack> out) {
        ItemStack extraStoredStack;
        ItemStack storedStack = ((IMEAwareItemInventory)this.machine).getItemStack();
        if (storedStack != null) {
            AEItemStack s = AEItemStack.create((ItemStack)storedStack);
            s.setStackSize((long)((IMEAwareItemInventory)this.machine).getItemCount());
            out.add((IAEStack)s);
        }
        if ((extraStoredStack = ((IMEAwareItemInventory)this.machine).getExtraItemStack()) != null) {
            AEItemStack s = AEItemStack.create((ItemStack)extraStoredStack);
            out.add((IAEStack)s);
        }
        return out;
    }

    public IAEItemStack injectItems(IAEItemStack input, Actionable mode, BaseActionSource src) {
        if (this.machine.getBaseMetaTileEntity() == null) {
            return input;
        }
        ItemStack inputStack = input.getItemStack();
        int maxCapacity = ((IMEAwareItemInventory)this.machine).getItemCapacity();
        int itemCount = ((IMEAwareItemInventory)this.machine).getItemCount();
        long toAdd = input.getStackSize();
        ItemStack storedStack = ((IMEAwareItemInventory)this.machine).getItemStack();
        if (storedStack != null && !GTUtility.areStacksEqual(storedStack, inputStack)) {
            return input;
        }
        if (storedStack == null && !((IMEAwareItemInventory)this.machine).isValidItem(inputStack)) {
            return input;
        }
        long notAdded = (long)itemCount + toAdd - (long)maxCapacity;
        if (mode == Actionable.MODULATE) {
            int newCount = (int)Math.min((long)maxCapacity, (long)itemCount + toAdd);
            if (storedStack == null) {
                ((IMEAwareItemInventory)this.machine).setItemStack(inputStack.func_77946_l());
            }
            ((IMEAwareItemInventory)this.machine).setItemCount(newCount);
            this.machine.getBaseMetaTileEntity().func_70296_d();
        }
        if (notAdded <= 0L) {
            return null;
        }
        return (IAEItemStack)input.copy().setStackSize(notAdded);
    }

    public IAEItemStack extractItems(IAEItemStack request, Actionable mode, BaseActionSource src) {
        if (this.machine.getBaseMetaTileEntity() == null) {
            return null;
        }
        if (request.isSameType(((IMEAwareItemInventory)this.machine).getItemStack())) {
            if (mode != Actionable.SIMULATE) {
                this.machine.getBaseMetaTileEntity().func_70296_d();
            }
            ItemStack storedItemStack = ((IMEAwareItemInventory)this.machine).getItemStack();
            ItemStack storedExtraItemStack = ((IMEAwareItemInventory)this.machine).getExtraItemStack();
            int storedItemCount = ((IMEAwareItemInventory)this.machine).getItemCount();
            boolean isExtraItemSameType = GTUtility.areStacksEqual(storedItemStack, storedExtraItemStack);
            int extraItemCount = isExtraItemSameType ? storedExtraItemStack.field_77994_a : 0;
            long totalItemCount = (long)storedItemCount + (long)extraItemCount;
            if (request.getStackSize() >= totalItemCount) {
                AEItemStack result = AEItemStack.create((ItemStack)((IMEAwareItemInventory)this.machine).getItemStack());
                result.setStackSize(totalItemCount);
                if (mode != Actionable.SIMULATE) {
                    ((IMEAwareItemInventory)this.machine).setItemCount(0);
                    if (isExtraItemSameType) {
                        ((IMEAwareItemInventory)this.machine).setExtraItemStack(null);
                    }
                }
                return result;
            }
            if (mode != Actionable.SIMULATE) {
                if (request.getStackSize() > (long)storedItemCount) {
                    ((IMEAwareItemInventory)this.machine).setItemCount(0);
                    storedExtraItemStack.field_77994_a -= (int)(request.getStackSize() - (long)storedItemCount);
                } else {
                    ((IMEAwareItemInventory)this.machine).setItemCount(storedItemCount - (int)request.getStackSize());
                }
            }
            return request.copy();
        }
        if (request.isSameType(((IMEAwareItemInventory)this.machine).getExtraItemStack())) {
            ItemStack extraItemStack = ((IMEAwareItemInventory)this.machine).getExtraItemStack();
            if (mode != Actionable.SIMULATE) {
                this.machine.getBaseMetaTileEntity().func_70296_d();
            }
            if (request.getStackSize() >= (long)extraItemStack.field_77994_a) {
                AEItemStack result = AEItemStack.create((ItemStack)extraItemStack);
                if (mode != Actionable.SIMULATE) {
                    ((IMEAwareItemInventory)this.machine).setExtraItemStack(null);
                }
                return result;
            }
            if (mode != Actionable.SIMULATE) {
                extraItemStack.field_77994_a -= (int)request.getStackSize();
            }
            return request.copy();
        }
        return null;
    }

    public StorageChannel getChannel() {
        return StorageChannel.ITEMS;
    }

    public void notifyListeners(int count, ItemStack stack) {
        if (count == 0 || stack == null) {
            return;
        }
        ItemList change = new ItemList();
        AEItemStack s = AEItemStack.create((ItemStack)stack);
        s.setStackSize((long)count);
        change.add((IAEItemStack)s);
        this.listeners.forEach((l, o) -> {
            if (l.isValid(o)) {
                l.postChange((IBaseMonitor)this, (Iterable)change, null);
            } else {
                this.removeListener((IMEMonitorHandlerReceiver<IAEItemStack>)l);
            }
        });
    }

    public boolean hasActiveMEConnection() {
        if (this.listeners.isEmpty()) {
            return false;
        }
        for (Map.Entry<IMEMonitorHandlerReceiver<IAEItemStack>, Object> e : this.listeners.entrySet()) {
            IGridNode n;
            if (!(e.getKey() instanceof IPart) || (n = ((IPart)e.getKey()).getGridNode()) == null || !n.isActive()) continue;
            return true;
        }
        this.listeners.clear();
        return false;
    }
}

