/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.render;

import gregtech.common.tileentities.render.TileEntityWormhole;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import org.lwjgl.opengl.GL11;
import tectech.rendering.EOH.EOHRenderingUtils;

public class WormholeRenderer
extends TileEntitySpecialRenderer {
    private static final double trimPercentage = 0.95;
    private static final double corePercentage = 0.95 / Math.sqrt(3.0);

    private static void render(Block coreBlock, double rotation) {
        GL11.glPushMatrix();
        GL11.glRotated((double)rotation, (double)2.0, (double)1.0, (double)0.0);
        GL11.glScaled((double)-1.0, (double)-1.0, (double)-1.0);
        Tessellator tess = Tessellator.field_78398_a;
        tess.func_78382_b();
        tess.func_78386_a(1.0f, 1.0f, 1.0f);
        EOHRenderingUtils.addRenderedBlockInWorld(Blocks.field_150371_ca, 0, 0.0, 0.0, 0.0);
        tess.func_78381_a();
        GL11.glScaled((double)0.95, (double)0.95, (double)0.95);
        tess.func_78382_b();
        tess.func_78386_a(0.1f, 0.1f, 0.1f);
        EOHRenderingUtils.addRenderedBlockInWorld(Blocks.field_150402_ci, 0, 0.0, 0.0, 0.0);
        tess.func_78381_a();
        GL11.glPopMatrix();
        if (coreBlock != null) {
            GL11.glPushMatrix();
            GL11.glScaled((double)corePercentage, (double)corePercentage, (double)corePercentage);
            GL11.glRotated((double)rotation, (double)0.0, (double)-2.0, (double)0.1);
            tess.func_78382_b();
            tess.func_78386_a(1.0f, 1.0f, 1.0f);
            EOHRenderingUtils.addRenderedBlockInWorld(coreBlock, 0, 0.0, 0.0, 0.0);
            tess.func_78381_a();
            GL11.glPopMatrix();
        }
    }

    public void func_147500_a(TileEntity tile, double x, double y, double z, float timeSinceLastTick) {
        if (tile instanceof TileEntityWormhole) {
            TileEntityWormhole wTile = (TileEntityWormhole)tile;
            GL11.glPushMatrix();
            GL11.glTranslated((double)(x + 0.5), (double)(y + 0.5), (double)(z + 0.5));
            GL11.glScaled((double)wTile.targetRadius, (double)wTile.targetRadius, (double)wTile.targetRadius);
            GL11.glPushAttrib((int)1048575);
            GL11.glDisable((int)2896);
            double rotationTimer = (float)wTile.func_145831_w().func_72912_H().func_82573_f() + timeSinceLastTick;
            this.func_147499_a(TextureMap.field_110575_b);
            WormholeRenderer.render(wTile.getBlock(), rotationTimer);
            GL11.glPopAttrib();
            GL11.glPopMatrix();
        }
    }
}

