/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.gui.mui1.cover;

import com.gtnewhorizons.modularui.api.NumberFormatMUI;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.drawable.Text;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.common.widget.TextWidget;
import gregtech.api.gui.modularui.CoverUIBuildContext;
import gregtech.api.gui.modularui.GTUITextures;
import gregtech.api.util.GTUtility;
import gregtech.common.covers.Cover;
import gregtech.common.covers.CoverFluidRegulator;
import gregtech.common.gui.modularui.widget.CoverDataControllerWidget;
import gregtech.common.gui.modularui.widget.CoverDataFollowerNumericWidget;
import gregtech.common.gui.modularui.widget.CoverDataFollowerToggleButtonWidget;
import gregtech.common.gui.mui1.cover.CoverUIFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.util.StatCollector;

public class FluidRegulatorUIFactory
extends CoverUIFactory<CoverFluidRegulator> {
    private static final int startX = 10;
    private static final int startY = 25;
    private static final int spaceX = 18;
    private static final int spaceY = 18;
    private static final NumberFormatMUI numberFormat = new NumberFormatMUI();

    public FluidRegulatorUIFactory(CoverUIBuildContext buildContext) {
        super(buildContext);
    }

    @Override
    protected CoverFluidRegulator adaptCover(Cover cover) {
        if (cover instanceof CoverFluidRegulator) {
            CoverFluidRegulator adapterCover = (CoverFluidRegulator)cover;
            return adapterCover;
        }
        return null;
    }

    @Override
    protected void addUIWidgets(ModularWindow.Builder builder) {
        AtomicBoolean warn = new AtomicBoolean(false);
        ((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)builder.widget(new CoverDataControllerWidget<CoverFluidRegulator>(this::getCover, this.getUIBuildContext()).addFollower(CoverDataFollowerToggleButtonWidget.ofDisableable(), coverData -> coverData.getSpeed() >= 0, (coverData, state) -> coverData.setSpeed(Math.abs(coverData.getSpeed())), widget -> widget.setStaticTexture((IDrawable)GTUITextures.OVERLAY_BUTTON_EXPORT).addTooltip(StatCollector.func_74838_a((String)"gt.interact.desc.export.tooltip")).setPos(0, 0)).addFollower(CoverDataFollowerToggleButtonWidget.ofDisableable(), coverData -> coverData.getSpeed() <= 0, (coverData, state) -> coverData.setSpeed(-Math.abs(coverData.getSpeed())), widget -> widget.setStaticTexture((IDrawable)GTUITextures.OVERLAY_BUTTON_IMPORT).addTooltip(StatCollector.func_74838_a((String)"gt.interact.desc.import.tooltip")).setPos(18, 0)).addFollower(CoverDataFollowerToggleButtonWidget.ofDisableable(), coverData -> coverData.getCondition() == CoverFluidRegulator.Conditional.Always, (coverData, state) -> coverData.setCondition(CoverFluidRegulator.Conditional.Always), widget -> widget.setStaticTexture((IDrawable)GTUITextures.OVERLAY_BUTTON_CHECKMARK).addTooltip(StatCollector.func_74838_a((String)"gt.interact.desc.fluid_regulator.AlwaysOn")).setPos(0, 18)).addFollower(CoverDataFollowerToggleButtonWidget.ofDisableable(), coverData -> coverData.getCondition() == CoverFluidRegulator.Conditional.Conditional, (coverData, state) -> coverData.setCondition(CoverFluidRegulator.Conditional.Conditional), widget -> widget.setStaticTexture((IDrawable)GTUITextures.OVERLAY_BUTTON_USE_PROCESSING_STATE).addTooltip(StatCollector.func_74838_a((String)"gt.interact.desc.fluid_regulator.MachProcState")).setPos(18, 18)).addFollower(CoverDataFollowerToggleButtonWidget.ofDisableable(), coverData -> coverData.getCondition() == CoverFluidRegulator.Conditional.Inverted, (coverData, state) -> coverData.setCondition(CoverFluidRegulator.Conditional.Inverted), widget -> widget.setStaticTexture((IDrawable)GTUITextures.OVERLAY_BUTTON_USE_INVERTED_PROCESSING_STATE).addTooltip(StatCollector.func_74838_a((String)"gt.interact.desc.fluid_regulator.InvertedMachProcState")).setPos(36, 18)).addFollower(new CoverDataFollowerNumericWidget(), coverData -> coverData.getSpeed(), (coverData, state) -> coverData.setSpeed(state.intValue()), widget -> widget.setBounds(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY).setValidator(val -> {
            CoverFluidRegulator cover = (CoverFluidRegulator)this.getCover();
            int tickRate = cover != null ? cover.getTickRateForUi() : 0;
            long maxFlow = (cover != null ? (long)cover.getTransferRate() : 0L) * (long)GTUtility.clamp(tickRate, 1, 2048);
            warn.set(false);
            if (val > (double)maxFlow) {
                val = maxFlow;
                warn.set(true);
            } else if (val < (double)(-maxFlow)) {
                val = -maxFlow;
                warn.set(true);
            }
            return val;
        }).setScrollValues(1.0, 144.0, 1000.0).setFocusOnGuiOpen(true).setPos(0, 38).setSize(69, 12)).addFollower(new CoverDataFollowerNumericWidget(), coverData -> coverData.getTickRateForUi(), (coverData, state) -> coverData.setTickRateForUi(state.intValue()), widget -> widget.setBounds(0.0, 2048.0).setValidator(val -> {
            CoverFluidRegulator cover = (CoverFluidRegulator)this.getCover();
            int speed = cover != null ? cover.getSpeed() : 0;
            long transferRate = cover != null ? (long)cover.getTransferRate() : 0L;
            warn.set(false);
            if (val > 2048.0) {
                val = 2048.0;
                warn.set(true);
            } else if ((double)Math.abs(speed) > (double)transferRate * val) {
                val = Math.min(2048L, ((long)Math.abs(speed) + transferRate - 1L) / transferRate);
                warn.set(true);
            } else if (val < 1.0) {
                val = 1.0;
            }
            return val;
        }).setPos(90, 38).setSize(33, 12)).setPos(10, 25))).widget(new TextWidget(StatCollector.func_74838_a((String)"gt.interact.desc.fluid_regulator.ExpImp")).setPos(85, 29))).widget(new TextWidget(StatCollector.func_74838_a((String)"gt.interact.desc.fluid_regulator.Conditional")).setPos(85, 47))).widget(new TextWidget(StatCollector.func_74838_a((String)"gt.interact.desc.fluid_regulator.L")).setPos(82, 65))).widget(new TextWidget(StatCollector.func_74838_a((String)"gt.interact.desc.fluid_regulator.Ticks")).setPos(136, 65))).widget(new TextWidget().setTextSupplier(() -> {
            CoverFluidRegulator cover = (CoverFluidRegulator)this.getCover();
            if (cover == null) {
                return new Text("");
            }
            int tickRate = cover.getTickRateForUi();
            return new Text(StatCollector.func_74838_a((String)"gt.interact.desc.fluid_regulator.Average") + numberFormat.format(tickRate == 0 ? 0.0 : (double)cover.getSpeed() * 20.0 / (double)tickRate) + " " + StatCollector.func_74838_a((String)"gt.interact.desc.fluid_regulator.L_Sec")).color((warn.get() ? (Integer)this.COLOR_TEXT_WARN.get() : (Integer)this.COLOR_TEXT_GRAY.get()).intValue());
        }).setPos(10, 83));
    }

    static {
        numberFormat.setMaximumFractionDigits(2);
    }
}

