/*
 * Decompiled with CFR 0.152.
 */
package gregtech.client;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import gregtech.api.enums.Mods;
import gregtech.api.util.GTUtility;
import gregtech.common.config.Client;
import gregtech.common.data.GTPowerfailTracker;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.IIcon;
import net.minecraft.util.Vec3;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.event.world.WorldEvent;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.lwjgl.opengl.GL11;

public class GTPowerfailRenderer {
    public IIcon powerfailIcon;
    public final Long2ObjectOpenHashMap<GTPowerfailTracker.Powerfail> powerfails = new Long2ObjectOpenHashMap();

    @SubscribeEvent
    public void onTextureDiscover(TextureStitchEvent.Pre event) {
        if (event.map.func_130086_a() == 0) {
            this.powerfailIcon = event.map.func_94245_a(Mods.GregTech.getResourcePath("icons", "powerfail"));
        }
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload event) {
        if (event.world.field_72995_K) {
            this.powerfails.clear();
        }
    }

    @SubscribeEvent
    public void onRenderWorld(RenderWorldLastEvent event) {
        if (this.powerfails.isEmpty()) {
            return;
        }
        if (!Client.render.renderPowerfailNotifications) {
            return;
        }
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        Vec3 pos2 = player.func_70666_h(event.partialTicks);
        Vector3d pos = new Vector3d(pos2.field_72450_a, pos2.field_72448_b, pos2.field_72449_c);
        Vector3d temp = new Vector3d();
        tessellator.func_78373_b(0.0, 0.0, 0.0);
        long now = System.currentTimeMillis();
        for (GTPowerfailTracker.Powerfail p : this.powerfails.values()) {
            double z;
            double y;
            double x;
            double dist;
            long elapsed;
            if (Client.render.powerfailNotificationTimeout > 0 && (elapsed = now - p.lastOccurrence.getTime()) > (long)Client.render.powerfailNotificationTimeout * 1000L || player.field_71093_bK != p.dim || (dist = pos.distance(x = (double)p.x + 0.5, y = (double)p.y + 0.5, z = (double)p.z + 0.5)) < 4.0 || dist > 512.0) continue;
            double size = dist * 0.25;
            if (dist < 16.0) {
                size *= GTUtility.linearCurve(dist, 8.0, 0.0, 16.0, 1.0);
            }
            if (dist > 48.0) {
                size *= GTUtility.linearCurve(dist, 48.0, 1.0, 64.0, 0.25);
            }
            Plane plane = Plane.lookingAt(temp.set(x, y, z), pos);
            plane.get(0.5 * size, 0.5 * size, temp);
            tessellator.func_78374_a(temp.x, temp.y, temp.z, (double)this.powerfailIcon.func_94212_f(), (double)this.powerfailIcon.func_94210_h());
            plane.get(0.5 * size, -0.5 * size, temp);
            tessellator.func_78374_a(temp.x, temp.y, temp.z, (double)this.powerfailIcon.func_94212_f(), (double)this.powerfailIcon.func_94206_g());
            plane.get(-0.5 * size, -0.5 * size, temp);
            tessellator.func_78374_a(temp.x, temp.y, temp.z, (double)this.powerfailIcon.func_94209_e(), (double)this.powerfailIcon.func_94206_g());
            plane.get(-0.5 * size, 0.5 * size, temp);
            tessellator.func_78374_a(temp.x, temp.y, temp.z, (double)this.powerfailIcon.func_94209_e(), (double)this.powerfailIcon.func_94210_h());
        }
        GL11.glBindTexture((int)3553, (int)Minecraft.func_71410_x().func_147117_R().func_110552_b());
        GL11.glDisable((int)2929);
        GL11.glEnable((int)6406);
        tessellator.func_78381_a();
        GL11.glEnable((int)2929);
    }

    private static final class Plane {
        private final Vector3d centre;
        private final Vector3d s;
        private final Vector3d t;

        private Plane(Vector3d centre, Vector3d s, Vector3d t) {
            this.centre = centre;
            this.s = s;
            this.t = t;
        }

        public static Plane lookingAt(Vector3d centre, Vector3d pos) {
            Vector3d normal = new Vector3d();
            Vector3d relCentre = new Vector3d();
            relCentre.set((Vector3dc)centre).sub((Vector3dc)pos);
            relCentre.normalize(normal);
            double radians = Math.atan2(normal.x, normal.z) + 1.5707963267948966;
            Vector3d s = new Vector3d(0.0, 0.0, -1.0).rotateY(radians);
            Vector3d t = normal.cross((Vector3dc)s, new Vector3d());
            return new Plane(relCentre, s, t);
        }

        public void get(double sk, double tk, Vector3d dest) {
            dest.x = this.centre.x + this.s.x * sk + this.t.x * tk;
            dest.y = this.centre.y + this.s.y * sk + this.t.y * tk;
            dest.z = this.centre.z + this.s.z * sk + this.t.z * tk;
        }

        public String toString() {
            return "Plane[" + "centre=" + this.centre + "," + "s=" + this.s + "," + "t=" + this.t + "]";
        }

        public int hashCode() {
            int result = 0;
            result = 31 * result + (this.centre != null ? this.centre.hashCode() : 0);
            result = 31 * result + (this.s != null ? this.s.hashCode() : 0);
            result = 31 * result + (this.t != null ? this.t.hashCode() : 0);
            return result;
        }

        public final boolean equals(Object arg0) {
            if (this == arg0) {
                return true;
            }
            if (arg0 == null) {
                return false;
            }
            if (arg0.getClass() != this.getClass()) {
                return false;
            }
            if (!Objects.equals(((Plane)arg0).centre, this.centre)) {
                return false;
            }
            if (!Objects.equals(((Plane)arg0).s, this.s)) {
                return false;
            }
            return Objects.equals(((Plane)arg0).t, this.t);
            {
            }
        }

        public Vector3d centre() {
            return this.centre;
        }

        public Vector3d s() {
            return this.s;
        }

        public Vector3d t() {
            return this.t;
        }
    }
}

