/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util;

import bartworks.system.material.WerkstoffLoader;
import gregtech.api.enums.Materials;
import java.util.Arrays;
import java.util.List;
import net.minecraftforge.fluids.FluidStack;

public enum BlastFurnaceGasStat {
    Nitrogen(Materials.Nitrogen.getGas(1L), 1.0, 1.0),
    Helium(Materials.Helium.getGas(1L), 0.9, 1.0),
    Argon(Materials.Argon.getGas(1L), 0.8, 0.85),
    Radon(Materials.Radon.getGas(1L), 0.7, 0.7),
    Neon(WerkstoffLoader.Neon.getFluidOrGas(1), 0.6, 0.55),
    Krypton(WerkstoffLoader.Krypton.getFluidOrGas(1), 0.5, 0.4),
    Xenon(WerkstoffLoader.Xenon.getFluidOrGas(1), 0.4, 0.25),
    Oganesson(WerkstoffLoader.Oganesson.getFluidOrGas(1), 0.3, 0.1);

    public static final List<BlastFurnaceGasStat> BlastFurnaceGasStats;
    public final FluidStack gas;
    public final double recipeTimeMultiplier;
    public final double recipeConsumedAmountMultiplier;

    private BlastFurnaceGasStat(FluidStack gas, double recipeTimeMultiplier, double recipeConsumedAmountMultiplier) {
        this.gas = gas;
        this.recipeTimeMultiplier = recipeTimeMultiplier;
        this.recipeConsumedAmountMultiplier = recipeConsumedAmountMultiplier;
    }

    static {
        BlastFurnaceGasStats = Arrays.asList(Nitrogen, Helium, Argon, Radon, Neon, Krypton, Xenon, Oganesson);
    }
}

