/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.render;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.gtnewhorizons.angelica.api.IBlockAccessExtended;
import gregtech.api.enums.Mods;
import gregtech.api.interfaces.ITexture;
import gregtech.api.render.TextureFactory;
import gregtech.mixin.interfaces.accessors.ChunkCacheAccessor;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.jetbrains.annotations.NotNull;

public class RenderOverlay {
    private static final LoadingCache<World, RenderOverlay> instances = CacheBuilder.newBuilder().weakKeys().build((CacheLoader)new CacheLoader<World, RenderOverlay>(){

        public RenderOverlay load(World key) {
            return new RenderOverlay();
        }
    });
    private final Map<ChunkCoordinates, ITexture[]> overlays = new ConcurrentHashMap<ChunkCoordinates, ITexture[]>();
    private final ListMultimap<RenderLocation, OverlayTicket> ticketsByLocation = ArrayListMultimap.create();
    private final ListMultimap<ChunkCoordIntPair, OverlayTicket> byChunk = ArrayListMultimap.create();

    public OverlayTicket set(int xOwner, int yOwner, int zOwner, int x, int y, int z, ForgeDirection dir, ITexture texture, int zlevel) {
        ChunkCoordinates loc = new ChunkCoordinates(x, y, z);
        RenderLocation renderLoc = new RenderLocation(x, y, z, dir);
        ITexture[] holder = this.overlays.computeIfAbsent(loc, xx -> new ITexture[6]);
        OverlayTicket ticket = new OverlayTicket(xOwner, yOwner, zOwner, x, y, z, dir, texture, zlevel);
        this.ticketsByLocation.put((Object)renderLoc, (Object)ticket);
        holder[dir.ordinal()] = holder[dir.ordinal()] == null ? texture : this.getTextureArray(renderLoc);
        this.byChunk.put((Object)new ChunkCoordIntPair(xOwner >> 4, zOwner >> 4), (Object)ticket);
        return ticket;
    }

    private ITexture getTextureArray(RenderLocation renderLoc) {
        List tickets = this.ticketsByLocation.get((Object)renderLoc);
        if (tickets.isEmpty()) {
            return null;
        }
        return TextureFactory.of((ITexture[])tickets.stream().sorted().map(t -> t.texture).toArray(ITexture[]::new));
    }

    public ITexture[] get(int x, int y, int z) {
        return this.overlays.get(new ChunkCoordinates(x, y, z));
    }

    public void reset() {
        this.overlays.clear();
        this.byChunk.clear();
    }

    public static RenderOverlay getOrCreate(World world) {
        RenderOverlay instance = RenderOverlay.getRenderOverlay(world);
        if (instance == null) {
            instance = new RenderOverlay();
            instances.put((Object)world, (Object)instance);
        }
        return instance;
    }

    private static RenderOverlay getRenderOverlay(World world) {
        try {
            return (RenderOverlay)instances.get((Object)world);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public static ITexture[] get(IBlockAccess b, int x, int y, int z) {
        World world;
        if (b instanceof ChunkCacheAccessor) {
            ChunkCacheAccessor cache = (ChunkCacheAccessor)b;
            world = cache.getWorld();
        } else if (b instanceof World) {
            World w;
            world = w = (World)b;
        } else if (Mods.Angelica.isModLoaded() && b instanceof IBlockAccessExtended) {
            IBlockAccessExtended w = (IBlockAccessExtended)b;
            world = w.getWorld();
        } else {
            return null;
        }
        RenderOverlay instance = RenderOverlay.getRenderOverlay(world);
        if (instance == null) {
            return null;
        }
        return instance.get(x, y, z);
    }

    public static void set(World world, int xOwner, int yOwner, int zOwner, int x, int y, int z, ForgeDirection dir, ITexture texture, int zlevel) {
        RenderOverlay.getOrCreate(world).set(xOwner, yOwner, zOwner, x, y, z, dir, texture, zlevel);
    }

    public static void onWorldUnload(World world) {
        if (!world.field_72995_K) {
            return;
        }
        instances.invalidate((Object)world);
    }

    public static void onChunkUnload(World world, ChunkCoordIntPair chunk) {
        if (!world.field_72995_K) {
            return;
        }
        RenderOverlay inst = RenderOverlay.getRenderOverlay(world);
        if (inst == null) {
            return;
        }
        for (OverlayTicket loc : inst.byChunk.removeAll((Object)chunk)) {
            loc.remove();
        }
        if (inst.byChunk.isEmpty()) {
            instances.invalidate((Object)world);
        }
    }

    private static final class RenderLocation {
        final int x;
        final int y;
        final int z;
        final ForgeDirection dir;

        public RenderLocation(int x, int y, int z, ForgeDirection dir) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.dir = dir;
        }

        public boolean equals(Object o) {
            if (!(o instanceof RenderLocation)) {
                return false;
            }
            RenderLocation that = (RenderLocation)o;
            return this.x == that.x && this.y == that.y && this.z == that.z && this.dir == that.dir;
        }

        public int hashCode() {
            int result = this.x;
            result = 31 * result + this.y;
            result = 31 * result + this.z;
            result = 31 * result + this.dir.hashCode();
            return result;
        }
    }

    public final class OverlayTicket
    implements Comparable<OverlayTicket> {
        final int xOwner;
        final int yOwner;
        final int zOwner;
        final int x;
        final int y;
        final int z;
        final ForgeDirection dir;
        final ITexture texture;
        final int order;

        public OverlayTicket(int xOwner, int yOwner, int zOwner, int x, int y, int z, ForgeDirection dir, ITexture texture, int order) {
            this.xOwner = xOwner;
            this.yOwner = yOwner;
            this.zOwner = zOwner;
            this.x = x;
            this.y = y;
            this.z = z;
            this.dir = dir;
            this.texture = texture;
            this.order = order;
        }

        public void remove() {
            RenderLocation renderLoc = new RenderLocation(this.x, this.y, this.z, this.dir);
            if (!RenderOverlay.this.ticketsByLocation.remove((Object)renderLoc, (Object)this)) {
                return;
            }
            ChunkCoordinates loc = new ChunkCoordinates(this.x, this.y, this.z);
            ITexture[] container = (ITexture[])RenderOverlay.this.overlays.get(loc);
            if (container != null && container[this.dir.ordinal()] != null) {
                ITexture newArray;
                container[this.dir.ordinal()] = newArray = RenderOverlay.this.getTextureArray(renderLoc);
                if (newArray != null) {
                    return;
                }
                for (ITexture elem : container) {
                    if (elem == null) continue;
                    return;
                }
                RenderOverlay.this.overlays.remove(loc);
                RenderOverlay.this.byChunk.remove((Object)new ChunkCoordIntPair(this.xOwner >> 4, this.zOwner >> 4), (Object)loc);
            }
        }

        @Override
        public int compareTo(@NotNull OverlayTicket o) {
            return Integer.compare(this.order, o.order);
        }
    }
}

