/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.recipe.maps;

import gregtech.api.enums.GTValues;
import gregtech.api.recipe.RecipeMapBackend;
import gregtech.api.recipe.RecipeMapBackendPropertiesBuilder;
import gregtech.api.util.GTModHandler;
import gregtech.api.util.GTRecipe;
import gregtech.api.util.GTUtility;
import gregtech.api.util.MethodsReturnNonnullByDefault;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class LargeBoilerFuelBackend
extends RecipeMapBackend {
    private static boolean addedGeneralDesc = false;
    private static final List<String> ALLOWED_SOLID_FUELS = Arrays.asList("gregtech:gt.blockreinforced:6", "gregtech:gt.blockreinforced:7");

    public LargeBoilerFuelBackend(RecipeMapBackendPropertiesBuilder propertiesBuilder) {
        super(propertiesBuilder);
    }

    public static boolean isAllowedSolidFuel(ItemStack stack) {
        return LargeBoilerFuelBackend.isAllowedSolidFuel(Item.field_150901_e.func_148750_c((Object)stack.func_77973_b()), stack.func_77960_j());
    }

    public static boolean isAllowedSolidFuel(String itemRegistryName, int meta) {
        return ALLOWED_SOLID_FUELS.contains(itemRegistryName + ":" + meta);
    }

    public static boolean addAllowedSolidFuel(ItemStack stack) {
        return LargeBoilerFuelBackend.addAllowedSolidFuel(Item.field_150901_e.func_148750_c((Object)stack.func_77973_b()), stack.func_77960_j());
    }

    public static boolean addAllowedSolidFuel(String itemregistryName, int meta) {
        return ALLOWED_SOLID_FUELS.add(itemregistryName + ":" + meta);
    }

    public GTRecipe addDenseLiquidRecipe(GTRecipe recipe) {
        return this.addRecipe(recipe, (double)recipe.mSpecialValue / 10.0, true, false);
    }

    public GTRecipe addDieselRecipe(GTRecipe recipe) {
        return this.addRecipe(recipe, (double)recipe.mSpecialValue / 40.0, true, false);
    }

    public void addSolidRecipes(ItemStack ... itemStacks) {
        for (ItemStack itemStack : itemStacks) {
            this.addSolidRecipe(itemStack);
        }
    }

    @Nullable
    public GTRecipe addSolidRecipe(@Nullable ItemStack fuelItemStack) {
        if (fuelItemStack == null) {
            return null;
        }
        if (GTModHandler.getFuelValue(fuelItemStack) < 400) {
            return null;
        }
        if (!addedGeneralDesc) {
            GTValues.RA.stdBuilder().duration(1).eut(1).specialValue(1).setNEIDesc(GTUtility.breakLines(StatCollector.func_74837_a((String)"GT5U.nei.large_boiler.solid", (Object[])new Object[]{400, 1000}))).build().map(this::compileRecipe);
            addedGeneralDesc = true;
        }
        boolean isAllowedInSteelBoiler = GTModHandler.getFuelValue(fuelItemStack) >= 1000;
        String registryName = Item.field_150901_e.func_148750_c((Object)fuelItemStack.func_77973_b());
        boolean isHighTierAllowed = ALLOWED_SOLID_FUELS.contains(registryName + ":" + fuelItemStack.func_77960_j());
        return GTValues.RA.stdBuilder().itemInputs(fuelItemStack).duration(1).eut(0).specialValue(GTModHandler.getFuelValue(fuelItemStack) / 1600).build().map(r -> this.addRecipe((GTRecipe)r, (double)GTModHandler.getFuelValue(fuelItemStack) / 1600.0, isAllowedInSteelBoiler, isHighTierAllowed)).orElse(null);
    }

    private GTRecipe addRecipe(GTRecipe recipe, double baseBurnTime, boolean isAllowedInSteelBoiler, boolean isHighTierAllowed) {
        double floatErrorCorrection = 1.0E-4;
        double bronzeBurnTime = baseBurnTime * 2.0 + floatErrorCorrection;
        bronzeBurnTime -= bronzeBurnTime % 0.05;
        double steelBurnTime = baseBurnTime + floatErrorCorrection;
        steelBurnTime -= steelBurnTime % 0.05;
        double titaniumBurnTime = baseBurnTime * 0.3 + floatErrorCorrection;
        titaniumBurnTime -= titaniumBurnTime % 0.05;
        double tungstensteelBurnTime = baseBurnTime * 0.15 + floatErrorCorrection;
        tungstensteelBurnTime -= tungstensteelBurnTime % 0.05;
        recipe.setNeiDesc(StatCollector.func_74838_a((String)"GT5U.nei.large_boiler.burn_time"), StatCollector.func_74837_a((String)"GT5U.nei.large_boiler.bronze_boiler", (Object[])new Object[]{bronzeBurnTime}), isAllowedInSteelBoiler ? StatCollector.func_74837_a((String)"GT5U.nei.large_boiler.steel_boiler", (Object[])new Object[]{steelBurnTime}) : StatCollector.func_74838_a((String)"GT5U.nei.large_boiler.steel_boiler.ban"), isHighTierAllowed ? StatCollector.func_74837_a((String)"GT5U.nei.large_boiler.titanium_boiler", (Object[])new Object[]{titaniumBurnTime}) : StatCollector.func_74838_a((String)"GT5U.nei.large_boiler.titanium_boiler.ban"), isHighTierAllowed ? StatCollector.func_74837_a((String)"GT5U.nei.large_boiler.tungstensteel_boiler", (Object[])new Object[]{tungstensteelBurnTime}) : StatCollector.func_74838_a((String)"GT5U.nei.large_boiler.tungstensteel_boiler.ban"));
        return this.compileRecipe(recipe);
    }
}

