/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.recipe;

import gregtech.api.util.FieldsAreNonnullByDefault;
import gregtech.api.util.MethodsReturnNonnullByDefault;
import gregtech.nei.RecipeDisplayInfo;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.jetbrains.annotations.Contract;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
@FieldsAreNonnullByDefault
public abstract class RecipeMetadataKey<T> {
    private static final Set<RecipeMetadataKey<?>> allIdentifiers = new HashSet();
    private final Class<T> clazz;
    private final String identifier;

    protected RecipeMetadataKey(Class<T> clazz, String identifier) {
        this.clazz = clazz;
        this.identifier = identifier;
        if (allIdentifiers.contains(this)) {
            throw new IllegalArgumentException("Cannot register metadata key with exact same properties: " + identifier + "@" + clazz);
        }
        allIdentifiers.add(this);
    }

    public abstract void drawInfo(RecipeDisplayInfo var1, @Nullable Object var2);

    @Nullable
    public T cast(@Nullable Object o) {
        return this.clazz.cast(o);
    }

    @Nullable
    @Contract(value="_, !null -> !null")
    public T cast(@Nullable Object o, @Nullable T defaultValue) {
        T val = this.cast(o);
        return val != null ? val : defaultValue;
    }

    public String toString() {
        return "RecipeMetadataKey{clazz=" + this.clazz.getName() + ", identifier=" + this.identifier + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RecipeMetadataKey that = (RecipeMetadataKey)o;
        if (!this.clazz.equals(that.clazz)) {
            return false;
        }
        return this.identifier.equals(that.identifier);
    }

    public int hashCode() {
        int result = this.clazz.hashCode();
        result = 31 * result + this.identifier.hashCode();
        return result;
    }
}

