/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.modularui2;

import com.cleanroommc.modularui.api.ITheme;
import com.cleanroommc.modularui.api.IThemeApi;
import com.cleanroommc.modularui.screen.RichTooltip;
import com.cleanroommc.modularui.theme.ReloadThemeEvent;
import com.cleanroommc.modularui.utils.JsonArrayBuilder;
import com.cleanroommc.modularui.utils.JsonBuilder;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import gregtech.api.modularui2.GTGuiThemes;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraftforge.common.MinecraftForge;

public class GTGuiTheme {
    private static final List<GTGuiTheme> THEMES = new ArrayList<GTGuiTheme>();
    private final String themeId;
    private final List<Consumer<JsonBuilder>> elementBuilder;
    private final JsonBuilder jsonBuilder;

    private GTGuiTheme(String themeId) {
        this.themeId = themeId;
        this.jsonBuilder = new JsonBuilder();
        this.elementBuilder = new ArrayList<Consumer<JsonBuilder>>();
        THEMES.add(this);
    }

    public String getId() {
        return this.themeId;
    }

    public ITheme getMuiTheme() {
        return IThemeApi.get().getTheme(this.themeId);
    }

    private void register() {
        this.buildJson();
        IThemeApi.get().registerTheme(this.themeId, this.jsonBuilder);
    }

    private void buildJson() {
        this.elementBuilder.forEach(c -> c.accept(this.jsonBuilder));
    }

    public static void registerThemes() {
        MinecraftForge.EVENT_BUS.register((Object)new EventHandler());
        GTGuiThemes.init();
        THEMES.forEach(GTGuiTheme::register);
    }

    public static Builder builder(String themeId) {
        return new Builder(themeId);
    }

    public static class EventHandler {
        @SubscribeEvent
        public void onReloadThemes(ReloadThemeEvent.Pre event) {
            THEMES.forEach(rec$ -> ((GTGuiTheme)rec$).buildJson());
        }
    }

    public static class Builder {
        private final GTGuiTheme theme;
        private String itemSlotId;
        private int itemSlotHoverColor;
        private String fluidSlotId;
        private int fluidSlotHoverColor;

        private Builder(String themeId) {
            this.theme = new GTGuiTheme(themeId);
        }

        public Builder parent(GTGuiTheme parent) {
            return this.parent(parent.themeId);
        }

        public Builder parent(String parentId) {
            this.theme.elementBuilder.add(b -> b.add("parent", parentId));
            return this;
        }

        public Builder globalBackground(String backgroundId) {
            this.theme.elementBuilder.add(b -> b.add("background", backgroundId));
            return this;
        }

        public Builder globalHoverBackground(String hoverBackgroundId) {
            this.theme.elementBuilder.add(b -> b.add("hoverBackground", hoverBackgroundId));
            return this;
        }

        public Builder openCloseAnimation(int rate) {
            this.theme.elementBuilder.add(b -> b.add("openCloseAnimation", (Number)rate));
            return this;
        }

        public Builder smoothProgressBar(boolean smoothBar) {
            this.theme.elementBuilder.add(b -> b.add("smoothProgressBar", smoothBar));
            return this;
        }

        public Builder tooltipPos(RichTooltip.Pos tooltipPos) {
            this.theme.elementBuilder.add(b -> b.add("tooltipPos", tooltipPos.name()));
            return this;
        }

        public Builder color(int color) {
            this.theme.elementBuilder.add(b -> b.add("color", (Number)color));
            return this;
        }

        public Builder textColor(int textColor) {
            this.theme.elementBuilder.add(b -> b.add("textColor", (Number)textColor));
            return this;
        }

        public Builder textShadow() {
            this.theme.elementBuilder.add(b -> b.add("textShadow", true));
            return this;
        }

        public Builder panel(String panelId) {
            this.theme.elementBuilder.add(b -> b.add("panel", new JsonBuilder().add("background", new JsonBuilder().add("type", "texture").add("id", panelId))));
            return this;
        }

        public Builder button(String buttonId) {
            return this.button(buttonId, buttonId, -1, false);
        }

        public Builder button(String buttonId, String hoverId) {
            return this.button(buttonId, hoverId, -1, false);
        }

        public Builder button(String buttonId, String hoverId, int textColor, boolean textShadow) {
            this.theme.elementBuilder.add(b -> b.add("button", new JsonBuilder().add("background", new JsonBuilder().add("type", "texture").add("id", buttonId)).add("hoverBackground", new JsonBuilder().add("type", "texture").add("id", hoverId)).add("textColor", (Number)textColor).add("textShadow", textShadow)));
            return this;
        }

        public Builder itemSlot(String itemSlotId) {
            return this.itemSlot(itemSlotId, 0x60FFFFFF);
        }

        public Builder itemSlot(String itemSlotId, int hoverColor) {
            this.itemSlotId = itemSlotId;
            this.itemSlotHoverColor = hoverColor;
            this.theme.elementBuilder.add(b -> b.add("itemSlot", new JsonBuilder().add("background", new JsonBuilder().add("type", "texture").add("id", itemSlotId)).add("slotHoverColor", (Number)hoverColor)));
            return this;
        }

        public Builder fluidSlot(String fluidSlotId) {
            return this.fluidSlot(fluidSlotId, 0x60FFFFFF);
        }

        public Builder fluidSlot(String fluidSlotId, int hoverColor) {
            this.fluidSlotId = fluidSlotId;
            this.fluidSlotHoverColor = hoverColor;
            this.theme.elementBuilder.add(b -> b.add("fluidSlot", new JsonBuilder().add("background", new JsonBuilder().add("type", "texture").add("id", fluidSlotId)).add("slotHoverColor", (Number)hoverColor)));
            return this;
        }

        public Builder textField(int textColor) {
            return this.textField(textColor, -13667672);
        }

        public Builder textField(int textColor, int markedColor) {
            this.theme.elementBuilder.add(b -> b.add("textField", new JsonBuilder().add("textColor", (Number)textColor).add("markedColor", (Number)markedColor)));
            return this;
        }

        public Builder toggleButton(String backgroundId, String hoverBackgroundId, String selectedBackgroundId, String selectedHoverBackgroundId, int selectedColor) {
            return this.toggleButton(backgroundId, hoverBackgroundId, selectedBackgroundId, selectedHoverBackgroundId, selectedColor, -4473925, false);
        }

        public Builder toggleButton(String backgroundId, String hoverBackgroundId, String selectedBackgroundId, String selectedHoverBackgroundId, int selectedColor, int textColor, boolean textShadow) {
            this.theme.elementBuilder.add(b -> b.add("toggleButton", new JsonBuilder().add("background", new JsonBuilder().add("type", "texture").add("id", backgroundId)).add("hoverBackground", new JsonBuilder().add("type", "texture").add("id", hoverBackgroundId)).add("selectedBackground", new JsonBuilder().add("type", "texture").add("id", selectedBackgroundId)).add("selectedHoverBackground", new JsonBuilder().add("type", "texture").add("id", selectedHoverBackgroundId)).add("selectedColor", (Number)selectedColor).add("textColor", (Number)textColor).add("textShadow", textShadow)));
            return this;
        }

        public Builder simpleToggleButton(String backgroundId, String selectedBackgroundId, int selectedColor) {
            return this.simpleToggleButton(backgroundId, selectedBackgroundId, selectedColor, -4473925, false);
        }

        public Builder simpleToggleButton(String backgroundId, String selectedBackgroundId, int selectedColor, int textColor, boolean textShadow) {
            return this.toggleButton(backgroundId, backgroundId, selectedBackgroundId, selectedBackgroundId, selectedColor, textColor, textShadow);
        }

        public Builder customTextColor(String textType, int color) {
            this.theme.elementBuilder.add(b -> b.add(textType, new JsonBuilder().add("textColor", (Number)color)));
            return this;
        }

        public Builder themedTexture(String textureThemeId, String textureId) {
            this.theme.elementBuilder.add(b -> b.add(textureThemeId, new JsonBuilder().add("background", new JsonBuilder().add("type", "texture").add("id", textureId))));
            return this;
        }

        public Builder themedOverlayItemSlot(String textureThemeId, String textureId) {
            return this.themedOverlaySlot(textureThemeId, textureId, this.itemSlotId, this.itemSlotHoverColor, "itemSlot");
        }

        public Builder themedOverlayFluidSlot(String textureThemeId, String textureId) {
            return this.themedOverlaySlot(textureThemeId, textureId, this.fluidSlotId, this.fluidSlotHoverColor, "fluidSlot");
        }

        private Builder themedOverlaySlot(String textureThemeId, String textureId, String slotId, Integer hoverColor, String errorMessage) {
            this.theme.elementBuilder.add(b -> {
                if (slotId == null) {
                    throw new IllegalStateException(errorMessage + "must be specified for this method to work!");
                }
                b.add(textureThemeId, new JsonBuilder().add("background", new JsonArrayBuilder().add(new JsonBuilder().add("type", "texture").add("id", slotId)).add(new JsonBuilder().add("type", "texture").add("id", textureId))).add("slotHoverColor", (Number)hoverColor));
            });
            return this;
        }

        public Builder themedButton(String textureThemeId, String backgroundId) {
            return this.themedButton(textureThemeId, backgroundId, backgroundId);
        }

        public Builder themedButton(String textureThemeId, String backgroundId, String hoverBackgroundId) {
            this.theme.elementBuilder.add(b -> b.add(textureThemeId, new JsonBuilder().add("background", new JsonBuilder().add("type", "texture").add("id", backgroundId)).add("hoverBackground", new JsonBuilder().add("type", "texture").add("id", hoverBackgroundId))));
            return this;
        }

        public Builder progressbar(String textureThemeId, String wholeTextureId, int imageSize) {
            this.theme.elementBuilder.add(b -> b.add(textureThemeId, new JsonBuilder().add("wholeTexture", new JsonBuilder().add("type", "texture").add("id", wholeTextureId)).add("imageSize", (Number)imageSize)));
            return this;
        }

        public Builder progressbar(String textureThemeId, String emptyTextureId, String fullTextureId, int imageSize) {
            this.theme.elementBuilder.add(b -> b.add(textureThemeId, new JsonBuilder().add("emptyTexture", new JsonBuilder().add("type", "texture").add("id", emptyTextureId)).add("fullTexture", new JsonBuilder().add("type", "texture").add("id", fullTextureId)).add("imageSize", (Number)imageSize)));
            return this;
        }

        public GTGuiTheme build() {
            return this.theme;
        }
    }
}

