/*
 * Decompiled with CFR 0.152.
 */
package ggfab.mte;

import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import com.gtnewhorizons.modularui.api.drawable.Text;
import com.gtnewhorizons.modularui.api.math.Alignment;
import com.gtnewhorizons.modularui.api.widget.ISyncedWidget;
import com.gtnewhorizons.modularui.api.widget.IWidgetBuilder;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.widget.DynamicPositionedColumn;
import com.gtnewhorizons.modularui.common.widget.FakeSyncWidget;
import com.gtnewhorizons.modularui.common.widget.SlotWidget;
import com.gtnewhorizons.modularui.common.widget.TextWidget;
import ggfab.BlockIcons;
import ggfab.ConfigurationHandler;
import ggfab.mui.ClickableTextWidget;
import gregtech.GTMod;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.HatchElement;
import gregtech.api.enums.Textures;
import gregtech.api.enums.VoidingMode;
import gregtech.api.interfaces.IHatchElement;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.MTEExtendedPowerMultiBlockBase;
import gregtech.api.metatileentity.implementations.MTEHatch;
import gregtech.api.metatileentity.implementations.MTEHatchDataAccess;
import gregtech.api.metatileentity.implementations.MTEHatchInput;
import gregtech.api.metatileentity.implementations.MTEHatchInputBus;
import gregtech.api.metatileentity.implementations.MTEHatchMultiInput;
import gregtech.api.metatileentity.implementations.MTEMultiBlockBase;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.AssemblyLineUtils;
import gregtech.api.util.GTRecipe;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.GTUtility;
import gregtech.api.util.GTWaila;
import gregtech.api.util.IGTHatchAdder;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.api.util.OverclockCalculator;
import gregtech.api.util.VoidProtectionHelper;
import gregtech.api.util.shutdown.ShutDownReason;
import gregtech.api.util.shutdown.ShutDownReasonRegistry;
import gregtech.common.misc.GTStructureChannels;
import gregtech.common.tileentities.machines.MTEHatchInputBusME;
import gregtech.common.tileentities.machines.MTEHatchInputME;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.block.Block;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.util.StringUtils;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public class MTEAdvAssLine
extends MTEExtendedPowerMultiBlockBase<MTEAdvAssLine>
implements ISurvivalConstructable {
    public static final double LASER_OVERCLOCK_PENALTY_FACTOR = ConfigurationHandler.laserOCPenaltyFactor;
    private static final String STRUCTURE_PIECE_FIRST = "first";
    private static final String STRUCTURE_PIECE_LATER = "later";
    private static final String STRUCTURE_PIECE_LAST = "last";
    public static final String TAG_KEY_CURRENT_STICK = "mCurrentStick";
    public static final String TAG_KEY_CURRENT_RECIPE = "mCurrentRecipe";
    public static final String TAG_KEY_RECIPE_HASH = "mRecipeHash";
    public static final String TAG_KEY_PROGRESS_TIMES = "mProgressTimeArray";
    private static final IStructureDefinition<MTEAdvAssLine> STRUCTURE_DEFINITION = StructureDefinition.builder().addShape("first", StructureUtility.transpose((String[][])new String[][]{{" ", "e", " "}, {"~", "l", "G"}, {"g", "m", "g"}, {"b", "i", "b"}})).addShape("later", StructureUtility.transpose((String[][])new String[][]{{" ", "e", " "}, {"d", "l", "d"}, {"g", "m", "g"}, {"b", "I", "b"}})).addShape("last", StructureUtility.transpose((String[][])new String[][]{{" ", "e", " "}, {"d", "l", "d"}, {"g", "m", "g"}, {"o", "i", "b"}})).addElement('G', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings3, (int)10)).addElement('l', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings2, (int)9)).addElement('m', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings2, (int)5)).addElement('g', GTStructureUtility.chainAllGlasses()).addElement('e', GTStructureUtility.buildHatchAdder(MTEAdvAssLine.class).anyOf(HatchElement.Energy, HatchElement.ExoticEnergy).dot(1).casingIndex(16).allowOnly(ForgeDirection.UP, ForgeDirection.NORTH, ForgeDirection.SOUTH).buildAndChain(StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings2, (int)0))).addElement('d', GTStructureUtility.buildHatchAdder(MTEAdvAssLine.class).atLeast(DataHatchElement.DataAccess).dot(2).casingIndex(42).allowOnly(ForgeDirection.NORTH).buildAndChain(GregTechAPI.sBlockCasings3, 10)).addElement('b', GTStructureUtility.buildHatchAdder(MTEAdvAssLine.class).atLeast(HatchElement.InputHatch, HatchElement.InputHatch, HatchElement.InputHatch, HatchElement.InputHatch, HatchElement.Maintenance).casingIndex(16).dot(3).allowOnly(ForgeDirection.DOWN).buildAndChain(new IStructureElement[]{StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings2, (int)0), GTStructureUtility.ofHatchAdder(MTEMultiBlockBase::addOutputToMachineList, 16, 4)})).addElement('I', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{HatchElement.InputBus.newAny(16, 4, ForgeDirection.DOWN), GTStructureUtility.ofHatchAdder(MTEMultiBlockBase::addOutputToMachineList, 16, 3)})).addElement('i', HatchElement.InputBus.newAny(16, 4, ForgeDirection.DOWN)).addElement('o', HatchElement.OutputBus.newAny(16, 3, ForgeDirection.DOWN)).build();
    private GTRecipe.RecipeAssemblyLine currentRecipe;
    private final Slice[] slices = (Slice[])IntStream.range(0, 16).mapToObj(x$0 -> new Slice(x$0)).toArray(Slice[]::new);
    private boolean processing;
    private long inputVoltage;
    private long inputEUt;
    private long baseEUt;
    private boolean stuck;
    private final List<MTEHatchDataAccess> mDataAccessHatches = new ArrayList<MTEHatchDataAccess>();
    private Map<GTUtility.ItemId, ItemStack> curBatchItemsFromME;
    private Map<Fluid, FluidStack> curBatchFluidsFromME;
    private int currentInputLength;
    private String lastStopReason = "";
    private int currentRecipeParallel = 1;

    public MTEAdvAssLine(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public MTEAdvAssLine(String aName) {
        super(aName);
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTEAdvAssLine(this.mName);
    }

    public boolean addDataAccessToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            return false;
        }
        if (aMetaTileEntity instanceof MTEHatchDataAccess) {
            ((MTEHatch)aMetaTileEntity).updateTexture(aBaseCasingIndex);
            return this.mDataAccessHatches.add((MTEHatchDataAccess)aMetaTileEntity);
        }
        return false;
    }

    private boolean checkMachine() {
        this.mDataAccessHatches.clear();
        if (!this.checkPiece(STRUCTURE_PIECE_FIRST, 0, 1, 0)) {
            return false;
        }
        return this.checkMachine(true) || this.checkMachine(false);
    }

    private boolean checkMachine(boolean leftToRight) {
        for (int i = 1; i < 16; ++i) {
            if (!this.checkPiece(STRUCTURE_PIECE_LATER, leftToRight ? -i : i, 1, 0)) {
                return false;
            }
            if (this.mOutputBusses.isEmpty()) continue;
            return (!this.mEnergyHatches.isEmpty() || !this.mExoticEnergyHatches.isEmpty()) && this.mMaintenanceHatches.size() == 1 && this.mDataAccessHatches.size() <= 1;
        }
        return false;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(STRUCTURE_PIECE_FIRST, stackSize, hintsOnly, 0, 1, 0);
        int tLength = GTStructureChannels.STRUCTURE_LENGTH.getValueClamped(stackSize, 5, 16);
        for (int i = 1; i < tLength; ++i) {
            this.buildPiece(STRUCTURE_PIECE_LATER, stackSize, hintsOnly, -i, 1, 0);
        }
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        int build = this.survivalBuildPiece(STRUCTURE_PIECE_FIRST, stackSize, 0, 1, 0, elementBudget, env, false, true);
        if (build >= 0) {
            return build;
        }
        int tLength = GTStructureChannels.STRUCTURE_LENGTH.getValueClamped(stackSize, 5, 16);
        for (int i = 1; i < tLength; ++i) {
            build = this.survivalBuildPiece(STRUCTURE_PIECE_LATER, stackSize, -i, 1, 0, elementBudget, env, false, true);
            if (build < 0) continue;
            return build;
        }
        return this.survivalBuildPiece(STRUCTURE_PIECE_LAST, stackSize, 1 - tLength, 1, 0, elementBudget, env, false, true);
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int colorIndex, boolean aActive, boolean aRedstone) {
        if (side == facing) {
            if (this.stuck) {
                return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][16], TextureFactory.builder().addIcon((IIconContainer)BlockIcons.OVERLAY_FRONT_ADV_ASSLINE_STUCK).extFacing().build(), TextureFactory.builder().addIcon((IIconContainer)BlockIcons.OVERLAY_FRONT_ADV_ASSLINE_STUCK_GLOW).extFacing().glow().build()};
            }
            if (aActive) {
                return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][16], TextureFactory.builder().addIcon((IIconContainer)BlockIcons.OVERLAY_FRONT_ADV_ASSLINE_ACTIVE).extFacing().build(), TextureFactory.builder().addIcon((IIconContainer)BlockIcons.OVERLAY_FRONT_ADV_ASSLINE_ACTIVE_GLOW).extFacing().glow().build()};
            }
            return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][16], TextureFactory.builder().addIcon((IIconContainer)BlockIcons.OVERLAY_FRONT_ADV_ASSLINE).extFacing().build(), TextureFactory.builder().addIcon((IIconContainer)BlockIcons.OVERLAY_FRONT_ADV_ASSLINE_GLOW).extFacing().glow().build()};
        }
        return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][16]};
    }

    @Override
    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType("Assembly Line, AAL").addInfo("Assembly Line with item pipelining").addInfo("All fluids are consumed at the start of the recipe").addInfo("Recipe tier is limited by the lowest Energy Hatch tier").addSeparator(EnumChatFormatting.GOLD, 67).addInfo("Runs imperfect overclocks until Energy Hatch tier").addInfo("Additional overclocks are increasingly more expensive").addInfo(EnumChatFormatting.AQUA + "Multiplier = 4^(Regular Overclocks) \u00d7 4.3 \u00d7 4.6 \u00d7 \u2026 \u00d7 (4 + 0.3 \u00d7 Extra Overclocks)" + EnumChatFormatting.GRAY).addInfo(EnumChatFormatting.AQUA + "Power usage = Multiplier \u00d7 (Active Slices) \u00d7 (Recipe EU/t)" + EnumChatFormatting.GRAY).addInfo("Overclocking assumes all recipe slices are active").addInfo(EnumChatFormatting.BOLD + "Does not overclock beyond 1 tick").addSeparator(EnumChatFormatting.GOLD, 67).addInfo("Constructed identically to the Assembly Line").addTecTechHatchInfo().beginVariableStructureBlock(5, 16, 4, 4, 3, 3, false).addStructureInfo("From Bottom to Top, Left to Right").addStructureInfo("Layer 1 - Solid Steel Machine Casing, Input Bus, Solid Steel Machine Casing").addStructureInfo("Layer 2 - Glass, Assembly Line Casing, Glass").addStructureInfo("Layer 3 - Grate Machine Casing, Assembler Machine Casing, Grate Machine Casing").addStructureInfo("Layer 4 - Empty, Solid Steel Machine Casing, Empty").addStructureInfo("Up to 16 repeating slices, each one allows for 1 more item in recipes").addController("Either Grate on layer 3 of the first slice").addEnergyHatch("Any layer 4 casing", 1).addMaintenanceHatch("Any layer 1 casing", 3).addInputBus("As specified on layer 1", 4).addInputHatch("Any layer 1 casing", 3).addOutputBus("Replaces Input Bus or Solid Steel Machine casing on layer 1 of last slice", 3).addOtherStructurePart(StatCollector.func_74838_a((String)"GT5U.tooltip.structure.data_access_hatch"), "Any Grate Machine Casing NOT on the first slice", 2).addSubChannelUsage(GTStructureChannels.BOROGLASS).toolTipFinisher(EnumChatFormatting.GRAY, 67, new String[0]);
        return tt;
    }

    private void setCurrentRecipe(GTRecipe.RecipeAssemblyLine recipe) {
        this.currentRecipe = recipe;
        this.currentInputLength = recipe.mInputs.length;
    }

    private void clearCurrentRecipe() {
        this.currentRecipe = null;
        this.currentInputLength = -1;
        this.currentRecipeParallel = 1;
        this.stuck = false;
        this.baseEUt = 0L;
        for (Slice slice : this.slices) {
            slice.reset();
        }
        this.mMaxProgresstime = 0;
        this.getBaseMetaTileEntity().issueClientUpdate();
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74778_a("lastStop", this.lastStopReason);
        if (this.getBaseMetaTileEntity().isActive() && this.currentRecipe != null) {
            aNBT.func_74782_a(TAG_KEY_CURRENT_RECIPE, (NBTBase)AssemblyLineUtils.saveRecipe(this.currentRecipe));
            aNBT.func_74768_a(TAG_KEY_RECIPE_HASH, this.currentRecipe.getPersistentHash());
            aNBT.func_74783_a(TAG_KEY_PROGRESS_TIMES, Arrays.stream(this.slices).limit(this.currentInputLength).mapToInt(s -> ((Slice)s).progress).toArray());
            aNBT.func_74757_a("stuck", this.stuck);
            aNBT.func_74772_a("inputV", this.inputVoltage);
            aNBT.func_74772_a("inputEU", this.inputEUt);
            aNBT.func_74772_a("baseEU", this.baseEUt);
            aNBT.func_74768_a("currentParallel", this.currentRecipeParallel);
        }
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.lastStopReason = aNBT.func_74779_i("lastStop");
        if (aNBT.func_150297_b(TAG_KEY_PROGRESS_TIMES, 11)) {
            int[] arr = aNBT.func_74759_k(TAG_KEY_PROGRESS_TIMES);
            for (int i = 0; i < this.slices.length; ++i) {
                if (i < arr.length) {
                    this.slices[i].progress = arr[i];
                    if (arr[i] != 0) continue;
                    this.stuck = true;
                    continue;
                }
                this.slices[i].reset();
            }
        }
        GTRecipe.RecipeAssemblyLine recipe = null;
        if (aNBT.func_150297_b(TAG_KEY_CURRENT_RECIPE, 10)) {
            recipe = AssemblyLineUtils.assertSingleRecipe(AssemblyLineUtils.loadRecipe(aNBT.func_74775_l(TAG_KEY_CURRENT_RECIPE)));
        } else if (aNBT.func_150297_b(TAG_KEY_CURRENT_STICK, 10)) {
            recipe = AssemblyLineUtils.assertSingleRecipe(AssemblyLineUtils.findALRecipeFromDataStick(ItemStack.func_77949_a((NBTTagCompound)aNBT.func_74775_l(TAG_KEY_CURRENT_STICK))));
        }
        if (recipe != null) {
            this.stuck = aNBT.func_74767_n("stuck");
            this.inputVoltage = aNBT.func_74763_f("inputV");
            this.inputEUt = aNBT.func_74763_f("inputEU");
            this.baseEUt = aNBT.func_74763_f("baseEU");
            this.currentRecipeParallel = aNBT.func_74762_e("currentParallel");
            if (this.inputVoltage <= 0L || this.inputEUt <= 0L || this.baseEUt >= 0L) {
                this.criticalStopMachine("ggfab.gui.advassline.shutdown.load.energy");
                recipe = null;
            }
            if (recipe != null && aNBT.func_150297_b(TAG_KEY_RECIPE_HASH, 3) && aNBT.func_74762_e(TAG_KEY_RECIPE_HASH) != recipe.getPersistentHash()) {
                this.criticalStopMachine("ggfab.gui.advassline.shutdown.load.recipe");
                recipe = null;
            }
        }
        if (recipe == null) {
            this.clearCurrentRecipe();
        } else {
            this.setCurrentRecipe(recipe);
        }
    }

    private void criticalStopMachine(String reason) {
        int oMaxProgresstime = this.mMaxProgresstime;
        this.stopMachine(ShutDownReasonRegistry.NONE);
        if (oMaxProgresstime > 0) {
            if (this.getBaseMetaTileEntity().getWorld() != null) {
                this.sendSound((byte)8);
            }
            this.getBaseMetaTileEntity().setShutdownStatus(true);
            this.lastStopReason = reason;
        }
    }

    @Override
    public IStructureDefinition<MTEAdvAssLine> getStructureDefinition() {
        return STRUCTURE_DEFINITION;
    }

    @Override
    public void clearHatches() {
        super.clearHatches();
        this.mExoticEnergyHatches.clear();
        this.mDataAccessHatches.clear();
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        if (!(!this.checkMachine() || this.mEnergyHatches.isEmpty() && this.mExoticEnergyHatches.isEmpty())) {
            long oV = this.inputVoltage;
            long oEut = this.inputEUt;
            this.inputVoltage = Integer.MAX_VALUE;
            this.inputEUt = 0L;
            this.mEnergyHatches.forEach(this::recordEnergySupplier);
            this.mExoticEnergyHatches.forEach(this::recordEnergySupplier);
            if (this.mMaxProgresstime > 0 && (oV != this.inputVoltage || oEut != this.inputEUt)) {
                this.criticalStopMachine("ggfab.gui.advassline.shutdown.structure");
            }
            return true;
        }
        this.inputVoltage = GTValues.V[0];
        return false;
    }

    private void recordEnergySupplier(MTEHatch hatch) {
        if (!hatch.isValid()) {
            return;
        }
        this.inputEUt += hatch.maxEUInput() * hatch.maxWorkingAmperesIn();
        this.inputVoltage = Math.min(this.inputVoltage, hatch.maxEUInput());
        if (this.inputEUt < 0L) {
            this.inputEUt = Long.MAX_VALUE;
        }
    }

    @Override
    public void startRecipeProcessing() {
        if (!this.processing) {
            super.startRecipeProcessing();
            this.curBatchItemsFromME = this.getStoredInputsFromME();
            this.curBatchFluidsFromME = this.getStoredFluidsFromME();
            this.processing = true;
        }
    }

    @Override
    public void endRecipeProcessing() {
        if (!this.processing) {
            return;
        }
        super.endRecipeProcessing();
        this.processing = false;
    }

    @Override
    public void onValueUpdate(byte aValue) {
        boolean oStuck = this.stuck;
        boolean bl = this.stuck = (aValue & 1) == 1;
        if (oStuck != this.stuck) {
            this.getBaseMetaTileEntity().issueTextureUpdate();
        }
    }

    @Override
    public byte getUpdateData() {
        return (byte)(this.stuck ? 1 : 0);
    }

    @Override
    protected void drawTexts(DynamicPositionedColumn screenElements, SlotWidget inventorySlot) {
        super.drawTexts(screenElements, inventorySlot);
        screenElements.widget(new TextWidget(Text.localised((String)"ggfab.gui.advassline.shutdown", (Object[])new Object[0])).setTextAlignment(Alignment.CenterLeft).setEnabled(this::hasAbnormalStopReason));
        screenElements.widget(new TextWidget().setTextSupplier(() -> Text.localised((String)this.lastStopReason, (Object[])new Object[0])).setTextAlignment(Alignment.CenterLeft).attachSyncer((FakeSyncWidget)new FakeSyncWidget.StringSyncer(() -> this.lastStopReason, r -> {
            this.lastStopReason = r;
        }), (IWidgetBuilder)screenElements).setEnabled(this::hasAbnormalStopReason));
        screenElements.widget(new ClickableTextWidget(Text.localised((String)"ggfab.gui.advassline.shutdown_clear", (Object[])new Object[0]).alignment(Alignment.CenterLeft)).setMarginInLines(0).setOnClick((d, w) -> {
            this.lastStopReason = "";
        }).setSize(36, 20).setEnabled(this::hasAbnormalStopReason));
    }

    private Boolean hasAbnormalStopReason(Widget w) {
        return !StringUtils.func_151246_b((String)this.lastStopReason);
    }

    @Override
    public RecipeMap<?> getRecipeMap() {
        return RecipeMaps.assemblylineVisualRecipes;
    }

    @Override
    public boolean onRunningTick(ItemStack aStack) {
        if (this.currentRecipe == null) {
            this.criticalStopMachine("ggfab.gui.advassline.shutdown.recipe_null");
            return false;
        }
        for (MTEHatchDataAccess hatch_dataAccess : this.mDataAccessHatches) {
            hatch_dataAccess.setActive(true);
        }
        if (this.mInputBusses.size() < this.currentInputLength) {
            this.criticalStopMachine("ggfab.gui.advassline.shutdown.input_busses");
            return false;
        }
        boolean oStuck = this.stuck;
        this.stuck = false;
        for (int i = this.slices.length - 1; i >= 0; --i) {
            this.slices[i].tick();
        }
        if (oStuck != this.stuck) {
            this.getBaseMetaTileEntity().issueClientUpdate();
        }
        if (this.getBaseMetaTileEntity().isAllowedToWork() && this.slices[0].progress < 0) {
            this.startRecipeProcessing();
            if (this.hasAllItems(this.currentRecipe, this.currentRecipeParallel) && this.hasAllFluids(this.currentRecipe, this.currentRecipeParallel) && this.slices[0].start()) {
                this.drainAllFluids(this.currentRecipe, this.currentRecipeParallel);
                this.mProgresstime = 0;
            }
        }
        this.endRecipeProcessing();
        boolean foundWorking = false;
        int working = 0;
        for (Slice slice : this.slices) {
            if (slice.progress >= 0 && !foundWorking) {
                foundWorking = true;
                this.mProgresstime = (slice.id + 1) * (this.mMaxProgresstime / this.currentInputLength) - slice.progress;
            }
            if (slice.progress <= 0) continue;
            ++working;
        }
        this.lEUt = (long)working * this.baseEUt;
        if (this.lEUt > 0L) {
            this.lEUt = Long.MIN_VALUE;
            for (int i = 0; i < working; ++i) {
                if (this.drainEnergyInput(-this.baseEUt)) continue;
                this.criticalStopMachine("ggfab.gui.advassline.shutdown.energy");
                return false;
            }
        } else {
            return super.onRunningTick(aStack);
        }
        return true;
    }

    private ItemStack getInputBusContent(int index) {
        if (index < 0 || index >= this.mInputBusses.size()) {
            return null;
        }
        MTEHatchInputBus inputBus = (MTEHatchInputBus)this.mInputBusses.get(index);
        if (!inputBus.isValid()) {
            return null;
        }
        if (inputBus instanceof MTEHatchInputBusME) {
            MTEHatchInputBusME meBus = (MTEHatchInputBusME)inputBus;
            ItemStack item = meBus.getFirstShadowItemStack(true);
            if (item == null) {
                return null;
            }
            GTUtility.ItemId id = GTUtility.ItemId.createNoCopy(item);
            if (!this.curBatchItemsFromME.containsKey(id)) {
                return null;
            }
            return this.curBatchItemsFromME.get(id);
        }
        return inputBus.getFirstStack();
    }

    private FluidStack getInputHatchContent(int index) {
        if (index < 0 || index >= this.mInputHatches.size()) {
            return null;
        }
        MTEHatchInput inputHatch = (MTEHatchInput)this.mInputHatches.get(index);
        if (!inputHatch.isValid()) {
            return null;
        }
        if (inputHatch instanceof MTEHatchInputME) {
            MTEHatchInputME meHatch = (MTEHatchInputME)inputHatch;
            FluidStack fluid = meHatch.getFirstShadowFluidStack(true);
            if (fluid == null) {
                return null;
            }
            if (!this.curBatchFluidsFromME.containsKey(fluid.getFluid())) {
                return null;
            }
            return this.curBatchFluidsFromME.get(fluid.getFluid());
        }
        if (inputHatch instanceof MTEHatchMultiInput) {
            MTEHatchMultiInput multiHatch = (MTEHatchMultiInput)inputHatch;
            return multiHatch.getFluid();
        }
        return inputHatch.getFillableStack();
    }

    private int maxParallelCalculatedByInputItems(GTRecipe.RecipeAssemblyLine tRecipe, int maxParallel) {
        int aItemCount = tRecipe.mInputs.length;
        if (this.mInputBusses.size() < aItemCount) {
            return 0;
        }
        int[] itemConsumptions = GTRecipe.RecipeAssemblyLine.getItemConsumptionAmountArray(this.mInputBusses, tRecipe);
        if (itemConsumptions == null || itemConsumptions.length == 0) {
            return 0;
        }
        return (int)GTRecipe.RecipeAssemblyLine.maxParallelCalculatedByInputItems(this.mInputBusses, maxParallel, itemConsumptions, this.curBatchItemsFromME);
    }

    private int maxParallelCalculatedByInputFluids(GTRecipe.RecipeAssemblyLine tRecipe, int maxParallel) {
        int aFluidCount = tRecipe.mFluidInputs.length;
        if (this.mInputHatches.size() < aFluidCount) {
            return 0;
        }
        return (int)GTRecipe.RecipeAssemblyLine.maxParallelCalculatedByInputFluids(this.mInputHatches, maxParallel, tRecipe.mFluidInputs, this.curBatchFluidsFromME);
    }

    private boolean hasAllItems(GTRecipe.RecipeAssemblyLine tRecipe, int parallel) {
        return this.maxParallelCalculatedByInputItems(tRecipe, parallel) >= parallel;
    }

    private boolean hasAllFluids(GTRecipe.RecipeAssemblyLine tRecipe, int parallel) {
        return this.maxParallelCalculatedByInputFluids(tRecipe, parallel) >= parallel;
    }

    @Override
    @Nonnull
    public CheckRecipeResult checkProcessing() {
        if (GTValues.D1) {
            GTMod.GT_FML_LOGGER.info("Start Adv ALine recipe check");
        }
        this.clearCurrentRecipe();
        CheckRecipeResult result = CheckRecipeResultRegistry.NO_DATA_STICKS;
        ArrayList<GTRecipe.RecipeAssemblyLine> availableRecipes = new ArrayList<GTRecipe.RecipeAssemblyLine>();
        if (AssemblyLineUtils.isItemDataStick(this.mInventory[1])) {
            availableRecipes.addAll(AssemblyLineUtils.findALRecipeFromDataStick(this.mInventory[1]));
        }
        for (MTEHatchDataAccess dataAccess : GTUtility.validMTEList(this.mDataAccessHatches)) {
            availableRecipes.addAll(dataAccess.getAssemblyLineRecipes());
        }
        if (availableRecipes.isEmpty()) {
            return result;
        }
        if (GTValues.D1) {
            GTMod.GT_FML_LOGGER.info("Stick accepted, " + availableRecipes.size() + " Data Sticks found");
        }
        for (GTRecipe.RecipeAssemblyLine recipe : availableRecipes) {
            FluidStack firstFluidSlot;
            int originalMaxParallel;
            if (!this.hasAllItems(recipe, 1)) {
                if (result != CheckRecipeResultRegistry.NO_DATA_STICKS) continue;
                result = CheckRecipeResultRegistry.NO_RECIPE;
                continue;
            }
            if (!this.hasAllFluids(recipe, 1)) {
                if (result != CheckRecipeResultRegistry.NO_DATA_STICKS) continue;
                result = CheckRecipeResultRegistry.NO_RECIPE;
                continue;
            }
            if ((long)recipe.mEUt > this.inputVoltage) {
                result = CheckRecipeResultRegistry.insufficientVoltage(recipe.mEUt);
                continue;
            }
            if ((long)recipe.mInputs.length * (long)recipe.mEUt > this.inputEUt) {
                result = CheckRecipeResultRegistry.insufficientPower((long)recipe.mInputs.length * (long)recipe.mEUt);
                continue;
            }
            int maxParallel = originalMaxParallel = 1;
            int maxRegularOverclock = GTUtility.getTier(this.inputVoltage) - GTUtility.getTier(recipe.mEUt);
            int maxOverclockTo1Tick = GTUtility.log2(recipe.mDuration / recipe.mInputs.length);
            OverclockCalculator calculator = new OverclockCalculator().setRecipeEUt(recipe.mEUt).setDurationUnderOneTickSupplier(() -> (double)recipe.mDuration / (double)recipe.mInputs.length).setParallel(originalMaxParallel).setEUt(this.inputEUt / (long)recipe.mInputs.length).setLaserOC(true).setMaxRegularOverclocks(Math.min(maxRegularOverclock, maxOverclockTo1Tick));
            int maxParallelBeforeBatchMode = maxParallel;
            if (this.isBatchModeEnabled()) {
                maxParallel = GTUtility.safeInt((long)maxParallel * (long)this.getMaxBatchSize(), 0);
            }
            if (this.protectsExcessItem()) {
                VoidProtectionHelper voidProtectionHelper = new VoidProtectionHelper();
                voidProtectionHelper.setMachine(this).setItemOutputs(new ItemStack[]{recipe.mOutput}).setMaxParallel(maxParallel).build();
                maxParallel = Math.min(voidProtectionHelper.getMaxParallel(), maxParallel);
                if (voidProtectionHelper.isItemFull()) {
                    result = CheckRecipeResultRegistry.ITEM_OUTPUT_FULL;
                    continue;
                }
            }
            if ((firstFluidSlot = this.getInputHatchContent(0)) == null) {
                result = CheckRecipeResultRegistry.INTERNAL_ERROR;
                break;
            }
            int currentParallel = firstFluidSlot.amount / recipe.mFluidInputs[0].amount;
            if (this.isBatchModeEnabled()) {
                currentParallel /= recipe.mInputs.length;
            }
            currentParallel = Math.min(currentParallel, maxParallel);
            currentParallel = Math.max(currentParallel, 1);
            currentParallel = Math.min(currentParallel, this.maxParallelCalculatedByInputItems(recipe, currentParallel));
            if ((currentParallel = Math.min(currentParallel, this.maxParallelCalculatedByInputFluids(recipe, currentParallel))) <= 0) {
                result = CheckRecipeResultRegistry.INTERNAL_ERROR;
                continue;
            }
            int currentParallelBeforeBatchMode = Math.min(currentParallel, maxParallelBeforeBatchMode);
            calculator.setCurrentParallel(currentParallelBeforeBatchMode).calculate();
            double batchMultiplierMax = 1.0;
            if (currentParallel > maxParallelBeforeBatchMode && calculator.getDuration() < this.getMaxBatchSize()) {
                batchMultiplierMax = (double)this.getMaxBatchSize() / (double)calculator.getDuration();
                batchMultiplierMax = Math.min(batchMultiplierMax, (double)currentParallel / (double)maxParallelBeforeBatchMode);
            }
            int batchMultiplierMaxInt = (int)batchMultiplierMax;
            this.currentRecipeParallel = currentParallelBeforeBatchMode * batchMultiplierMaxInt;
            this.lEUt = calculator.getConsumption();
            this.mMaxProgresstime = calculator.getDuration() * batchMultiplierMaxInt * recipe.mInputs.length;
            this.setCurrentRecipe(recipe);
            result = CheckRecipeResultRegistry.SUCCESSFUL;
            break;
        }
        if (!result.wasSuccessful()) {
            this.clearCurrentRecipe();
            return result;
        }
        if (this.currentRecipe == null || !this.slices[0].start() || this.currentRecipeParallel <= 0) {
            this.clearCurrentRecipe();
            return CheckRecipeResultRegistry.INTERNAL_ERROR;
        }
        if (GTValues.D1) {
            GTMod.GT_FML_LOGGER.info("All checked start consuming inputs");
        }
        this.drainAllFluids(this.currentRecipe, this.currentRecipeParallel);
        this.mOutputItems = new ItemStack[]{this.currentRecipe.mOutput.func_77946_l()};
        this.mOutputItems[0].field_77994_a *= this.currentRecipeParallel;
        if (this.lEUt > 0L) {
            this.lEUt = -this.lEUt;
        }
        this.baseEUt = this.lEUt;
        this.mEfficiency = 10000 - (this.getIdealStatus() - this.getRepairStatus()) * 1000;
        this.mEfficiencyIncrease = 10000;
        if (GTValues.D1) {
            GTMod.GT_FML_LOGGER.info("Recipe successful");
        }
        return CheckRecipeResultRegistry.SUCCESSFUL;
    }

    @Override
    public boolean supportsVoidProtection() {
        return true;
    }

    @Override
    public Set<VoidingMode> getAllowedVoidingModes() {
        return VoidingMode.ITEM_ONLY_MODES;
    }

    @Override
    protected boolean supportsSlotAutomation(int aSlot) {
        return aSlot == this.getControllerSlotIndex();
    }

    @Override
    public void getWailaBody(ItemStack itemStack, List<String> currentTip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        super.getWailaBody(itemStack, currentTip, accessor, config);
        NBTTagCompound tag = accessor.getNBTData();
        String machineProgressString = GTWaila.getMachineProgressString(tag.func_74767_n("isActive"), tag.func_74767_n("isAllowedToWork"), tag.func_74762_e("maxProgress"), tag.func_74762_e("progress"));
        currentTip.remove(machineProgressString);
        int duration = tag.func_74762_e("mDuration");
        if (tag.func_150297_b(TAG_KEY_PROGRESS_TIMES, 9)) {
            NBTTagList tl = tag.func_150295_c(TAG_KEY_PROGRESS_TIMES, 3);
            List list = tl.field_74747_a;
            int listSize = list.size();
            for (int i = 0; i < listSize; ++i) {
                NBTTagInt t = (NBTTagInt)list.get(i);
                int progress = t.func_150287_d();
                if (progress == 0) {
                    currentTip.add(I18n.func_135052_a((String)"ggfab.waila.advassline.slice.stuck", (Object[])new Object[]{i + 1}));
                    continue;
                }
                if (progress < 0) {
                    currentTip.add(I18n.func_135052_a((String)"ggfab.waila.advassline.slice.idle", (Object[])new Object[]{i + 1}));
                    continue;
                }
                if (duration > 40) {
                    currentTip.add(I18n.func_135052_a((String)"ggfab.waila.advassline.slice", (Object[])new Object[]{i + 1, (duration - progress) / 20, duration / 20}));
                    continue;
                }
                currentTip.add(I18n.func_135052_a((String)"ggfab.waila.advassline.slice.small", (Object[])new Object[]{i + 1, duration - progress, duration}));
            }
        }
    }

    @Override
    public void getWailaNBTData(EntityPlayerMP player, TileEntity tile, NBTTagCompound tag, World world, int x, int y, int z) {
        super.getWailaNBTData(player, tile, tag, world, x, y, z);
        if (this.currentRecipe == null || !this.getBaseMetaTileEntity().isActive()) {
            return;
        }
        NBTTagList l = new NBTTagList();
        for (int i = 0; i < this.currentInputLength; ++i) {
            l.func_74742_a((NBTBase)new NBTTagInt(this.slices[i].progress));
        }
        tag.func_74782_a(TAG_KEY_PROGRESS_TIMES, (NBTBase)l);
        tag.func_74768_a("mDuration", this.mMaxProgresstime / this.currentInputLength);
    }

    private void drainAllFluids(GTRecipe.RecipeAssemblyLine recipe, int parallel) {
        GTRecipe.RecipeAssemblyLine.consumeInputFluids(this.mInputHatches, parallel, recipe.mFluidInputs, this.curBatchFluidsFromME);
        for (MTEHatchInput tHatch : GTUtility.validMTEList(this.mInputHatches)) {
            tHatch.updateSlots();
        }
    }

    @Override
    public void stopMachine(@NotNull ShutDownReason reason) {
        this.clearCurrentRecipe();
        super.stopMachine(reason);
    }

    @Override
    public boolean supportsBatchMode() {
        return true;
    }

    @Override
    public boolean onWireCutterRightClick(ForgeDirection side, ForgeDirection wrenchingSide, EntityPlayer aPlayer, float aX, float aY, float aZ, ItemStack aTool) {
        if (aPlayer.func_70093_af()) {
            boolean bl = this.batchMode = !this.batchMode;
            if (this.batchMode) {
                GTUtility.sendChatToPlayer(aPlayer, StatCollector.func_74838_a((String)"misc.BatchModeTextOn"));
            } else {
                GTUtility.sendChatToPlayer(aPlayer, StatCollector.func_74838_a((String)"misc.BatchModeTextOff"));
            }
            return true;
        }
        return false;
    }

    private class Slice {
        private final int id;
        private int progress = -1;

        public Slice(int id) {
            this.id = id;
        }

        public void reset() {
            this.progress = -1;
        }

        public void tick() {
            if (this.progress < 0) {
                return;
            }
            if (this.progress == 0 || --this.progress == 0) {
                if (this.id + 1 >= MTEAdvAssLine.this.currentInputLength) {
                    ItemStack output = MTEAdvAssLine.this.mOutputItems[0];
                    if (MTEAdvAssLine.this.addOutput(output) || !((MTEAdvAssLine)MTEAdvAssLine.this).voidingMode.protectItem) {
                        this.reset();
                    } else {
                        MTEAdvAssLine.this.stuck = true;
                    }
                } else if (MTEAdvAssLine.this.slices[this.id + 1].start()) {
                    this.reset();
                } else {
                    MTEAdvAssLine.this.stuck = true;
                }
            }
        }

        public boolean start() {
            if (this.progress >= 0) {
                return false;
            }
            MTEAdvAssLine.this.startRecipeProcessing();
            ItemStack stack = MTEAdvAssLine.this.getInputBusContent(this.id);
            if (stack == null) {
                return false;
            }
            int size = GTRecipe.RecipeAssemblyLine.getMatchedIngredientAmount(stack, ((MTEAdvAssLine)MTEAdvAssLine.this).currentRecipe.mInputs[this.id], ((MTEAdvAssLine)MTEAdvAssLine.this).currentRecipe.mOreDictAlt[this.id]);
            if (size < 0 || stack.field_77994_a < size * MTEAdvAssLine.this.currentRecipeParallel) {
                return false;
            }
            this.progress = MTEAdvAssLine.this.mMaxProgresstime / MTEAdvAssLine.this.currentInputLength;
            stack.field_77994_a -= size * MTEAdvAssLine.this.currentRecipeParallel;
            ((MTEHatchInputBus)MTEAdvAssLine.this.mInputBusses.get(this.id)).updateSlots();
            return true;
        }

        public String toString() {
            return "Slice{id=" + this.id + ", progress=" + this.progress + '}';
        }
    }

    private static enum DataHatchElement implements IHatchElement<MTEAdvAssLine>
    {
        DataAccess;


        @Override
        public List<? extends Class<? extends IMetaTileEntity>> mteClasses() {
            return Collections.singletonList(MTEHatchDataAccess.class);
        }

        @Override
        public IGTHatchAdder<MTEAdvAssLine> adder() {
            return MTEAdvAssLine::addDataAccessToMachineList;
        }

        @Override
        public long count(MTEAdvAssLine t) {
            return t.mDataAccessHatches.size();
        }
    }

    private class SliceStatusWidget
    extends TextWidget
    implements ISyncedWidget {
        private final Slice slice;
        private int lastProgress = -2;
        private Text text;

        private SliceStatusWidget(Slice slice) {
            this.slice = slice;
            this.updateText();
            this.setEnabled(w -> slice.progress == 0 && MTEAdvAssLine.this.currentInputLength > slice.id);
        }

        public Text getText() {
            return this.text;
        }

        public void readOnClient(int id, PacketBuffer buf) {
            if (id == 0) {
                this.slice.progress = buf.func_150792_a();
                this.updateText();
                this.checkNeedsRebuild();
            }
        }

        public void updateText() {
            String type = "unknown";
            if (this.slice.progress == 0) {
                type = "stuck";
            } else if (this.slice.progress < 0) {
                type = "idle";
            }
            this.text = Text.localised((String)("ggfab.gui.advassline.slice." + type), (Object[])new Object[]{this.slice.id});
        }

        public void readOnServer(int id, PacketBuffer buf) {
        }

        public void detectAndSendChanges(boolean init) {
            if (this.slice.progress != this.lastProgress) {
                if (this.slice.progress > 0 && this.lastProgress > 0 && this.lastProgress - this.slice.progress < 10) {
                    return;
                }
                this.lastProgress = this.slice.progress;
                this.syncToClient(0, b -> b.func_150787_b(this.slice.progress));
            }
        }

        public void markForUpdate() {
        }

        public void unMarkForUpdate() {
        }

        public boolean isMarkedForUpdate() {
            return false;
        }
    }
}

