/*
 * Decompiled with CFR 0.152.
 */
package galacticgreg.auxiliary;

import galacticgreg.api.ModDimensionDef;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class ProfilingStorage {
    private final Map<String, List<Long>> mProfilingMap = new HashMap<String, List<Long>>();

    public void AddTimeToList(ModDimensionDef pDimension, long pTotalTime) {
        try {
            if (pTotalTime == 0L) {
                return;
            }
            if (!this.mProfilingMap.containsKey(pDimension.getDimIdentifier())) {
                this.mProfilingMap.put(pDimension.getDimIdentifier(), new LinkedList());
            }
            LinkedList ll = (LinkedList)this.mProfilingMap.get(pDimension.getDimIdentifier());
            ll.addLast(pTotalTime);
            while (ll.size() > 50) {
                ll.removeFirst();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public long GetAverageTime(ModDimensionDef pDimension) {
        try {
            if (!this.mProfilingMap.containsKey(pDimension.getDimIdentifier())) {
                return -1L;
            }
            int tTotalVal = 0;
            long tAverage = 0L;
            long tReturnVal = 0L;
            LinkedList ll = (LinkedList)this.mProfilingMap.get(pDimension.getDimIdentifier());
            if (ll != null) {
                for (Long aLong : ll) {
                    tAverage += aLong.longValue();
                    ++tTotalVal;
                }
                tReturnVal = (long)((float)(tAverage / (long)tTotalVal));
            }
            return tReturnVal;
        }
        catch (Exception e) {
            return -1L;
        }
    }
}

