/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.common.blocks.multiblock;

import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;

public class MultiblockHelper {

    public static class TileOffset {
        public int offsetX;
        public int offsetY;
        public int offsetZ;

        public TileOffset() {
        }

        public TileOffset(int x, int y, int z, int offsetX, int offsetY, int offsetZ) {
            this.offsetX = x - offsetX;
            this.offsetY = y - offsetY;
            this.offsetZ = z - offsetZ;
        }

        public TileOffset(TileEntity tile1, TileEntity offsetTile) {
            this.offsetX = tile1.field_145851_c - offsetTile.field_145851_c;
            this.offsetY = tile1.field_145848_d - offsetTile.field_145848_d;
            this.offsetZ = tile1.field_145849_e - offsetTile.field_145849_e;
        }

        public int getXCoord(TileEntity tileEntity) {
            return tileEntity.field_145851_c - this.offsetX;
        }

        public int getYCoord(TileEntity tileEntity) {
            return tileEntity.field_145848_d - this.offsetY;
        }

        public int getZCoord(TileEntity tileEntity) {
            return tileEntity.field_145849_e - this.offsetZ;
        }

        public int getXCoord(int xCoord) {
            return xCoord - this.offsetX;
        }

        public int getYCoord(int yCoord) {
            return yCoord - this.offsetY;
        }

        public int getZCoord(int zCoord) {
            return zCoord - this.offsetZ;
        }

        public TileEntity getTileEntity(TileEntity tileEntity) {
            return tileEntity.func_145831_w().func_147438_o(this.getXCoord(tileEntity), this.getYCoord(tileEntity), this.getZCoord(tileEntity));
        }

        public void writeToNBT(NBTTagCompound compound, String key) {
            compound.func_74768_a("X_" + key, this.offsetX);
            compound.func_74768_a("Y_" + key, this.offsetY);
            compound.func_74768_a("Z_" + key, this.offsetZ);
        }

        public void readFromNBT(NBTTagCompound compound, String key) {
            this.offsetX = compound.func_74762_e("X_" + key);
            this.offsetY = compound.func_74762_e("Y_" + key);
            this.offsetZ = compound.func_74762_e("Z_" + key);
        }
    }

    public static class TileLocation
    extends ChunkCoordinates {
        public boolean initialized = false;

        public TileLocation() {
        }

        public TileLocation(int x, int y, int z) {
            this.field_71574_a = x;
            this.field_71572_b = y;
            this.field_71573_c = z;
            this.initialized = true;
        }

        public int getXCoord() {
            return this.field_71574_a;
        }

        public int getYCoord() {
            return this.field_71572_b;
        }

        public int getZCoord() {
            return this.field_71573_c;
        }

        public boolean isThisLocation(int x, int y, int z) {
            return x == this.field_71574_a && y == this.field_71572_b && z == this.field_71573_c;
        }

        public void func_71571_b(int x, int y, int z) {
            this.initialized = true;
            super.func_71571_b(x, y, z);
        }

        public void setXCoord(int x) {
            this.field_71574_a = x;
            this.initialized = true;
        }

        public void setYCoord(int y) {
            this.field_71572_b = y;
            this.initialized = true;
        }

        public void setZCoord(int z) {
            this.field_71573_c = z;
            this.initialized = true;
        }

        public Block getBlock(World world) {
            return world.func_147439_a(this.field_71574_a, this.field_71572_b, this.field_71573_c);
        }

        public int getBlockMetadata(World world) {
            return world.func_72805_g(this.field_71574_a, this.field_71572_b, this.field_71573_c);
        }

        public TileEntity getTileEntity(World world) {
            return world.func_147438_o(this.field_71574_a, this.field_71572_b, this.field_71573_c);
        }

        public void writeToNBT(NBTTagCompound compound, String key) {
            compound.func_74768_a("X_" + key, this.field_71574_a);
            compound.func_74768_a("Y_" + key, this.field_71572_b);
            compound.func_74768_a("Z_" + key, this.field_71573_c);
            compound.func_74757_a("Init_" + key, this.initialized);
        }

        public void readFromNBT(NBTTagCompound compound, String key) {
            this.field_71574_a = compound.func_74762_e("X_" + key);
            this.field_71572_b = compound.func_74762_e("Y_" + key);
            this.field_71573_c = compound.func_74762_e("Z_" + key);
            this.initialized = compound.func_74767_n("Z_" + key);
        }
    }
}

