# 磁带驱动器模块

![向存储的烦恼说拜拜。](item:computronics:modules.tis3d@1)

磁带驱动器模块可与共面放置的磁带驱动器交互，以向其内部的盒式磁带写入数据，或从中读取数据。如果磁带内的数据编码为[DFPWM](http://wiki.vex.tty.sh/dfpwm)格式，此模块还能播放磁带内的音乐。

磁带有不同型号，可容纳音频长度从2到128分钟不等，且能存储其他种类的信息（存储空间约等于DFPWM编码音频分钟数除以4，单位为MB）。

模块接收指令的方式如下所述：模块会持续从其全部四个端口读取数值。当模块接收到一个数值后，它会检查数值是否为有效的指令编号。若是，模块会继续执行该指令的下一阶段，可能为等待后续从某端口输入（一个参数），也可能为开始向全部四个端口写出返回值。指令执行完毕后，模块会继续从所有端口进行读取，等待输入指令。

可用指令如下：

* `0`: isEnd - 若磁带驱动器未装入磁带或磁带到达末尾则返回1，否则返回0。Returns 1 if the tape drive is empty or the inserted tape has reached its end, 0 otherwise.
* `1`: isReady - 若磁带驱动器中已装入磁带则返回1，否则返回0。
* `2`: getState - 返回磁带驱动器的当前状态，形式为数字。若磁带驱动器停止播放则返回`0`，若磁带驱动器正在播放则返回`1`，若磁带驱动器正在倒带则返回`2`，若磁带驱动器正在快进则返回`3`。
* `3`: getSize - 返回磁带的容量，单位为字节，对1024取模。
* `4`: getSize（KiB版本） - 返回磁带的容量，单位为KiB，向下取整。
* `5`: setSpeed - 将磁带驱动器的播放速度设定为模块读取的下一个值，单位为百分比。输入值的有效范围为25到200。
* `6`: setVolume - 将磁带驱动器的音量设定为模块读取的下一个值，单位为百分比。输入值的有效范围为0到100。
* `7`: seek - 将磁带快进，数量为模块读取的下一个数值（单位为字节）。若输入负值则会反向快进（即倒带）。
* `8`: seek（KiB版本） - 将磁带快进，数量为模块读取的下一个数值（单位为KiB）。若输入负值则会反向快进（即倒带）。
* `9`: read - 从磁带读取一个字节，并返回。
* `10`: read（多字节版） - 模块读取的下一个数值为读取量，单位为字节。模块会从磁带中读取指定数量的字节，并逐个返回。例如：传参`4`会令模块从磁带读取四次，并将结果输出到全部端口上，每读取磁带一次，返回一字节。
* `11`: write - 将模块接收的下一个数值写入到磁带中。
* `12`: write（多字节版） - 模块读取的下一个值会被认为是要写入磁带的字节数。后续成功读取的字节都会被写入到磁带中，直到数量达到设定值。
* `13`: switchState - 将磁带驱动器的状态设定为模块读取的下一个值。请参见指令2（getState）以获取合法的传入值。
