/*
 * Decompiled with CFR 0.152.
 */
package com.recursive_pineapple.matter_manipulator.common.utils;

import appeng.api.storage.data.IAEFluidStack;
import appeng.util.item.AEFluidStack;
import com.recursive_pineapple.matter_manipulator.common.utils.FluidId;
import com.recursive_pineapple.matter_manipulator.common.utils.MMUtils;
import cpw.mods.fml.common.Optional;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class BigFluidStack {
    public Fluid fluid;
    public long amount;
    public int meta;
    public NBTTagCompound tag;
    public transient FluidId id;

    public BigFluidStack() {
    }

    private BigFluidStack(FluidStack stack) {
        this.fluid = stack.getFluid();
        this.amount = stack.amount;
        this.tag = MMUtils.copy(stack.tag);
    }

    private BigFluidStack(FluidId id, long amount) {
        this(id.getFluidStack());
        this.setStackSize(amount);
    }

    public FluidId getId() {
        if (this.id == null) {
            this.id = FluidId.createWithCopy(this.fluid, null, this.tag);
        }
        return this.id;
    }

    public FluidStack getFluidStack() {
        FluidStack stack = new FluidStack(this.fluid, this.amount > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)this.amount);
        stack.tag = MMUtils.copy(this.tag);
        return stack;
    }

    @Optional.Method(modid="appliedenergistics2")
    public IAEFluidStack getAEFluidStack() {
        return (IAEFluidStack)Objects.requireNonNull(AEFluidStack.create((Object)this.getFluidStack())).setStackSize(this.amount);
    }

    public static BigFluidStack create(FluidStack stack) {
        if (stack == null) {
            return null;
        }
        return new BigFluidStack(stack);
    }

    public static BigFluidStack create(FluidId id, long amount) {
        if (id == null) {
            return null;
        }
        return new BigFluidStack(id, amount);
    }

    @Optional.Method(modid="appliedenergistics2")
    public static BigFluidStack create(IAEFluidStack stack) {
        if (stack == null) {
            return null;
        }
        return BigFluidStack.create(stack.getFluidStack()).setStackSize(stack.getStackSize());
    }

    public FluidStack remove(int amount) {
        if (this.amount < (long)amount) {
            FluidStack stack = new FluidStack(this.fluid, (int)this.amount);
            stack.tag = MMUtils.copy(this.tag);
            this.amount = 0L;
            return stack;
        }
        FluidStack stack = new FluidStack(this.fluid, amount);
        stack.tag = MMUtils.copy(this.tag);
        this.amount -= (long)amount;
        return stack;
    }

    public BigFluidStack removeBig(long amount) {
        long toRemove = Math.min(this.amount, amount);
        BigFluidStack stack = this.copy().setStackSize(toRemove);
        this.amount -= toRemove;
        return stack;
    }

    public BigFluidStack incStackSize(long amount) {
        this.amount += amount;
        return this;
    }

    public BigFluidStack decStackSize(long amount) {
        this.amount -= amount;
        return this;
    }

    public List<FluidStack> toStacks() {
        ArrayList<FluidStack> stack = new ArrayList<FluidStack>();
        while (this.amount > 0L) {
            stack.add(this.remove(Integer.MAX_VALUE));
        }
        return stack;
    }

    public BigFluidStack copy() {
        BigFluidStack out = new BigFluidStack();
        out.fluid = this.fluid;
        out.amount = this.amount;
        out.meta = this.meta;
        out.tag = this.tag == null ? null : (NBTTagCompound)this.tag.func_74737_b();
        return out;
    }

    public BigFluidStack setStackSize(long amount) {
        this.amount = amount;
        return this;
    }

    public long getStackSize() {
        return this.amount;
    }
}

