/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.plugins.forestry;

import cpw.mods.fml.common.Optional;
import forestry.api.storage.IBackpackDefinition;
import java.util.ArrayList;
import java.util.List;
import mods.railcraft.common.items.RailcraftItem;
import mods.railcraft.common.util.inventory.InvTools;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;

@Optional.Interface(iface="forestry.api.storage.IBackpackDefinition", modid="Forestry")
public abstract class BaseBackpack
implements IBackpackDefinition {
    protected List<ItemStack> items = new ArrayList<ItemStack>(50);

    public void addValidItem(ItemStack stack) {
        this.addItem(stack);
    }

    public void addValidItems(List<ItemStack> validItems) {
        for (ItemStack stack : validItems) {
            this.addItem(stack);
        }
    }

    public void addItem(ItemStack stack) {
        if (stack == null) {
            return;
        }
        this.items.add(stack);
    }

    public void addItem(RailcraftItem item) {
        if (item == null) {
            return;
        }
        this.items.add(item.getWildcard());
    }

    public void addItem(Item item) {
        if (item == null) {
            return;
        }
        this.items.add(new ItemStack(item, 1, Short.MAX_VALUE));
    }

    public void addItem(Block block) {
        if (block == null) {
            return;
        }
        this.items.add(new ItemStack(block, 1, Short.MAX_VALUE));
    }

    @Deprecated
    @Optional.Method(modid="Forestry")
    public boolean isValidItem(EntityPlayer player, ItemStack pickup) {
        return this.isValidItem(pickup);
    }

    public boolean isValidItem(ItemStack pickup) {
        for (ItemStack stack : this.items) {
            if (!InvTools.isItemEqualIgnoreNBT(stack, pickup)) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    @Optional.Method(modid="Forestry")
    public String getName() {
        return "Update Forestry!";
    }

    public String getName(ItemStack backpack) {
        NBTTagCompound nbt;
        Item item = backpack.func_77973_b();
        String name = ("" + StatCollector.func_74838_a((String)(item.func_77657_g(backpack) + ".name"))).trim();
        if (backpack.field_77990_d != null && backpack.field_77990_d.func_150297_b("display", 10) && (nbt = backpack.field_77990_d.func_74775_l("display")).func_150297_b("Name", 8)) {
            name = nbt.func_74779_i("Name");
        }
        return name;
    }
}

