/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.items;

import java.util.List;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.items.IItemMetaEnum;
import mods.railcraft.common.items.ItemRailcraft;
import mods.railcraft.common.plugins.forestry.ForestryPlugin;
import mods.railcraft.common.plugins.forge.RailcraftRegistry;
import mods.railcraft.common.plugins.ic2.IC2Plugin;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraftforge.oredict.OreDictionary;

public class ItemDust
extends ItemRailcraft {
    public ItemDust() {
        this.func_77627_a(true);
        this.func_77656_e(0);
    }

    @Override
    public void initItem() {
        for (EnumDust d : EnumDust.VALUES) {
            ItemStack stack = new ItemStack((Item)this, 1, d.ordinal());
            RailcraftRegistry.register(stack);
            ForestryPlugin.addBackpackItem("miner", stack);
            OreDictionary.registerOre((String)d.oreTag, (ItemStack)stack.func_77946_l());
        }
    }

    @Override
    public void definePostRecipes() {
        if (IC2Plugin.isModInstalled() && RailcraftConfig.getRecipeConfig("ic2.macerator.charcoal")) {
            IC2Plugin.addMaceratorRecipe(new ItemStack(Items.field_151044_h, 1, 1), new ItemStack((Item)this, 1, EnumDust.CHARCOAL.ordinal()));
        }
    }

    @Override
    public void func_94581_a(IIconRegister iconRegister) {
        for (EnumDust dust : EnumDust.VALUES) {
            dust.icon = iconRegister.func_94245_a("railcraft:" + dust.tag);
        }
    }

    public void func_150895_a(Item item, CreativeTabs tab, List list) {
        for (EnumDust dust : EnumDust.VALUES) {
            list.add(new ItemStack((Item)this, 1, dust.ordinal()));
        }
    }

    public IIcon func_77617_a(int damage) {
        if (damage >= EnumDust.VALUES.length) {
            return EnumDust.CHARCOAL.icon;
        }
        return EnumDust.VALUES[damage].icon;
    }

    public String func_77667_c(ItemStack stack) {
        int damage = stack.func_77960_j();
        if (damage < 0 || damage >= EnumDust.VALUES.length) {
            return "";
        }
        return "item.railcraft." + EnumDust.VALUES[damage].tag;
    }

    @Override
    public String getOreTag(IItemMetaEnum meta) {
        this.assertMeta(meta);
        return ((EnumDust)meta).oreTag;
    }

    public static enum EnumDust implements IItemMetaEnum
    {
        OBSIDIAN("dust.obsidian", "dustObsidian"),
        SULFUR("dust.sulfur", "dustSulfur"),
        SALTPETER("dust.saltpeter", "dustSaltpeter"),
        CHARCOAL("dust.charcoal", "dustCharcoal");

        public static final EnumDust[] VALUES;
        private final String tag;
        private final String oreTag;
        private IIcon icon;

        private EnumDust(String tag, String oreTag) {
            this.tag = tag;
            this.oreTag = oreTag;
        }

        @Override
        public Object getAlternate() {
            return this.oreTag;
        }

        @Override
        public Class<? extends ItemRailcraft> getItemClass() {
            return ItemDust.class;
        }

        static {
            VALUES = EnumDust.values();
        }
    }
}

