/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.carts;

import com.indemnity83.irontank.item.ItemTankChanger;
import com.indemnity83.irontank.reference.TankType;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Optional;
import mods.railcraft.api.carts.IFluidCart;
import mods.railcraft.api.carts.ILiquidTransfer;
import mods.railcraft.common.carts.EntityCartFiltered;
import mods.railcraft.common.carts.EnumCart;
import mods.railcraft.common.carts.ICartType;
import mods.railcraft.common.carts.LinkageManager;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.fluids.FluidHelper;
import mods.railcraft.common.fluids.FluidItemHelper;
import mods.railcraft.common.fluids.TankManager;
import mods.railcraft.common.fluids.tanks.StandardTank;
import mods.railcraft.common.gui.EnumGui;
import mods.railcraft.common.gui.GuiHandler;
import mods.railcraft.common.util.inventory.InvTools;
import mods.railcraft.common.util.inventory.wrappers.InventoryMapper;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.misc.MiscTools;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import secondderivative.irontankminecarts.minecarts.EntityMinecartTankAbstract;

public class EntityCartTank
extends EntityCartFiltered
implements IFluidHandler,
ILiquidTransfer,
ISidedInventory,
IFluidCart {
    private static final byte FLUID_ID_DATA_ID = 25;
    private static final byte FLUID_QTY_DATA_ID = 26;
    private static final byte FLUID_COLOR_DATA_ID = 27;
    private static final byte FILLING_DATA_ID = 28;
    private static final int SLOT_INPUT = 0;
    private static final int SLOT_OUTPUT = 1;
    private static final int[] SLOTS = InvTools.buildSlotArray(0, 2);
    private final TankManager tankManager = new TankManager();
    private final IInventory invLiquids = new InventoryMapper((IInventory)this, false);
    private int update = MiscTools.getRand().nextInt();

    public EntityCartTank(World world) {
        super(world);
        this.tankManager.add(new StandardTank(this.getCapacity()));
    }

    public EntityCartTank(World world, double d, double d1, double d2) {
        this(world);
        this.func_70107_b(d, d1 + (double)this.field_70129_M, d2);
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
        this.field_70169_q = d;
        this.field_70167_r = d1;
        this.field_70166_s = d2;
    }

    public int getCapacity() {
        return RailcraftConfig.getTankCartCapacity();
    }

    @Override
    public ICartType getCartType() {
        return EnumCart.TANK;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(25, (Object)new Integer(-1));
        this.field_70180_af.func_75682_a(26, (Object)new Integer(0));
        this.field_70180_af.func_75682_a(27, (Object)new Integer(0xFFFFFF));
        this.field_70180_af.func_75682_a(28, (Object)0);
    }

    private int getFluidQty() {
        return this.field_70180_af.func_75679_c(26);
    }

    private void setFluidQty(int qty) {
        this.field_70180_af.func_75692_b(26, (Object)qty);
    }

    private int getFluidId() {
        return this.field_70180_af.func_75679_c(25);
    }

    private void setFluidId(int fluidId) {
        this.field_70180_af.func_75692_b(25, (Object)fluidId);
    }

    private int getFluidColor() {
        return this.field_70180_af.func_75679_c(27);
    }

    private void setFluidColor(int color) {
        this.field_70180_af.func_75692_b(27, (Object)color);
    }

    public TankManager getTankManager() {
        return this.tankManager;
    }

    @Override
    public void func_70106_y() {
        super.func_70106_y();
        InvTools.dropInventory(this.invLiquids, this.field_70170_p, (int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v);
    }

    public void func_70071_h_() {
        ItemStack bottomSlot;
        super.func_70071_h_();
        if (Game.isNotHost(this.field_70170_p)) {
            if (this.getFluidId() != -1) {
                this.getTankManager().get((int)0).renderData.fluid = FluidRegistry.getFluid((int)this.getFluidId());
                this.getTankManager().get((int)0).renderData.amount = this.getFluidQty();
                this.getTankManager().get((int)0).renderData.color = this.getFluidColor();
            } else {
                this.getTankManager().get((int)0).renderData.fluid = null;
                this.getTankManager().get((int)0).renderData.amount = 0;
                this.getTankManager().get((int)0).renderData.color = 0xFFFFFF;
            }
            return;
        }
        FluidStack fluidStack = this.getTankManager().get(0).getFluid();
        if (fluidStack != null) {
            int fluidId = FluidHelper.getFluidId(fluidStack);
            if (fluidId != this.getFluidId()) {
                this.setFluidId(fluidId);
            }
            if (fluidStack.amount != this.getFluidQty()) {
                this.setFluidQty(fluidStack.amount);
            }
            if (this.getTankManager().get(0).getColor() != this.getFluidColor()) {
                this.setFluidColor(this.getTankManager().get(0).getColor());
            }
        } else {
            if (this.getFluidId() != -1) {
                this.setFluidId(-1);
            }
            if (this.getFluidQty() != 0) {
                this.setFluidQty(0);
            }
            if (this.getFluidColor() != 0xFFFFFF) {
                this.setFluidColor(0xFFFFFF);
            }
        }
        ++this.update;
        ItemStack topSlot = this.invLiquids.func_70301_a(0);
        if (topSlot != null && !FluidItemHelper.isContainer(topSlot)) {
            this.invLiquids.func_70299_a(0, null);
            this.func_70099_a(topSlot, 1.0f);
        }
        if ((bottomSlot = this.invLiquids.func_70301_a(1)) != null && !FluidItemHelper.isContainer(bottomSlot)) {
            this.invLiquids.func_70299_a(1, null);
            this.func_70099_a(bottomSlot, 1.0f);
        }
        if (this.update % 8 == 0) {
            FluidHelper.processContainers(this.getTankManager().get(0), this.invLiquids, 0, 1);
        }
    }

    @Override
    public boolean doInteract(EntityPlayer player) {
        Item item;
        ItemStack stack;
        if (Loader.isModLoaded((String)"irontankminecarts") && (stack = player.func_71045_bC()) != null && (item = stack.func_77973_b()) instanceof ItemTankChanger) {
            ItemTankChanger changer = (ItemTankChanger)item;
            if (changer.type.canUpgrade(this.tankType())) {
                this.tryUpgrade(changer);
                if (!player.field_71075_bZ.field_75098_d && --stack.field_77994_a <= 0) {
                    player.func_70062_b(0, null);
                }
            }
            return true;
        }
        if (Game.isHost(this.field_70170_p)) {
            if (FluidHelper.handleRightClick(this, ForgeDirection.UNKNOWN, player, true, true)) {
                return true;
            }
            GuiHandler.openGui(EnumGui.CART_TANK, player, this.field_70170_p, (Entity)this);
        }
        return true;
    }

    @Optional.Method(modid="irontankminecarts")
    private void tryUpgrade(ItemTankChanger changer) {
        if (Game.isHost(this.field_70170_p)) {
            TankType newType = changer.type.target;
            NBTTagCompound nbt = new NBTTagCompound();
            this.func_70109_d(nbt);
            this.func_70106_y();
            try {
                EntityMinecartTankAbstract minecart = (EntityMinecartTankAbstract)((Class)EntityMinecartTankAbstract.map.get(newType)).getConstructor(World.class).newInstance(this.field_70170_p);
                minecart.func_70020_e(nbt);
                this.field_70170_p.func_72838_d((Entity)minecart);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public int func_70302_i_() {
        return 2;
    }

    @Override
    protected void func_70037_a(NBTTagCompound data) {
        super.func_70037_a(data);
        this.tankManager.readTanksFromNBT(data);
    }

    @Override
    protected void func_70014_b(NBTTagCompound data) {
        super.func_70014_b(data);
        this.tankManager.writeTanksToNBT(data);
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (resource == null) {
            return 0;
        }
        Fluid filterFluid = this.getFilterFluid();
        if (filterFluid == null || resource.getFluid() == filterFluid) {
            return this.getTankManager().get(0).fill(resource, doFill);
        }
        return 0;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.getTankManager().get(0).drain(maxDrain, doDrain);
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (resource == null) {
            return null;
        }
        if (this.getTankManager().get(0).getFluidType() == resource.getFluid()) {
            return this.getTankManager().get(0).drain(resource.amount, doDrain);
        }
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        Fluid filterFluid = this.getFilterFluid();
        return filterFluid == null || fluid == filterFluid;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection side) {
        return this.tankManager.getTankInfo();
    }

    @Override
    public boolean isFilling() {
        return this.field_70180_af.func_75683_a(28) != 0;
    }

    @Override
    public void setFilling(boolean fill) {
        this.field_70180_af.func_75692_b(28, (Object)(fill ? (byte)1 : 0));
    }

    public Fluid getFilterFluid() {
        ItemStack filter = this.getFilterItem();
        if (filter == null) {
            return null;
        }
        return FluidItemHelper.getFluidInContainer(filter);
    }

    public IInventory getInvLiquids() {
        return this.invLiquids;
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return slot == 0 && FluidItemHelper.isContainer(stack);
    }

    public int[] func_94128_d(int side) {
        return SLOTS;
    }

    public boolean func_102007_a(int slot, ItemStack stack, int side) {
        return this.func_94041_b(slot, stack);
    }

    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        return slot == 1;
    }

    @Override
    @Deprecated
    public int offerLiquid(Object source, FluidStack offer) {
        int qty = offer.amount;
        int used = this.fill(ForgeDirection.UNKNOWN, offer, true);
        offer.amount = qty - used;
        if (offer.amount <= 0) {
            return used;
        }
        LinkageManager lm = LinkageManager.instance();
        EntityMinecart linkedCart = lm.getLinkedCartA((EntityMinecart)this);
        if (linkedCart != source && linkedCart instanceof ILiquidTransfer) {
            used += ((ILiquidTransfer)linkedCart).offerLiquid(this, offer);
        }
        offer.amount = qty - used;
        if (offer.amount <= 0) {
            return used;
        }
        linkedCart = lm.getLinkedCartB((EntityMinecart)this);
        if (linkedCart != source && linkedCart instanceof ILiquidTransfer) {
            used += ((ILiquidTransfer)linkedCart).offerLiquid(this, offer);
        }
        return used;
    }

    @Override
    @Deprecated
    public int requestLiquid(Object source, FluidStack request) {
        FluidStack acquired = this.drain(ForgeDirection.UNKNOWN, request.amount, false);
        if (acquired == null || !request.isFluidEqual(acquired)) {
            return 0;
        }
        this.drain(ForgeDirection.UNKNOWN, request.amount, true);
        if (acquired.amount >= request.amount) {
            return acquired.amount;
        }
        FluidStack newRequest = request.copy();
        newRequest.amount = request.amount - acquired.amount;
        LinkageManager lm = LinkageManager.instance();
        EntityMinecart linkedCart = lm.getLinkedCartA((EntityMinecart)this);
        if (linkedCart != source && linkedCart instanceof ILiquidTransfer) {
            acquired.amount += ((ILiquidTransfer)linkedCart).requestLiquid(this, newRequest);
        }
        if (acquired.amount >= request.amount) {
            return acquired.amount;
        }
        newRequest.amount = request.amount - acquired.amount;
        linkedCart = lm.getLinkedCartB((EntityMinecart)this);
        if (linkedCart != source && linkedCart instanceof ILiquidTransfer) {
            acquired.amount += ((ILiquidTransfer)linkedCart).requestLiquid(this, newRequest);
        }
        return acquired.amount;
    }

    @Override
    public boolean canPassFluidRequests(Fluid fluid) {
        if (this.hasFilter()) {
            return this.getFilterFluid() == fluid;
        }
        return this.getTankManager().get(0).isEmpty() || this.getTankManager().get(0).getFluidType() == fluid;
    }

    @Override
    public boolean canAcceptPushedFluid(EntityMinecart requester, Fluid fluid) {
        return this.canPassFluidRequests(fluid);
    }

    @Override
    public boolean canProvidePulledFluid(EntityMinecart requester, Fluid fluid) {
        return this.canPassFluidRequests(fluid);
    }

    @Optional.Method(modid="irontankminecarts")
    public TankType tankType() {
        return TankType.GLASS;
    }
}

