/*
 * Decompiled with CFR 0.152.
 */
package glowredman.amazingtrophies.model.complex;

import com.gtnewhorizon.gtnhlib.client.renderer.TessellatorManager;
import com.gtnewhorizon.gtnhlib.client.renderer.vbo.VBOManager;
import com.gtnewhorizon.gtnhlib.client.renderer.vbo.VertexBuffer;
import com.gtnewhorizon.gtnhlib.client.renderer.vertex.DefaultVertexFormat;
import com.gtnewhorizon.gtnhlib.client.renderer.vertex.VertexFormat;
import com.gtnewhorizon.gtnhlib.util.data.BlockMeta;
import glowredman.amazingtrophies.AmazingTrophies;
import glowredman.amazingtrophies.model.complex.BaseModelStructure;
import glowredman.amazingtrophies.model.complex.CustomRenderBlocks;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.world.IBlockAccess;
import org.lwjgl.opengl.GL11;

public class RenderHelper {
    public static final RenderHelper INSTANCE = AmazingTrophies.enableVBO ? new RenderHelperVBO() : new RenderHelper();
    private static final float TROPHY_RATIO_XZ = 0.75f;
    private static final float TROPHY_RATIO_Y = 0.6875f;

    protected void centreModel(BaseModelStructure model) {
        float x = (float)model.getXLength() * 0.5f;
        float z = (float)model.getYLength() * 0.5f;
        GL11.glTranslatef((float)(0.5f - x), (float)-0.5f, (float)(-0.5f - z));
    }

    protected void buildModel(BaseModelStructure model) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
        CustomRenderBlocks renderBlocks = new CustomRenderBlocks((IBlockAccess)Minecraft.func_71410_x().field_71441_e);
        renderBlocks.field_147863_w = false;
        for (int x = 0; x < model.getXLength(); ++x) {
            for (int y = 0; y < model.getYLength(); ++y) {
                for (int z = 0; z < model.getZLength(); ++z) {
                    char blockChar = model.getStructureString()[x][z].charAt(y);
                    if (blockChar == ' ' || model.renderFacesArray[x][z][y].allHidden()) continue;
                    BlockMeta blockInfo = model.getAssociatedBlockInfo(blockChar);
                    Block block = blockInfo.getBlock();
                    int meta = blockInfo.getBlockMeta();
                    if (!block.func_149686_d()) {
                        GL11.glPushMatrix();
                        GL11.glPushAttrib((int)1048575);
                    }
                    renderBlocks.setRenderFacesInfo(model.renderFacesArray[x][z][y]);
                    if (model.skipHalfOffset.contains(blockChar)) {
                        this.renderBlock(block, meta, renderBlocks, (double)x + 0.5, (double)z + 1.5, (double)y + 1.5);
                    } else {
                        this.renderBlock(block, meta, renderBlocks, x, z + 1, y + 1);
                    }
                    if (block.func_149686_d()) continue;
                    GL11.glPopAttrib();
                    GL11.glPopMatrix();
                }
            }
        }
    }

    protected void scaleModel(BaseModelStructure model) {
        float maxScale = Math.min(0.75f / (float)Math.max(model.getXLength(), model.getYLength()), 0.6875f / (float)model.getZLength());
        GL11.glScalef((float)maxScale, (float)maxScale, (float)maxScale);
    }

    public void renderModel(BaseModelStructure model) {
        if (model == null) {
            return;
        }
        GL11.glPushMatrix();
        this.scaleModel(model);
        this.centreModel(model);
        this.buildModel(model);
        GL11.glPopMatrix();
    }

    protected void renderBlock(Block block, int metadata, CustomRenderBlocks renderBlocks, double x, double y, double z) {
        GL11.glPushMatrix();
        GL11.glTranslated((double)x, (double)y, (double)z);
        GL11.glRotated((double)-90.0, (double)0.0, (double)1.0, (double)0.0);
        renderBlocks.func_147800_a(block, metadata, 1.0f);
        GL11.glPopMatrix();
    }

    private static class RenderHelperVBO
    extends RenderHelper {
        private static final VertexFormat format = DefaultVertexFormat.POSITION_TEXTURE_NORMAL;

        private RenderHelperVBO() {
        }

        private VertexBuffer rebuildVBO(BaseModelStructure model) {
            CustomRenderBlocks renderBlocks = new CustomRenderBlocks((IBlockAccess)Minecraft.func_71410_x().field_71441_e);
            renderBlocks.field_147863_w = false;
            TessellatorManager.startCapturing();
            Tessellator tessellator = TessellatorManager.get();
            for (int x = 0; x < model.getXLength(); ++x) {
                for (int y = 0; y < model.getYLength(); ++y) {
                    for (int z = 0; z < model.getZLength(); ++z) {
                        char blockChar = model.getStructureString()[x][z].charAt(y);
                        if (blockChar == ' ' || model.renderFacesArray[x][z][y].allHidden()) continue;
                        BlockMeta blockInfo = model.getAssociatedBlockInfo(blockChar);
                        renderBlocks.setRenderFacesInfo(model.renderFacesArray[x][z][y]);
                        if (model.skipHalfOffset.contains(blockChar)) {
                            tessellator.func_78373_b((double)x + 0.5, (double)z + 1.5, (double)y + 1.5);
                        } else {
                            tessellator.func_78373_b((double)x, (double)(z + 1), (double)(y + 1));
                        }
                        this.renderBlock(blockInfo.getBlock(), blockInfo.getBlockMeta(), renderBlocks);
                    }
                }
            }
            tessellator.func_78373_b(0.0, 0.0, 0.0);
            int vboId = VBOManager.generateDisplayLists((int)1);
            VertexBuffer vertexBuffer = TessellatorManager.stopCapturingToVBO((VertexFormat)format);
            VBOManager.registerVBO((int)vboId, (VertexBuffer)vertexBuffer);
            model.vertexBuffer = vertexBuffer;
            return vertexBuffer;
        }

        @Override
        protected void buildModel(BaseModelStructure model) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
            VertexBuffer vertexBuffer = (VertexBuffer)model.vertexBuffer;
            if (model.vertexBuffer == null) {
                vertexBuffer = this.rebuildVBO(model);
            }
            GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glEnable((int)2896);
            GL11.glEnable((int)32826);
            vertexBuffer.render();
        }

        private void renderBlock(Block block, int metadata, CustomRenderBlocks renderBlocks) {
            renderBlocks.func_147800_a(block, metadata, 1.0f);
        }
    }
}

