/*
 * Decompiled with CFR 0.152.
 */
package net.fuzzycraft.botanichorizons.addons.item;

import java.util.List;
import net.fuzzycraft.botanichorizons.addons.item.ItemManaWrench;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import vazkii.botania.api.mana.IManaGivingItem;
import vazkii.botania.api.mana.IManaItem;
import vazkii.botania.api.mana.IManaTooltipDisplay;
import vazkii.botania.common.core.helper.ItemNBTHelper;

public abstract class ItemSuperchargedWrench
extends ItemManaWrench
implements IManaItem,
IManaTooltipDisplay {
    public static final int MAX_MANA = Integer.MAX_VALUE;
    public static final int[] TIERING_LEVELS = new int[]{0, 10000, 1000000, 10000000, 100000000, 1000000000, Integer.MAX_VALUE};
    public static final String TAG_MANA = "mana";

    public ItemSuperchargedWrench(Item.ToolMaterial toolMaterial, int toolLevel, String name) {
        super(toolMaterial, toolLevel, name);
    }

    public void func_77624_a(ItemStack heldItem, EntityPlayer player, List<String> tooltips, boolean par4) {
        String rankFormat = StatCollector.func_74838_a((String)"botaniamisc.toolRank");
        String rank = StatCollector.func_74838_a((String)("botania.rank" + this.getLevel(heldItem)));
        tooltips.add(String.format(rankFormat, rank).replaceAll("&", "\u00a7"));
        if (this.getMana(heldItem) == Integer.MAX_VALUE) {
            tooltips.add(EnumChatFormatting.RED + StatCollector.func_74838_a((String)"botaniamisc.getALife"));
        }
    }

    public void func_150895_a(Item item, CreativeTabs tab, List<ItemStack> list) {
        for (int baseMana : TIERING_LEVELS) {
            int mana = baseMana - 1;
            if (baseMana <= 0) continue;
            ItemStack stack = new ItemStack(item);
            this.setMana(stack, mana);
            list.add(stack);
        }
    }

    public void setMana(ItemStack stack, int mana) {
        ItemNBTHelper.setInt((ItemStack)stack, (String)TAG_MANA, (int)mana);
    }

    public int getMana(ItemStack stack) {
        return ItemNBTHelper.getInt((ItemStack)stack, (String)TAG_MANA, (int)0);
    }

    public int getLevel(ItemStack stack) {
        int mana = this.getMana(stack);
        for (int i = TIERING_LEVELS.length - 2; i > 0; --i) {
            if (mana < TIERING_LEVELS[i]) continue;
            return i;
        }
        return 0;
    }

    public int getMaxMana(ItemStack stack) {
        return Integer.MAX_VALUE;
    }

    public void addMana(ItemStack stack, int mana) {
        this.setMana(stack, Math.min(this.getMana(stack) + mana, Integer.MAX_VALUE));
    }

    public boolean canReceiveManaFromPool(ItemStack stack, TileEntity pool) {
        return true;
    }

    public boolean canReceiveManaFromItem(ItemStack stack, ItemStack otherStack) {
        return !(otherStack.func_77973_b() instanceof IManaGivingItem);
    }

    public boolean canExportManaToPool(ItemStack stack, TileEntity pool) {
        return false;
    }

    public boolean canExportManaToItem(ItemStack stack, ItemStack otherStack) {
        return false;
    }

    public boolean isNoExport(ItemStack stack) {
        return true;
    }

    public int getEntityLifespan(ItemStack itemStack, World world) {
        return Integer.MAX_VALUE;
    }

    public float getManaFractionForDisplay(ItemStack stack) {
        int level = this.getLevel(stack);
        int mana = this.getMana(stack);
        int startMana = TIERING_LEVELS[level];
        int endMana = TIERING_LEVELS[level + 1];
        int barMana = mana - startMana;
        int barTotal = endMana - startMana;
        return (float)barMana / (float)barTotal;
    }
}

