/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.world.structure.island.biome.decorator;

import chylex.hee.init.BlockList;
import chylex.hee.world.structure.island.biome.IslandBiomeBase;
import chylex.hee.world.structure.island.biome.IslandBiomeInfestedForest;
import chylex.hee.world.structure.island.biome.decorator.IslandBiomeDecorator;
import chylex.hee.world.structure.island.biome.feature.forest.StructureBush;
import chylex.hee.world.structure.island.biome.feature.forest.StructureRavagedDungeon;
import chylex.hee.world.structure.island.biome.feature.forest.StructureRuinBuild;
import chylex.hee.world.structure.island.biome.feature.forest.StructureRuinPillar;
import chylex.hee.world.structure.island.biome.feature.forest.StructureSpookyTree;
import net.minecraft.init.Blocks;

public final class BiomeDecoratorInfestedForest
extends IslandBiomeDecorator {
    private final StructureSpookyTree genTree = new StructureSpookyTree();
    private final StructureBush genBush = new StructureBush();
    private final StructureRavagedDungeon genRavagedDungeon = new StructureRavagedDungeon();
    private final StructureRuinPillar genRuinPillar = new StructureRuinPillar();
    private final StructureRuinBuild genRuinBuild = new StructureRuinBuild();

    @Override
    protected final IslandBiomeBase getBiome() {
        return IslandBiomeBase.infestedForest;
    }

    public void genDeep() {
        this.genTree.setCanGenerateFace(true).setLooseSpaceCheck(true);
        int placed = 0;
        for (int attempt = 0; attempt < 10000 && placed < 2900; ++attempt) {
            this.genTree.setTreeType(this.rand.nextBoolean() ? StructureSpookyTree.TreeType.SIMPLE_BULGING : StructureSpookyTree.TreeType.SIMPLE_SPHERICAL);
            if (!this.generateStructure(this.genTree)) continue;
            ++placed;
        }
        boolean moreBushes = this.data.hasDeviation(IslandBiomeInfestedForest.MORE_THORNY_BUSHES);
        for (int a = 0; a < 169; ++a) {
            int zz;
            int yy;
            int xx;
            int attempt;
            if (moreBushes || this.rand.nextBoolean()) {
                for (attempt = 0; attempt < 18; ++attempt) {
                    xx = this.getRandomXZ(this.rand, 0);
                    if (this.world.getBlock(xx, yy = this.world.getHighestY(xx, zz = this.getRandomXZ(this.rand, 0)), zz) != topBlock || !this.world.isAir(xx, yy + 1, zz)) continue;
                    this.world.setBlock(xx, yy, zz, BlockList.crossed_decoration, 2);
                    if (!this.data.hasDeviation(IslandBiomeInfestedForest.MORE_THORNY_BUSHES) && this.rand.nextInt(5) <= 1) break;
                }
            }
            for (attempt = 0; attempt < 100; ++attempt) {
                xx = this.getRandomXZ(this.rand, 0);
                zz = this.getRandomXZ(this.rand, 0);
                int n = yy = attempt > 70 ? 10 + this.rand.nextInt(50) : this.world.getHighestY(xx, zz);
                if (this.world.getBlock(xx, yy, zz) != topBlock || !this.world.isAir(xx, yy + 1, zz)) continue;
                this.world.setBlock(xx, yy + 1, zz, BlockList.crossed_decoration, 3);
            }
            for (attempt = 0; attempt < 85; ++attempt) {
                xx = this.getRandomXZ(this.rand, 0);
                zz = this.getRandomXZ(this.rand, 0);
                int n = yy = attempt > 60 ? 10 + this.rand.nextInt(50) : this.world.getHighestY(xx, zz);
                if (this.world.getBlock(xx, yy, zz) != topBlock || !this.world.isAir(xx, yy + 1, zz)) continue;
                this.world.setBlock(xx, yy + 1, zz, BlockList.crossed_decoration, 4);
            }
            for (attempt = 0; attempt < 80; ++attempt) {
                xx = this.getRandomXZ(this.rand, 0);
                zz = this.getRandomXZ(this.rand, 0);
                int n = yy = attempt > 50 ? 10 + this.rand.nextInt(50) : this.world.getHighestY(xx, zz);
                if (this.world.getBlock(xx, yy, zz) != topBlock || !this.world.isAir(xx, yy + 1, zz)) continue;
                this.world.setBlock(xx, yy + 1, zz, BlockList.crossed_decoration, 5);
            }
        }
    }

    public void genRavaged() {
        int attempt;
        for (attempt = 0; attempt < 20 && !this.generateStructure(this.genRavagedDungeon); ++attempt) {
        }
        this.genTree.setCanGenerateFace(false).setLooseSpaceCheck(false);
        int placed = 0;
        for (attempt = 0; attempt < 1600 && placed < 420; ++attempt) {
            this.genTree.setTreeType(this.rand.nextInt(4) == 0 ? StructureSpookyTree.TreeType.SIMPLE_PYRAMID : (this.rand.nextBoolean() ? StructureSpookyTree.TreeType.SIMPLE_BULGING : StructureSpookyTree.TreeType.SIMPLE_SPHERICAL));
            if (!this.generateStructure(this.genTree)) continue;
            ++placed;
        }
        int pickAmount = this.rand.nextInt(50) + 240;
        for (int pick = 0; pick < pickAmount; ++pick) {
            int xx = this.getRandomXZ(this.rand, 48);
            int zz = this.getRandomXZ(this.rand, 48);
            int yy = 8 + this.rand.nextInt(30);
            int type = this.rand.nextInt(3);
            for (int yTest = 0; yTest < 40 && this.world.getBlock(xx, yy++, zz) != topBlock && yy < 60; ++yTest) {
            }
            int attemptAmount = 70 + this.rand.nextInt(80);
            for (int attempt2 = 0; attempt2 < attemptAmount; ++attempt2) {
                int meta;
                int pz;
                int py;
                int px = xx + this.rand.nextInt(4 + (attempt2 >> 2)) - this.rand.nextInt(4 + (attempt2 >> 2));
                if (this.world.getBlock(px, py = yy + this.rand.nextInt(4 + (attempt2 >> 5)) - this.rand.nextInt(4 + (attempt2 >> 5)), pz = zz + this.rand.nextInt(4 + (attempt2 >> 2)) - this.rand.nextInt(4 + (attempt2 >> 2))) != topBlock || !this.world.isAir(px, py + 1, pz)) continue;
                int n = type == 0 ? 5 : (meta = type == 1 ? 3 : 4);
                if (this.rand.nextInt(8) == 0) {
                    int newType = this.rand.nextInt(3);
                    meta = newType == 0 ? 5 : (newType == 1 ? 3 : 4);
                }
                this.world.setBlock(px, py + 1, pz, BlockList.crossed_decoration, meta);
            }
        }
        for (int cx = 0; cx < this.world.getChunkAmountX(); ++cx) {
            for (int cz = 0; cz < this.world.getChunkAmountZ(); ++cz) {
                for (int attempt3 = 0; attempt3 < 120; ++attempt3) {
                    int xx = cx * 16 + this.rand.nextInt(16);
                    int zz = cz * 16 + this.rand.nextInt(16);
                    int yy = 10 + this.rand.nextInt(50);
                    if (this.world.getBlock(xx, yy - 1, zz) != topBlock) continue;
                    int type = this.rand.nextInt(3);
                    this.world.setBlock(xx, yy, zz, BlockList.crossed_decoration, type == 0 ? 5 : (type == 1 ? 3 : 4));
                }
            }
        }
    }

    public void genRuins() {
        int attempt;
        for (attempt = 0; attempt < 280; ++attempt) {
            this.generateStructure(this.genBush);
        }
        for (int cx = 0; cx < this.world.getChunkAmountX(); ++cx) {
            for (int cz = 0; cz < this.world.getChunkAmountZ(); ++cz) {
                int amount = 14 + this.rand.nextInt(7);
                for (int attempt2 = 0; attempt2 < amount; ++attempt2) {
                    this.generateStructure(this.genRuinPillar.setIsDeep(this.rand.nextInt(20) == 0));
                }
            }
        }
        this.genTree.setCanGenerateFace(false).setLooseSpaceCheck(false);
        for (attempt = 0; attempt < 650; ++attempt) {
            this.genTree.setTreeType(StructureSpookyTree.TreeType.values[this.rand.nextInt(StructureSpookyTree.TreeType.values.length)]);
            this.generateStructure(this.genTree);
        }
        int bulk = 0;
        for (int bulkAttempt = 0; bulkAttempt < 18 && bulk < 4 + this.rand.nextInt(3); ++bulkAttempt) {
            int xx = this.getRandomXZ(this.rand, 16);
            int zz = this.getRandomXZ(this.rand, 16);
            int yy = 10 + this.rand.nextInt(30);
            boolean generates = false;
            int testY = 0;
            while (testY < 40) {
                if (this.world.getBlock(xx, yy, zz) == topBlock) {
                    generates = true;
                    break;
                }
                ++testY;
                ++yy;
            }
            if (!generates) continue;
            double density = 12.0 + this.rand.nextDouble() * this.rand.nextDouble() * 6.0;
            int totalAttempts = (int)(18.0 * density);
            block7: for (int attempt3 = 0; attempt3 < totalAttempts; ++attempt3) {
                int px = xx + (int)((double)(this.rand.nextInt(20) - this.rand.nextInt(20)) * this.rand.nextGaussian() * (2.0 * (double)attempt3 / (double)totalAttempts));
                int pz = zz + (int)((double)(this.rand.nextInt(20) - this.rand.nextInt(20)) * this.rand.nextGaussian() * (2.0 * (double)attempt3 / (double)totalAttempts));
                if (Math.abs(px - xx) > 25 || Math.abs(pz - zz) > 25) continue;
                for (int py = yy - 1 - this.rand.nextInt(4); py < yy + 4; ++py) {
                    if (this.world.getBlock(px, py, pz) != topBlock) continue;
                    this.genRuinPillar.setIsDeep(this.rand.nextInt(6) == 0);
                    this.genRuinPillar.setForcedCoords(px, py + 1, pz);
                    this.generateStructure(this.genRuinPillar);
                    continue block7;
                }
            }
            ++bulk;
        }
        for (attempt = 0; attempt < 1000; ++attempt) {
            int xx = this.getRandomXZ(this.rand, 0);
            int zz = this.getRandomXZ(this.rand, 0);
            int yy = 0;
            boolean canGenerate = false;
            for (int yAttempt = 0; yAttempt < 15; ++yAttempt) {
                yy = 15 + this.rand.nextInt(45);
                if (!this.world.isAir(xx, yy, zz)) continue;
                canGenerate = true;
                break;
            }
            if (!canGenerate) continue;
            block11: for (int checkX = xx - 2; checkX <= xx + 2; ++checkX) {
                for (int checkZ = zz - 2; checkZ <= zz + 2; ++checkZ) {
                    if (this.world.isAir(checkX, yy, checkZ)) continue;
                    this.world.setBlock(xx, yy, zz, Blocks.field_150321_G);
                    checkX += 9;
                    continue block11;
                }
            }
        }
        for (attempt = 0; attempt < 42; ++attempt) {
            this.genRuinBuild.setStructureType(StructureRuinBuild.RuinStructureType.WALL);
            this.generateStructure(this.genRuinBuild);
        }
    }
}

