/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.packets;

import chylex.hee.HardcoreEnderExpansion;
import chylex.hee.packets.AbstractPacket;
import chylex.hee.system.logging.Stopwatch;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.FMLEmbeddedChannel;
import cpw.mods.fml.common.network.FMLEventChannel;
import cpw.mods.fml.common.network.FMLNetworkEvent;
import cpw.mods.fml.common.network.FMLOutboundHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.internal.FMLProxyPacket;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gnu.trove.map.hash.TByteObjectHashMap;
import gnu.trove.map.hash.TObjectByteHashMap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.tileentity.TileEntity;
import org.apache.commons.io.FilenameUtils;

public class PacketPipeline {
    private static PacketPipeline instance;
    private static final String channelName = "hee";
    private FMLEventChannel eventDrivenChannel;
    private EnumMap<Side, FMLEmbeddedChannel> channels;
    private final TByteObjectHashMap<Class<? extends AbstractPacket>> idToPacket = new TByteObjectHashMap();
    private final TObjectByteHashMap<Class<? extends AbstractPacket>> packetToId = new TObjectByteHashMap();

    public static synchronized void initializePipeline() {
        if (instance != null) {
            throw new RuntimeException("Packet pipeline has already been registered!");
        }
        instance = new PacketPipeline();
        instance.load();
    }

    private PacketPipeline() {
    }

    private void load() {
        Stopwatch.time("PacketPipeline");
        this.eventDrivenChannel = NetworkRegistry.INSTANCE.newEventDrivenChannel(channelName);
        this.eventDrivenChannel.register((Object)this);
        try {
            Field channelField = FMLEventChannel.class.getDeclaredField("channels");
            channelField.setAccessible(true);
            this.channels = (EnumMap)channelField.get(this.eventDrivenChannel);
            int id = -1;
            File sourceFile = HardcoreEnderExpansion.sourceFile;
            ArrayList<String> classes = new ArrayList<String>();
            if (sourceFile.isDirectory()) {
                File root = Paths.get(sourceFile.getPath(), "chylex", channelName, "packets").toFile();
                for (String name : new File(root, "client").list()) {
                    if (!name.startsWith("C")) continue;
                    classes.add("chylex.hee.packets.client." + FilenameUtils.removeExtension((String)name));
                }
                for (String name : new File(root, "server").list()) {
                    if (!name.startsWith("S")) continue;
                    classes.add("chylex.hee.packets.server." + FilenameUtils.removeExtension((String)name));
                }
            } else {
                try (ZipFile zip = new ZipFile(sourceFile);){
                    for (ZipEntry zipEntry : Collections.list(zip.entries())) {
                        String name = zipEntry.getName();
                        if (!name.startsWith("chylex/hee/packets/") || !name.startsWith("chylex/hee/packets/client/C") && !name.startsWith("chylex/hee/packets/server/S")) continue;
                        classes.add(FilenameUtils.removeExtension((String)name.replace('/', '.')));
                    }
                }
            }
            Collections.sort(classes);
            for (String cls : classes) {
                this.registerPacket(++id, Class.forName(cls));
            }
        }
        catch (IOException | ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchFieldException e) {
            throw new RuntimeException("Unable to load the Packet system!", e);
        }
        Stopwatch.finish("PacketPipeline");
    }

    private void registerPacket(int id, Class<? extends AbstractPacket> cls) {
        this.idToPacket.put((byte)id, cls);
        this.packetToId.put(cls, (byte)id);
    }

    private FMLProxyPacket writePacket(AbstractPacket packet) {
        ByteBuf buffer = Unpooled.buffer();
        buffer.writeByte((int)this.packetToId.get(packet.getClass()));
        packet.write(buffer);
        return new FMLProxyPacket(buffer, channelName);
    }

    private void readPacket(FMLProxyPacket fmlPacket, Side side) {
        ByteBuf buffer = fmlPacket.payload();
        try {
            AbstractPacket packet = (AbstractPacket)((Class)this.idToPacket.get(buffer.readByte())).newInstance();
            packet.read(buffer.slice());
            switch (side) {
                case CLIENT: {
                    packet.handle(Side.CLIENT, this.getClientPlayer());
                    break;
                }
                case SERVER: {
                    packet.handle(Side.SERVER, (EntityPlayer)((NetHandlerPlayServer)fmlPacket.handler()).field_147369_b);
                }
            }
        }
        catch (IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private EntityPlayer getClientPlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    @SubscribeEvent
    public void onClientPacketReceived(FMLNetworkEvent.ClientCustomPacketEvent e) {
        this.readPacket(e.packet, Side.CLIENT);
    }

    @SubscribeEvent
    public void onServerPacketReceived(FMLNetworkEvent.ServerCustomPacketEvent e) {
        this.readPacket(e.packet, Side.SERVER);
    }

    public static void sendToAll(AbstractPacket packet) {
        FMLEmbeddedChannel channel = PacketPipeline.instance.channels.get(Side.SERVER);
        channel.attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALL);
        channel.writeAndFlush((Object)instance.writePacket(packet)).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
    }

    public static void sendToPlayer(EntityPlayer player, AbstractPacket packet) {
        FMLEmbeddedChannel channel = PacketPipeline.instance.channels.get(Side.SERVER);
        channel.attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.PLAYER);
        channel.attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)player);
        channel.writeAndFlush((Object)instance.writePacket(packet)).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
    }

    public static void sendToAllAround(int dimension, double x, double y, double z, double range, AbstractPacket packet) {
        FMLEmbeddedChannel channel = PacketPipeline.instance.channels.get(Side.SERVER);
        channel.attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALLAROUNDPOINT);
        channel.attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)new NetworkRegistry.TargetPoint(dimension, x, y, z, range));
        channel.writeAndFlush((Object)instance.writePacket(packet)).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
    }

    public static void sendToAllAround(Entity entity, double range, AbstractPacket packet) {
        FMLEmbeddedChannel channel = PacketPipeline.instance.channels.get(Side.SERVER);
        channel.attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALLAROUNDPOINT);
        channel.attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)new NetworkRegistry.TargetPoint(entity.field_71093_bK, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, range));
        channel.writeAndFlush((Object)instance.writePacket(packet)).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
    }

    public static void sendToAllAround(TileEntity tile, double range, AbstractPacket packet) {
        FMLEmbeddedChannel channel = PacketPipeline.instance.channels.get(Side.SERVER);
        channel.attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALLAROUNDPOINT);
        channel.attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)new NetworkRegistry.TargetPoint(tile.func_145831_w().field_73011_w.field_76574_g, (double)tile.field_145851_c + 0.5, (double)tile.field_145848_d + 0.5, (double)tile.field_145849_e + 0.5, range));
        channel.writeAndFlush((Object)instance.writePacket(packet)).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
    }

    public static void sendToDimension(int dimension, AbstractPacket packet) {
        FMLEmbeddedChannel channel = PacketPipeline.instance.channels.get(Side.SERVER);
        channel.attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.DIMENSION);
        channel.attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)dimension);
        channel.writeAndFlush((Object)instance.writePacket(packet)).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
    }

    public static void sendToServer(AbstractPacket packet) {
        FMLEmbeddedChannel channel = PacketPipeline.instance.channels.get(Side.CLIENT);
        channel.attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.TOSERVER);
        channel.writeAndFlush((Object)instance.writePacket(packet)).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
    }
}

