/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.mechanics.misc;

import chylex.hee.entity.mob.EntityMobHomelandEnderman;
import chylex.hee.entity.technical.EntityTechnicalBiomeInteraction;
import chylex.hee.system.util.ColorUtil;
import chylex.hee.world.structure.island.biome.interaction.BiomeInteractionEnchantedIsland;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public final class HomelandEndermen {
    public static boolean isOvertakeHappening(EntityMobHomelandEnderman source) {
        return HomelandEndermen.getOvertakeGroup(source) != -1L;
    }

    public static long getOvertakeGroup(EntityMobHomelandEnderman source) {
        List list = source.field_70170_p.func_72872_a(EntityTechnicalBiomeInteraction.class, source.field_70121_D.func_72314_b(260.0, 128.0, 260.0));
        if (!list.isEmpty()) {
            for (EntityTechnicalBiomeInteraction entity : list) {
                if (entity.getInteractionType() != BiomeInteractionEnchantedIsland.InteractionOvertake.class || entity.field_70173_aa <= 2) continue;
                return ((BiomeInteractionEnchantedIsland.InteractionOvertake)entity.getInteraction()).groupId;
            }
        }
        return -1L;
    }

    public static List<EntityMobHomelandEnderman> getAll(EntityMobHomelandEnderman source) {
        List all = source.field_70170_p.func_72872_a(EntityMobHomelandEnderman.class, source.field_70121_D.func_72314_b(260.0, 128.0, 260.0));
        return all;
    }

    public static List<EntityMobHomelandEnderman> getByHomelandRole(EntityMobHomelandEnderman source, HomelandRole role) {
        List<EntityMobHomelandEnderman> all = HomelandEndermen.getAll(source);
        ArrayList<EntityMobHomelandEnderman> filtered = new ArrayList<EntityMobHomelandEnderman>();
        for (EntityMobHomelandEnderman enderman : all) {
            if (enderman.getHomelandRole() != role) continue;
            filtered.add(enderman);
        }
        return filtered;
    }

    public static List<EntityMobHomelandEnderman> getInSameGroup(EntityMobHomelandEnderman source) {
        List<EntityMobHomelandEnderman> all = HomelandEndermen.getAll(source);
        ArrayList<EntityMobHomelandEnderman> filtered = new ArrayList<EntityMobHomelandEnderman>();
        for (EntityMobHomelandEnderman enderman : all) {
            if (!enderman.isInSameGroup(source)) continue;
            filtered.add(enderman);
        }
        return filtered;
    }

    public static List<EntityMobHomelandEnderman> getByGroupRole(EntityMobHomelandEnderman source, OvertakeGroupRole role) {
        List<EntityMobHomelandEnderman> all = HomelandEndermen.getAll(source);
        ArrayList<EntityMobHomelandEnderman> filtered = new ArrayList<EntityMobHomelandEnderman>();
        for (EntityMobHomelandEnderman enderman : all) {
            if (!enderman.isInSameGroup(source) || enderman.getGroupRole() != role) continue;
            filtered.add(enderman);
        }
        return filtered;
    }

    private HomelandEndermen() {
    }

    public static enum HomelandRole {
        WORKER(227),
        ISLAND_LEADERS(58),
        GUARD(0),
        COLLECTOR(176),
        OVERWORLD_EXPLORER(141),
        BUSINESSMAN(335),
        INTELLIGENCE(275);

        public static final HomelandRole[] values;
        public final float red;
        public final float green;
        public final float blue;

        public static HomelandRole getRandomRole(Random rand) {
            HomelandRole role = WORKER;
            if (rand.nextInt(10) == 0) {
                role = OVERWORLD_EXPLORER;
            } else if (rand.nextInt(7) == 0) {
                role = BUSINESSMAN;
            } else if (rand.nextInt(6) == 0) {
                role = COLLECTOR;
            } else if (rand.nextInt(5) == 0) {
                role = INTELLIGENCE;
            } else if (rand.nextInt(7) <= 2) {
                role = GUARD;
            }
            return role;
        }

        private HomelandRole(int hue) {
            float[] col = ColorUtil.hsvToRgb((float)hue / 359.0f, 0.78f, 0.78f);
            this.red = col[0];
            this.green = col[1];
            this.blue = col[2];
        }

        static {
            values = HomelandRole.values();
        }
    }

    public static enum OvertakeGroupRole {
        LEADER,
        CHAOSMAKER,
        FIGHTER,
        TELEPORTER;

        public static final OvertakeGroupRole[] values;

        public static OvertakeGroupRole getRandomMember(Random rand) {
            int r = rand.nextInt(20);
            if (r < 12) {
                return FIGHTER;
            }
            if (r < 17) {
                return TELEPORTER;
            }
            return CHAOSMAKER;
        }

        static {
            values = OvertakeGroupRole.values();
        }
    }

    public static enum EndermanTask {
        NONE,
        RECRUIT_TO_GROUP,
        LISTEN_TO_RECRUITER,
        STROLL,
        WALK,
        COMMUNICATE,
        WAIT,
        GET_TNT;

    }
}

